/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "vars.h"

/*--- coef cmd ---------------------------*/

boolean moneq(exp, t, vars)	/* if return TRUE, sets exponent of each */
expterm exp ;			/* var in "vars", of "t" to 0 */
term t ;
expterm vars ;	/* if vars[i] != 0, "i" is in "vars" */
{
    int i ;
    expterm exp2 ;

    sToExp(t, exp2) ;
    for (i=0; i<numvars; i++) {
	if (vars[i] IS 0) continue ;
	if (exp[i] ISNT exp2[i])
	    return(FALSE) ;
	else exp2[i] = 0 ;
    }
    expToS(exp2, tm_component(t), t) ;
    return(TRUE) ;
}

poly strip_poly(f, vars, hmonom)
poly *f ;
expterm vars ;
poly *hmonom ;
{
        int i ;
	poly result, temp ;
	expterm exp ;
	poly inresult ;
	char *polyhead ;	/* used as list head */

	if (*f IS NULL) return(NULL) ;
	inresult = (poly) &polyhead ;
	inresult->next = *f ;
	sToExp(INITIAL(*f), exp) ;
	result = NULL ;

	for (i=0; i<numvars; i++)
	    if (vars[i] IS 0)
	        exp[i] = 0 ;
	*hmonom = p_monom(fd_one) ;
	expToS(exp, 1, INITIAL(*hmonom)) ;

	while (inresult->next ISNT NULL) 
		if (moneq(exp, INITIAL(inresult->next), vars)) {
			temp = inresult->next ;
			inresult->next = temp->next ;
			temp->next = NULL ;
			p_add(&result, &temp) ;
		} else inresult = inresult->next ;
	*f = (poly) polyhead ;
	return(result) ;
}

gm_coef(M, vars, Mmonoms, Mcoefs)
gmatrix M ;
expterm vars ;
gmatrix *Mmonoms, *Mcoefs ;
{
	poly f, g, hmonom ;
	int j ;

	*Mmonoms = mod_init() ;
	dl_insert(&(*Mmonoms)->degrees, 0) ;
	*Mcoefs = mod_init() ;
	dl_copy(&(M->degrees), &((*Mcoefs)->degrees)) ;
	for (j=1; j<=length(&(M->gens)); j++) {
		f = p_copy(PREF(M->gens, j)) ;
		while (f ISNT NULL) {
			g = strip_poly(&f, vars, &hmonom) ;
			gmInsert(*Mmonoms, hmonom) ;
			gmInsert(*Mcoefs, g) ;
		}
	}
}

coef_cmd(argc, argv)
int argc ;
char *argv[] ;
{
    gmatrix M ;
    gmatrix Mmonoms, Mcoefs ;
    variable *p, *q ;
    expterm vars ;
    
    if (argc <= 3) {
	printnew(
	    "coef <matrix> <result monoms> <result coefs> [variable list]\n");
	return ;
    }
    GET_MOD(M, 1) ;
    NEW_MOD(p, 2) ;
    NEW_MOD(q, 3) ;
    if (NOT(getVarList(argc-4, argv+4, vars))) return ;
    gm_coef(M, vars, &Mmonoms, &Mcoefs) ;
    set_value(p, Mmonoms) ;
    set_value(q, Mcoefs) ;
}

poly p_homog(M, f, v)
gmatrix M ;
poly f ;
int v ;
{
    poly g, h, temp, result ;
    int d, maxd, a ;
    expterm exp ;
    allocterm t ;

    if (f IS NULL) return(NULL) ;
    g = f ;
    maxd = degree(M, g) ;
    while (g ISNT NULL) {
	d = degree(M, g) ;
	if (d > maxd)
		maxd = d ;
	g = g->next ;
    }

    g = f ;
    result = NULL ;
    while (g ISNT NULL) {
	d = maxd - degree(M, g) ;
	/* the following should be in poly.c or term.c */
	for (a=0; a<numvars; a++) exp[a] = 0 ;
	exp[v] = d ;
	expToS(exp, 1,  t) ;
	temp = g ;
	g = g->next ;
	temp->next = NULL ;
	h = p1_mult(fd_one, t, temp) ;
	temp->next = g ;
	p_add(&result, &h) ;
    }
    qrgReduce(&result) ;
    return(result) ;
}

gmatrix gm_homog(M, v)
gmatrix M ;
int v ;		/* use this var as homog. variable */
{
	gmatrix N ;	/* result */
	int j ;
	poly f, g ;

	N = mod_init() ;
	dl_copy(&(M->degrees), &(N->degrees)) ;
	for (j=1; j<=length(&(M->gens)); j++) {
		f = PREF(M->gens, j) ;
		if (f IS NULL) continue ;
		g = p_homog(M, f, v) ;
		pl_insert(&(N->gens), g) ;
		dl_insert(&(N->deggens), degree(N, g)) ;
	}
	return(N) ;
}

homog_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	gmatrix M ;
	variable *p ;
	int v ;

	if (argc ISNT 4) {
		printnew("homog <matrix> <homog variable> <new matrix>\n") ;
		return ;
	}
	GET_MOD(M, 1) ;
	v = getVar(argv[2]) ;
	if (v IS -1) {
		prerror("; var %s not defined\n", argv[2]) ;
		return ;
	}
	NEW_MOD(p, 3) ;
	set_value(p, (ADDRESS) gm_homog(M, v)) ;
}

/*--- intersections, ideal quotients, and tensor products ------*/

/*
intersect_cmd(argc, argv)
int argc ;
char *argv[] ;
{
    if (argc < 3) {
	printnew("intersect <matrix 1> ... <matrix n> <computation>\n") ;
	return ;
    }
    GET_MOD(M, 1) ;
    r = nrows(M) ;
    mat = gm_intmat(M) ;
    for (i=2; i<argc-1; i++) {
	GET_MOD(M, i) ;
	if (r ISNT nrows(M)) {
	    prerror("; matrix #%d has wrong number of rows\n", i) ;
	    mod_kill(M) ;
	    return ;
	}
	gm_int2(mat, M) ;
    }

}*/
