/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "hull.h"

int h_n;  /* number of variables in ring */
int h_phase;  /* state of algorithm (0, 1, 2, ...) */
int h_count = 0;  /* number of bases computed */
int h_i;  /* loop variable */
matrix *h_p;  /* results of first 8 std bases */
matrix *h_s;  /* result of simplex */
facet **h_t;  /* polytope itself */
facet *h_f;  /* current facet under study */
FILE *h_fout;  /* open output file for polytope */
char *h_linkstash, *h_facetstash, *h_vecstash;

long h_dirs[8][4] = {
	{ 1, 0, 0, 0 },
	{ 0, 1, 0, 0 },
	{ 0, 0, 1, 0 },
	{ 0, 0, 0, 1 },
	{ 0, 1, 1, 1 },
	{ 1, 0, 1, 1 },
	{ 1, 1, 0, 1 },
	{ 1, 1, 1, 0 }
};

int
i_hull(numvars, fp)
int numvars;
FILE *fp;
{
	char *open_stash();
	
	if (numvars != 4) {
		printf("not implemented for other than four variables\n");
		return 0;
	}
	h_linkstash = open_stash(sizeof(link), "hull links");
	h_facetstash = open_stash(sizeof(facet), "hull facets");
	h_vecstash = open_stash(sizeof(vector)+3*sizeof(long), "hull vectors");
	h_fout = fp;
	h_n = numvars;
	h_p = new_matrix(8,4);
	h_phase = 0;
	h_count = 0;
	return 1;
}

long
howbig(v)
vector *v;
{
	/* how big is v ? */
	long m, d, w[4];
	int i;
	
	m = v->v[0];
	for (i=1; i<4; ++i) m = (v->v[i] > m ? v->v[i] : m);
	for (i=0; i<4; ++i) w[i] = m - v->v[i];
	d = 0;
	for (i=0; i<4; ++i) d = gcd_long(d, w[i]);
	if (d != 0)
		for (i=0; i<4; ++i) w[i] /= d;
	m = 0;
	for (i=0; i<4; ++i) m = (w[i] > m ? w[i] : m);
	return m;	
}

void
vnorm(v, w)
vector *v;
long *w;
{
	/* normalize w = -v, all positive by adding (m,...,m) */
	long m, d;
	int i;
	
	m = 0;
	for (i=0; i<4; ++i) m = (v->v[i] > m ? v->v[i] : m);
	for (i=0; i<4; ++i) w[i] = m - v->v[i];
	d = 0;
	for (i=0; i<4; ++i) d = gcd_long(d, w[i]);
	if (d != 0)
		for (i=0; i<4; ++i) w[i] /= d;
}

static long x[4];

long *
hull_question(tullexp)
long *tullexp;
{
	int i;
	vector *v, *w;
	long mini, newi;
	facet *fap;
	
	/*
		phase 0 : first call
		phase 1 : asking 8 standard questions
		phase 2 : form polytope simplex
		phase 3 : growing polytope
	*/
	if (h_phase == 0) {
		h_phase = 1;
		h_i = 0;
		return h_dirs[h_i];
	}
	else if (h_phase == 1) {
		for (i=0; i<h_n; ++i)
			h_p->v[h_i]->v[i] = tullexp[i];
		if (h_i == 7)
			h_phase = 2;
		else
			return h_dirs[++h_i];
	}
	if (h_phase == 2) {
		h_s = simplex(h_p);
		h_t = tope3(h_s);
		h_phase = 3;

		for (fap = h_t[h_n-2]; fap != NULL; fap = fap->p)
			if (fap->verified != 1) break;
		h_f = fap;
		mini = (h_f) != NULL ? howbig(h_f->v): 0;
		for (fap = h_f; fap != NULL; fap = fap->p)
			if (fap->verified != 1) {
				newi = howbig(fap->v);
				if (newi < mini) {
					h_f = fap;
					mini = newi;
				}
			}
			
		if (h_f == NULL) { 
			printf("jeez, this shouldn't happen\n"); 
			h_phase == 4; /* doesn't happen ?! */
		}
		else {
			vnorm(h_f->v, x);
			return x;
		}
	}
	if (h_phase == 3) {
		ERROR_IF(h_n != 4, "question");
		v = new_vector(h_n);
		for (i=0; i<h_n; ++i)
			v->v[i] = tullexp[i];
		if (h_f->c == dot_prod(v,h_f->v)) {
			h_f->verified = 1;
		}
		else {
			w = copy_vector(v);
			adjoin_vertex(h_t, w, h_n-1);
		}
		count_tope(h_t);

		for (fap = h_t[h_n-2]; fap != NULL; fap = fap->p)
			if (fap->verified != 1) break;
		h_f = fap;
		mini = (h_f) != NULL ? howbig(h_f->v): 0;
		for (fap = h_f; fap != NULL; fap = fap->p)
			if (fap->verified != 1) {
				newi = howbig(fap->v);
				if (newi < mini) {
					h_f = fap;
					mini = newi;
				}
			}
			
		if (h_f != NULL){
			vnorm(h_f->v, x);
			return x;
		}
		/* h_f == NULL */
		output_tope(h_t);
		return NULL;
	}
}	
