/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "style.h"
#include "parse.h"

/* these mean: $int pol   +  -  *  /  %  ^  (  )  u- u+*/
/*int fprec[] = {0, 10, 10, 3, 3, 5, 5, 5, 5, 1, 9, 5, 5} ;
int gprec[] = {0,  9,  9, 2, 2, 4, 4, 4, 6, 8, 1, 7, 7} ;

int nargs[] = {0, 1, 1, 2, 2, 2, 2, 2, 2, 0, 0, 1, 0} ;
*/

/* these mean: $int pol  < <= > >= = !=    +  -  *  /  %  ^  (  )  u- u+ NOT*/
int fprec[] = {0, 10, 10, 3,3,3,3,3,3,     5, 5, 7, 7, 7, 7, 1, 11, 7, 7, 7} ;
int gprec[] = {0,  9,  9, 2,2,2,2,2,2,     4, 4, 6, 6, 6, 8, 10, 1, 9, 9, 9} ;

int nargs[] = {0, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 1, 0, 1} ;

/* variables used in parsing */

int thistok ;	/* one of LXEOI, ..., LXUMINUS */
int thisval ;	/* if thistok = LXINT, this is the integer that it is */
int parenlevel ; /* should never be negative.  End value should be 0 */

stack opStack ;	/* operator stack */
stack valStack ; /* value stack */

char *beginStr ; /* begin of input string: used to display errors */
jmp_buf jmpparse ; /* used to leave parsing once error is found */

/*---------------------------------------------------------------
 *
 *  stack routines 
 *
 *---------------------------------------------------------------*/

boolean emptyStack(st)
stack *st ;
{
    return(st->tos IS -1) ;
}

initStack(st)
stack *st ;
{
    st->tos = -1 ;
}

int pop(st)
stack *st ;
{
    register int val ;

    val = st->vals[st->tos] ;
    st->tos-- ;
    return(val) ;
}

push(st, val)
stack *st ;
int val ;
{
    st->tos++ ;
    st->vals[st->tos] = val ;
}

int tos(st)
stack *st ;
{
    return(st->vals[st->tos]) ;
}

/*---------------------------------------------------------------
 *
 *  getNext -- get next token from input string "parseStr"
 *
 *---------------------------------------------------------------*/

boolean isunary(thistok)
int thistok ;
{
    return((thistok ISNT LXRP) AND (thistok ISNT LXINT)
	   AND (thistok ISNT LXPOLY)) ;
}

int collectInt(c, str)
char c ;
char **str ;
{
    int n ;

    n = c - '0' ;
    while (isdigit(c = *(*str)++ )) 
        n = 10*n + c - '0' ;
    (*str)-- ;
    return(n) ;
}

int get2(str, ch, tok1, tok2)
char **str ;
char ch ;
int tok1, tok2 ;
{
    char c ;
    
    c = *(*str)++ ;
    if (c IS ch)
      return(tok1) ;
    else {
	(*str)-- ;
	return(tok2) ;
    }
}

getNext(str)
char **str ;
{
    char c ;
    int lasttok ;
    char ident[100] ;

    lasttok = thistok ;
    c = *(*str)++ ;

    if (c IS '*') {
	if (**str IS '*') {
	    (*str)++ ;
	    thistok = LXEXP ;
	} else
	    thistok = LXMULT ;
    } else if (c IS '/')
        thistok = LXDIV ;
    else if (c IS '&')
        thistok = LXMOD ;
    else if (c IS '^')
	thistok = LXEXP ;
    else if (c IS '(') {
	parenlevel++ ;
	thistok = LXLP ;
    } else if (c IS ')') {
	if (parenlevel IS 0) {
	    thistok = LXEOI ;
	    (*str)-- ;
	} else {
	    parenlevel-- ;
	    thistok = LXRP ;
	}
    } else if (c IS '+') {
	if (isunary(thistok))
	    thistok = LXUPLUS ;
	else
	    thistok = LXPLUS ;
    } else if (c IS '-') {
	if (isunary(thistok))
	  thistok = LXUMINUS ;
	else 
	  thistok = LXMINUS ;
    } else if (c IS '>') 
	thistok = get2(str, '=', LXGE, LXGT) ;
    else if (c IS '<')
        thistok = get2(str, '=', LXLE, LXLT) ;
    else if (c IS '=')
        thistok = LXEQ ;
    else if (c IS '!')
        thistok = get2(str, '=', LXNE, LXNOT) ;
    else if (isdigit(c)) {
	thisval = collectInt(c, str) ;
	thistok = LXINT ;
    } else if (canStartVar(c)) {
	(*str)-- ;
	getIdentifier(str, ident) ;
	thistok = LXINT ;
	thisval = getIdVal(ident) ;
    } else {
	(*str)-- ;
        thistok = LXEOI ;
    }
    checkError(lasttok, thistok, *str) ;
}

/*---------------------------------------------------------------
 *
 *  parseErr -- display error message 
 *
 *---------------------------------------------------------------*/

boolean isBinOp(tok)
int tok ;
{
    return((tok >= LXPLUS) AND (tok <= LXEXP)) ;
}

boolean isOperator(tok)
int tok ;
{
    return(isBinOp(tok) OR (tok IS LXUMINUS)) ;
}

boolean checkError(lasttok, thistok, end)
int lasttok, thistok ;
char *end ;
{
    if (((lasttok IS LXINT) OR (lasttok IS LXRP))
	AND ((thistok IS LXINT) OR (thistok IS LXLP))) {
	parseErr(end, "missing operator") ;
	return(TRUE) ;
    }
    if (((isOperator(lasttok)) OR (lasttok IS LXLP))
	AND ((isBinOp(thistok)) OR (thistok IS LXRP))) {
	parseErr(end, "missing operand") ;
	return(TRUE) ;
    }
    return(FALSE) ;
}

      
parseErr(end, mess)
char *end, *mess ;
{
    int c ;

    c = *end ;
    *end = '\0' ;
    prerror("; %s at: %s\n", mess, beginStr) ;
    *end = c ;
    longjmp(jmpparse, -1) ;
}
    
/*---------------------------------------------------------------
 *
 *  doAction -- take action depending on operator
 *
 *---------------------------------------------------------------*/

doAction(op, parseStr)
int op ;
char *parseStr ;
{
    int i, n, val ;
    int args[NARGS] ;

    n = nargs[op] ;
    for (i=0; i<n; i++)
        if (emptyStack(&valStack)) {
	    parseErr(parseStr, "too few operands") ;
	    args[i] = 0 ;
	} else
	    args[i] = pop(&valStack) ;

    switch (op) {
      case LXEOI: 
      case LXLP:
      case LXRP:
      case LXUPLUS:
	break ;
      case LXEQ:
	push(&valStack, args[1] == args[0]) ;
	break ;
      case LXNE:
	push(&valStack, args[1] != args[0]) ;
	break ;
      case LXGT:
	push(&valStack, args[1] > args[0]) ;
	break ;
      case LXGE:
	push(&valStack, args[1] >= args[0]) ;
	break ;
      case LXLT:
	push(&valStack, args[1] < args[0]) ;
	break ;
      case LXLE:
	push(&valStack, args[1] <= args[0]) ;
	break ;
      case LXNOT:
	push(&valStack, NOT args[0]) ;
	break ;
      case LXPLUS:
	push(&valStack, args[1] + args[0]) ;
	break ;
      case LXMINUS:
	push(&valStack, args[1] - args[0]) ;
	break ;
      case LXMULT:
	push(&valStack, args[1] * args[0]) ;
	break ;
      case LXDIV:
	if (args[0] IS 0) {
	    prerror("; attempt to divide by zero\n") ;
	    push(&valStack, 0) ;
	} else
	    push(&valStack, args[1] / args[0]) ;
	break ;
      case LXMOD:
	if (args[0] IS 0) {
	    prerror("; attempt to divide by zero\n") ;
	    push(&valStack, args[1]) ;
	} else
	    push(&valStack, args[1] % args[0]) ;
	break ;
      case LXEXP:
	val = 1 ;
	for (i=1; i<=args[0]; i++)
	  val *= args[1] ;
	push(&valStack, val) ;
	break ;
      case LXUMINUS:
	push(&valStack, - args[0]) ;
	break ;
      default:
	prerror(";internal error: shouldn't get here\n") ;
    }
}

/*---------------------------------------------------------------
 *
 *  eatInt -- use operator precedence parsing to compute integer value
 *
 *  "str" is modified to point directly after integer computed.
 *
 *---------------------------------------------------------------*/

int eatInt(str)
char **str ;
{
    int a, lastop ;


    parenlevel = 0 ;
    thistok = LXEOI ;
    initStack(&opStack) ;
    push(&opStack, LXEOI) ;
    initStack(&valStack) ;

    beginStr = *str ; /* used for error messages */
    getNext(str) ;
    while (TRUE) {
	a = tos(&opStack) ;
	if ((thistok IS LXEOI) AND (a IS LXEOI)) {
	    if (emptyStack(&valStack)) {
		prerror("; missing operand\n") ;
		return(0) ;
	    } else
	        return(pop(&valStack)) ;
	}
	if (thistok IS LXINT) {
	    push(&valStack, thisval) ;
	    getNext(str) ;
	} else if (fprec[a] <= gprec[thistok]) {
	    push(&opStack, thistok) ;
	    getNext(str) ;
	} else {
	    do {
		lastop = pop(&opStack) ;
		doAction(lastop, *str) ;
	    } while (fprec[tos(&opStack)] >= gprec[lastop]) ;
	}
    }
}

int parseInt(str)
char **str ;
{
    int n ;

    if (setjmp(jmpparse))
      return(0) ;
    beginStr = *str ;
    n = eatInt(str) ;
    return(n) ;
}


int getInt(s)
char *s ;
{
    return(parseInt(&s)) ;
}

int readInt(str)
char **str ;
{
    int n ;

    n = parseInt(str) ;
    if (**str ISNT '\0') 
      prerror("; premature end of expression\n") ;
    return(n) ;
}


