/* 1994/3/16,17
   1994/4/27
   makefile : add Hack.c to SRC2 and OBJFILES
   poly.c : delete p_mult() and p1_mult().
   shell.c : add initHack() to reset_cmd() and do_init().
   cmds.c : add initN() to ring_cmd().
   term.c : change sToExp to return the component number. It's for debug.
   set.c : Commutative, M and Kformat. i_set(). It should be alphabetical order
   human_io.c : if Kformat, call kPrint(fil,f,comp) in p_pprint().
*/
/* Sample input
    ring R
    XYexyE

    poly f X(x+y)
*/
#define TODAY "1994/7/9,1995/4/7"
#include <stdio.h>
#include "types.h"
extern int nblocks;
extern int numvars;
extern int compLoc;
typedef long int arith;
typedef unsigned long smallmon;

int Commutative = 1;  /* refered from set.c */
int Kformat = 1;      /* refered from human_io.c */
int M = 0;

static int Homogenize = 1; 
static int DxGTx = 1;
static int Debug1 = 0;
static int DebugT = 0;
static int DebugCheck = 0;
static int L,N;
static int hnumvars;
static poly addnode2;

static int HeadStat = 0; /* for research */
static int HeadD[10] = {0,0,0,0,0,0,0,0,0,0}; /* for research */


stopH(s)
char *s;
{ char c;
  printf("\nStop at %s :type return to continue.\n",s);
  scanf("%c",&c);
}

printPolyH(f)
poly f;
{
  int i;
  printf("nblocks=%d\n",nblocks);
   while (f != NULL) {
     printf("coeff=%d\n",(int) f->coef);
     for (i=0; i<nblocks; i++) {
       printf("[%d]=%ld ",i, f->monom[i]);
     }
     print("\n\n");
     f = f->next;
   }
}

/*  /*H is the mark for hack in the source codes */

void *myMalloc(n)
int n; {
  void *m;
  m = (void *)malloc(n);
  /*m = GC_malloc(n);*/
  if (m == (void *)NULL) {
    fprintf(stderr,"\nmyMalloc: No more memory.\n");
    exit();
  }
  return(m);
}


/*---- monomial multiplications --------*/
#define WSIZE 500
#define POLY struct monomial **
#define MZERO (struct monomial *)0

struct exps {
  int x;
  int D;
};
struct monomial {
  int coeff;
  int compt;
  struct monomial *next;
  struct exps e[NVARS/2];
};

struct monomial2 {
  int coeff;
  int compt;
  struct monomial *next;
  struct exps e[NVARS/2-1];
};

static int Msize = sizeof(struct monomial) - sizeof(struct monomial2);

static struct monomial WorkR[WSIZE];
static struct monomial *Work[WSIZE];

poly kanToM1();
struct monomial *newMonom();
struct monomial *rnewMonom();
struct monomial *mOne();
struct monomial *mXpq();
struct monomial *mDpq();
POLY mToKan1();


initHack() {  /* It is called from do_init() and reset_cmd() of shell.c  */
  int i;
  static struct pol addnode2T;
  printf("\nMacaulay for D-modules.  N.Takayama (%s)\n",TODAY);
  /*printf("initHack(): p_mult and p1_mult are overloaded.\n");
  printf("Msize=%d.\n",Msize);*/
  for (i=0; i<WSIZE; i++) {
    Work[i] = &(WorkR[i]);
  }
  initN();
  initT();
  addnode2 = &addnode2T;
  printf("\n");
}

initN() {
  if (((numvars <= 1) || (numvars % 2 != 0)) && !Commutative) {
    fprintf(stderr,"Warning(Hack.c): Define a ring with an even number of variables.\n");
    Commutative = 1; N = numvars/2+1;
  }else{
    N = numvars/2;
  }
  hnumvars = N;
  L =0;
  if (M > N) {
    fprintf(stderr,"Warning: M > N. M is set to 0.\n");
  }
  /*printf("\ninitN():N=%d, M=%d and numvars=%d\n",N,M,numvars);*/
}

doHack() { /* called from shell.c. It's used for test. Usually, do nothing. */
   poly f;
   int size;
   POLY g;
   return; /* do nothing */

   /*size=mmwMult(mDpq(0,1),mXpq(0,2),Work,WSIZE);
   printPoly(Work,size);
   f = kanToM1(Work,size);
   g = mToKan1(f);
   printf("\nmToKan1: ");
   printPoly(g,pSize(g));*/
}


struct monomial *newMonom() {
  struct monomial *m;
  int i;
  m = (struct monomial *)
        myMalloc(sizeof(struct monomial)-Msize*(NVARS/2-numvars/2)+4*Msize);
    /* 4 for padding */
  /* The following are not necessary. */
  m->coeff = 1;
  m->compt = 1;
  for (i=0; i<N; i++) {
    m->e[i].x = 0;
    m->e[i].D = 0;
  }
  return(m);
}

struct monomial *rnewMonom() {
  struct monomial *m;
  int i;
  m = (struct monomial *)
        myMalloc(sizeof(struct monomial)-Msize*(NVARS/2-numvars/2)+4*Msize);
    /* 4 for padding */
  return(m);
}

void polyFree(f)
POLY f;
{
  int i;  
  if (f == (POLY) 0) return;
  for (i=0; f[i] != MZERO; i++) {
    free(f[i]);
  }
  free(f);
}

struct monomial *mOne() {
  struct monomial *m;
  int i;
  m = newMonom();
  m->coeff = 1;
  m->compt = 1;
  for (i=0; i<N; i++) {
    m->e[i].x = 0;
    m->e[i].D = 0;
  }
  return(m);
}

struct monomial *mDpq(p,q)
int p,q; {
  struct monomial *m;
  m = mOne();
  m->e[p].D = q;
  return(m);
}

struct monomial *mXpq(p,q)
int p,q; {
  struct monomial *m;
  m = mOne();
  m->e[p].x = q;
  return(m);
}

#define mymax(x,y) (x>y? x:y)

int mmwMult(f,g,work,wsize)
struct monomial *f;
struct monomial *g;
POLY work;
int wsize; {
/*  f*g --> work     , f and g are monomials */
/*  Warning. for pFree(). work is sorted. */
     /*
       a x^\alpha \partial^\beta b x^\gamma \partial^\delta
       = ab x^\alpha(\partial^\beta x^\gamma) \partial^\delta

       Remark for difference case:  if \beta =0 then \beta^0=1, \beta^1=1,....

       \partial^\beta x^\gamma
       = \sum_{k_L = 0}^{  \gamma_L  }
          \cdots
         \sum_{k_{M-1} = 0}^{ \gamma_{M-1}  }
	 \sum_{k_M = 0 } ^ { \min{ \beta_M, \gamma_M } }
          \cdots
         \sum_{k_{N-1} = 0}^{ \min{ \beta_{N-1}, \gamma_{N-1} } }
           {\choose {\gamma_L} {k_L}}
              \cdots
	   {\choose {\gamma_{M-1}} {k_{M-1}}}
	   {\choose {\beta_M} {k_M}}
	      \cdots
           {\choose {\beta_{N-1}} {k_{N-1}}}
	   \beta_L^{ k_L }
	      \cdots
	   \beta_{M-1}^{ k_{M-1} }
	   [ \gamma_{M}, k_{M} ]
	      \cdots
	   [ \gamma_{N-1}, k_{N-1} ]
	  x_0 ^{ \beta_0+\beta_1 \gamma_1 + \cdots + \beta_{L-1}\gamma_{L-1} }
	  x^{ (\gamma_1, \cdots, \gamma_{L-1}) }
	  x^{ (\gamma_L - k_L, \cdots, \gamma_{N-1} - k_{N-1}) }
	  \partial^{ (\beta_0, \cdots, \beta{M-1}) }
	  \partial^{ (\beta_M - k_M, \cdots, \beta_{N-1} - k_{N-1}) }

      where  [p,q] = p(p-1) \cdots [p-q+1]    if q \not= 0,
             [p,0] = 1.

      klim[i] = 0                                 0 <= i < L     q-var
      klim[i] = \gamma_i                          L <= i < M     difference
      klim[i] = \min{ \beta_i, \gamma_i }         M <= i < N     differential
      k[i]    = k_i
     */
     /*
       It may happen that the coefficients of the above Leipnitz identity
       are zero, because C language adds and multiplies integers by modulo
       machine integer size.  For example, if the type "int" is 16 bit, then
       100H \time 100H = 10000H = 0.
     */
     /*  {\choose {16} x} < 12870,
	 7! = 5040, 8! = 40320,
	 5^5 = 3125,
	 6^6 = 46656
     */


  int k[NVARS];      /* loop controle variables */
  int klim[NVARS];
  int cf[NVARS];   /* coefficients by binomial and pochhammer coeffs */
  int i;
  struct monomial *tmpmono;
  int ansp;
  int topLevel;
  int tcoeff;
  int cc;
  int degree,tmpdeg;

  
  /* initN();  Do it in the ring_cmd(): cmds.c */

  if (f == MZERO || g == MZERO) return( 0 );
  /*
  if (f->compt != 0 && g->compt != 0) {
    if (f->compt != g->compt) {
      fprintf(stderr,"\nWarning: mmwMult: components are different(%d,%d). returns 0.\n",f->compt,g->compt);
      return(0);
    }
  }
  */
  
  cc = (f->coeff)*(g->coeff); cc = (int) normalize((arith)cc);


  if (Commutative) {
    /* A special case --- commutative */
    for (i=0; i<N; i++) {
      work[0]->e[i].x = f->e[i].x + g->e[i].x;
      work[0]->e[i].D = f->e[i].D + g->e[i].D;
    }
    work[0]->coeff = cc;
    work[0]->compt = mymax(f->compt,g->compt);
    if (cc == 0) return(0); else return(1);
  }

  if (Homogenize) {
    degree = 0;
    for (i=0; i<N; i++) {
      degree += f->e[i].x + f->e[i].D + g->e[i].x + g->e[i].D;
    }
  }

  /* init for N multiple nest */
  for (i=0;i<L;i++) { /* Di q-variables */
    klim[i] = 0;
    k[i] = 0;
    cf[i] = 1;
  }
  for (i=L;i<M;i++) { /* Di difference variables */
    klim[i] =  g->e[i].x ;
    if (f->e[i].D == 0) klim[i] = 0;
    k[i] = 0;
    cf[i] = 1;
  }
  for (i=M;i<N;i++) { /* Di */
    klim[i] = (f->e[i].D > g->e[i].x) ? g->e[i].x : f->e[i].D ;
    if (g->e[i].x < 0) klim[i] = f->e[i].D; 
    k[i] = 0;
    cf[i] = 1;
  }
  ansp = -1; topLevel = 1;
  while (topLevel) {
    ++ansp;
    if (ansp > wsize-1) {
      fprintf(stderr,"\n mmwMult_NMW(). work area is to small \n");
      exit();
    }
    tcoeff = 1;
    for (i=0; i<N; i++) {
      tcoeff = tcoeff*(cf[i]); tcoeff = (int) normalize((arith)tcoeff);
    }
    tcoeff = tcoeff*cc; tcoeff = (int) normalize((arith)tcoeff);
    work[ansp]->coeff = tcoeff;     /* set coefficients */

    work[ansp]->compt = mymax(f->compt,g->compt);
    if (f->compt > 100 || g->compt > 100 || f->compt < -100 || g->compt < -100) {
      fprintf(stderr,"Warning. Ridiculous value of compt compLoc=%d, %d, %d. ",compLoc,f->compt,g->compt);
      exit();
    }


    work[ansp]->e[0].x = (f->e[0].x)+(g->e[0].x); /* for q-case. commutative */
    work[ansp]->e[0].D = (f->e[0].D)+(g->e[0].D);
    for (i=1; i<L; i++) {
      work[ansp]->e[0].x += (f->e[i].D)*(g->e[i].x) ;
      work[ansp]->e[i].x = f->e[i].x + g->e[i].x ;
      work[ansp]->e[i].D = f->e[i].D + g->e[i].D ;
    }
    for (i=L; i<M; i++) {
      work[ansp]->e[i].x = f->e[i].x + g->e[i].x - k[i];
      work[ansp]->e[i].D = f->e[i].D + g->e[i].D;
    }
    for (i=M; i<N; i++) {
      work[ansp]->e[i].x = f->e[i].x + g->e[i].x - k[i];
      work[ansp]->e[i].D = f->e[i].D + g->e[i].D - k[i];
    }

    if (Homogenize) {
      tmpdeg = 0;
      for (i=0; i<N; i++) {
	tmpdeg += work[ansp]->e[i].x + work[ansp]->e[i].D;
      }
      if (DxGTx) {
	work[ansp]->e[N-1].x += degree - tmpdeg;
      }else{
	work[ansp]->e[N-1].D += degree - tmpdeg;
      }
    }

    
    if (work[ansp]->coeff == 0) ansp--;
    
    /* Making a N multiple nest */
    for (i=N-1; i>=0; i--) {
      k[i]++;
      if (k[0] > klim[0]) {
	topLevel = 0; break; /* break while loops */
      }
      if (k[i] > klim[i]) {
	k[i]=0;

	if ((i>=0) && (i<L)) {cf[i] = 1;}
	if ((i>=L) && (i<M)) {
	  cf[i] = BiiComb(g->e[i].x,k[i])*BiiPower(f->e[i].D,k[i]);
          cf[i] = (int) normalize((arith)cf[i]);
	}
	/* compute new comb()*ipoch()*/
	if ((i>=M) && (i<N)) {
	  cf[i] = BiiComb(f->e[i].D,k[i])*BiiPoch(g->e[i].x,k[i]);
          cf[i] = (int) normalize((arith)cf[i]);
	}
      }else {

	if ((i>=0) && (i<L)) { cf[i] =1;}
	if ((i>=L) && (i<M)) {
	  cf[i] = BiiComb(g->e[i].x,k[i])*BiiPower(f->e[i].D,k[i]);
          cf[i] = (int) normalize((arith)cf[i]);
	}
	/* compute new comb()*ipoch()*/
	if ((i>=M) && (i<N)) {
	  cf[i] = BiiComb(f->e[i].D,k[i])*BiiPoch(g->e[i].x,k[i]);
          cf[i] = (int) normalize((arith)cf[i]);
	}

	break;
      }
    }
  }
  ++ansp;
  /*if (ansp != 1) fprintf(stderr,"Warning. poly mode???");*/
  return(ansp);
    
}

printPoly(f,size)
POLY f;
int size;
{
  int i,j;
  if (size == 0) printf("0");
  for (i=0; i<size; i++) {
    printf("   +%d",f[i]->coeff);
    for (j=0; j<N; j++) {
      if (f[i]->e[j].x) {
	printf(" x[%d]%d",j,f[i]->e[j].x);
      }
      if (f[i]->e[j].D) {
	printf(" D[%d]%d",j,f[i]->e[j].D);
      }
    }
    printf("<%d> ",f[i]->compt);
  }
  printf(" ");
}

int BiiComb(p,q) 
int p,q;  /* return pCq */ 
{
/**
 foo[n_]:=Block[{p,q,ans},
    ans={};
    For[p=0,p<=n,p++,ans=Append[ans,Table[Binomial[p,q],{q,0,n}]]];
    Return[ans];
 ]
**/
/* We assume that int is 32 bit */
static int table[26][26]=
{{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,4,6,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,5,10,10,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,6,15,20,15,6,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,7,21,35,35,21,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,8,28,56,70,56,28,8,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,9,36,84,126,126,84,36,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,10,45,120,210,252,210,120,45,10,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,11,55,165,330,462,462,330,165,55,11,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,12,66,220,495,792,924,792,495,220,66,12,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,13,78,286,715,1287,1716,1716,1287,715,286,78,13,1,0,0,0,0,0,0,0,0,0,0,0,0},
{1,14,91,364,1001,2002,3003,3432,3003,2002,1001,364,91,14,1,0,0,0,0,0,0,0,0,0,0,0},
{1,15,105,455,1365,3003,5005,6435,6435,5005,3003,1365,455,105,15,1,0,0,0,0,0,0,0,0,0,0},
{1,16,120,560,1820,4368,8008,11440,12870,11440,8008,4368,1820,560,120,16,1,0,0,0,0,0,0,0,0,0},
{1,17,136,680,2380,6188,12376,19448,24310,24310,19448,12376,6188,2380,680,136,17,1,0,0,0,0,0,0,0,0},
{1,18,153,816,3060,8568,18564,31824,43758,48620,43758,31824,18564,8568,3060,816,153,18,1,0,0,0,0,0,0,0},
{1,19,171,969,3876,11628,27132,50388,75582,92378,92378,75582,50388,27132,11628,3876,969,171,19,1,0,0,0,0,0,0},
{1,20,190,1140,4845,15504,38760,77520,125970,167960,184756,167960,125970,77520,38760,15504,4845,1140,190,20,1,0,0,0,0,0},
{1,21,210,1330,5985,20349,54264,116280,203490,293930,352716,352716,293930,203490,116280,54264,20349,5985,1330,210,21,1,0,0,0,0},
{1,22,231,1540,7315,26334,74613,170544,319770,497420,646646,705432,646646,497420,319770,170544,74613,26334,7315,1540,231,22,1,0,0,0},
{1,23,253,1771,8855,33649,100947,245157,490314,817190,1144066,1352078,1352078,1144066,817190,490314,245157,100947,33649,8855,1771,253,23,1,0,0},
{1,24,276,2024,10626,42504,134596,346104,735471,1307504,1961256,2496144,2704156,2496144,1961256,1307504,735471,346104,134596,42504,10626,2024,276,24,1,0},
{1,25,300,2300,12650,53130,177100,480700,1081575,2042975,3268760,4457400,5200300,5200300,4457400,3268760,2042975,1081575,480700,177100,53130,12650,2300,300,25,1}};  

  int a,b;
  if ((p<=0) || (q<=0)) return( 1 );
  if (p <= q) return( 1 );
  if (p<26)  return( (int) normalize((arith)table[p][q]) );
  /* Stupid algorithm. It will rarely happen.*/
  /*fprintf(stderr,"Stupid algorithm for binomial coefficients is going on. ");  */
  a=BiiComb(p-1,q-1); b=BiiComb(p-1,q);
  a = a+b; a = (int) normalize((arith)a);
  return(a);
}


int BiiPower(k,p)
int k;
int p;  /* k^p */
{

  int kk,r;

  r = 1;
  for (kk=0; kk<p; kk++ ) {
    r *= k; r = (int) normalize((int) r);
  }
  return(r);

}

int BiiPoch(p,k) int p,k; /* p(p-1)...(p-k+1) */ {
  int r,i;
  if ( p < k) return(0);
  r = 1;
  for (i=0;i<k;i++) {
    r = r*(p-i);  r = (int) normalize((arith)r);
  }
  return(r);
}

poly Pw[WSIZE];

poly kanToM1_old(f,fsize)
POLY f;
int fsize;
{
  poly m;
  int big[NVARS];
  int i,j;
  extern int compLoc;
  if (fsize == 0) return((poly) 0);
  for (i=0; i<fsize; i++) {
    Pw[i] = p_monom((field) (f[i])->coeff);
    if (DxGTx) {
      for (j=numvars-1; j>=numvars/2; j--) {
	big[j] = f[i]->e[j-numvars/2].x;
      }
      for (j=numvars/2-1; j>=0; j--) {
	big[j] = f[i]->e[j].D;
      }
    }else {
      for (j=numvars-1; j>=numvars/2; j--) {
	big[j] = f[i]->e[j-numvars/2].D;
      }
      for (j=numvars/2-1; j>=0; j--) {
	big[j] = f[i]->e[j].x;
      }
    }

    /*typeCheck("kanToM1:");*/
    expToS(big,f[i]->compt,INITIAL(Pw[i])); /* should free, before rewrite it. */
    /*  f[i]->compt <====> 1 for scolor*/
    /* expToS(big,1,INITIAL(Pw[i])) works for scalar case. */
    
    /*printf("\nbig=");
    for (j=0; j<numvars; j++) {
      printf("%d ",big[j]);
    }
    printf("\n");*/

  }
  /* Let's sort. */
  Pw[fsize] = (poly) 0;
  pvSort(Pw,fsize);

  for (i=0; i<fsize; i++) {
    Pw[i]->next = Pw[i+1];
  }
  Pw[fsize-1]->next = (poly) 0;

  /*printf("\nkanToM1: input="); printPoly(f,fsize);
  printf("\noutput="); printPolyH(Pw[0]);*/

  return(Pw[0]);
}

poly kanToM1(f,fsize)
POLY f;
int fsize;
{
  int big[NVARS];
  int i,j;
  extern int compLoc;
  static struct pol dummy;
  static poly top = &dummy;
  poly m;
  poly now;
  poly prev;
  int hnumvars;

  if (fsize == 0) return((poly) 0);
  top->next = (poly) 0;
  hnumvars = numvars/2;
  for (i=0; i<fsize; i++) {
    m = p_monom((field) (f[i])->coeff);
    m -> next = (poly) 0;
    if (DxGTx) {
      for (j=numvars-1; j>=hnumvars; j--) {
	big[j] = f[i]->e[j-hnumvars].x;
      }
      for (j=hnumvars-1; j>=0; j--) {
	big[j] = f[i]->e[j].D;
      }
    }else {
      for (j=numvars-1; j>=hnumvars; j--) {
	big[j] = f[i]->e[j-hnumvars].D;
      }
      for (j=hnumvars-1; j>=0; j--) {
	big[j] = f[i]->e[j].x;
      }
    }

    expToS(big,f[i]->compt,INITIAL(m)); /* should free, before rewrite it. */
    /*  f[i]->compt <====> 1 for scolor*/
    /* expToS(big,1,INITIAL(m)) works for scalar case. */

    /* insert */
    prev = top; now = top->next;
    while (1) {
      if (now == (poly) 0) {
	prev->next = m; break;
      }else if (tm_compare(INITIAL(m),INITIAL(now)) == GT) {
	prev->next = m; m->next = now; break;
      }else{
	prev = now; now = now->next;
      }
    }
	

  }

  /*printf("\nkanToM1: input="); printPoly(f,fsize);
  printf("\noutput="); printPolyH(top->next);*/

  return(top->next);
}

POLY mToKan1(f)
poly f;
{ struct monomial *m;
  struct monomial *root;
  int big[NVARS];
  int size;
  POLY g;
  int i,j;
  int cnum;
  int hnumvars;

  /*printPolyH(f);*/
  root = rnewMonom();
  m = root; size = 0;
  if (f == (poly)0) return((POLY) 0);
  hnumvars = numvars/2;
  do {
    m->coeff = (int) f->coef;
    cnum = sToExp(INITIAL(f),big);
    if (DxGTx) {
      for (j=numvars-1; j>=hnumvars; j--) {
	m->e[j-hnumvars].x = big[j];
      }
      for (j=hnumvars-1; j>=0; j--) {
	m->e[j].D = big[j];
      }
    }else{
      for (j=numvars-1; j>=hnumvars; j--) {
	m->e[j-hnumvars].D = big[j];
      }
      for (j=hnumvars-1; j>=0; j--) {
	m->e[j].x = big[j];
      }
    }
    /*    m->compt = INITIAL(f)[nblocks-1]; It works for weight vec   */
    m->compt = tm_component(INITIAL(f)); /* It works for the other case */
    if (cnum >100 || cnum <-100) {
      fprintf(stderr,"Ridiculous value of comp=%d\n",cnum);
      printPolyH(f);
    }
    if (m->compt != cnum) {
      fprintf(stderr," Warning. cnum != tm_component. ");
    }
    size++;
    m->next = rnewMonom();
    m = m->next; f = f->next;
  } while (f != (poly)0);
  g = (POLY) myMalloc((size+2)*sizeof(struct monomial *));
  m = root;
  for (i=0; i<size; i++) {
    g[i] = m;
    m = m->next;
  }
  g[size] = MZERO;
  /*printf("\nmToKan1: "); printPoly(g,size); printf("\n");*/
  return(g);
}
  

pSize(f)
POLY f;
{
  int ans;
  if (f == (POLY) 0) return(0);
  ans = 0;
  do {
    ans++;
  }while (f[ans] != MZERO);
  return(ans);
}

pvSort(a,size) 
poly a[];
int size;
{
  int i,j;
  poly v;

  if (size > 10) fprintf(stderr,"pvSort size = %d.  ",size);
  for (i=1; i<size; i++) {
    v = a[i]; j=i;
    while (tm_compare(INITIAL(a[j-1]),INITIAL(v)) == LT) {
      a[j] = a[j-1]; j = j-1;
      if (j == 0) break;
    }
    a[j] = v;
  }
}
  



poly 
p1_mult_comm(a, t, f)   
field a ;
term t;
poly f ;
{
    poly inresult ;
    field b ;
    bigterm big ;
 
    if (f IS NULL) return(NULL) ;
    inresult = addnode2 ;
    inresult->next = NULL ;
    sToBig(t, big) ;
    while (f ISNT NULL) {
        fd_mult(a, f->coef, &b) ;
        inresult->next = p_monom(b) ;
        inresult = inresult->next ;
        tm_add(INITIAL(f), big, INITIAL(inresult)) ;
        f = f->next ;
    }
    return(addnode2->next) ;
}


poly 
p1_mult_kan(a, t, f)   
field a ;
term t;
poly f ;
{
    poly result ;
    poly g; 
    poly h;
    int s,i;
    POLY fk;
    POLY gk;
    int size,cnum;
    bigterm big;
 
    /*typeCheck("p1_mult");*/
    if (f IS NULL) return(NULL) ;
    g = p_monom(a);

    /*for (i=0; i<nblocks; i++) (g->monom)[i] = t[i]; Doesn't work.*/
    /*sToBig(t,big);
    bigToS(big,INITIAL(g)); It sometimes produces ridiculous comp num.*/
    cnum=sToExp(t,big);
    expToS(big,cnum,INITIAL(g));
    
    g->next = (poly) 0;
    gk = mToKan1(g); fk = mToKan1(f);

    if (gk[0]->compt > 1) {
      fprintf(stderr,"Warning: p1_mult: The component of scalar should be 0\n");
      gk[0]->compt = 0;
    }

    if (HeadStat) {
      int ii; int deg;
      deg = 0;
      for (ii=0; ii<N; ii++) {
	deg += (gk[0]->e[ii]).D;
      }
      if (deg < 10) HeadD[deg] += 1;
      else {printf("p1_mult, deg=%d ",deg);}
      for (ii=0; ii<10;ii++) printf("%4d ",HeadD[ii]);
      printf("| %d\n",pSize(fk));
    }

    if (Debug1) {
      printf("p1_mult(");printMPoly(g); printf(",");printMPoly(f); printf(")\n");
    }

    size = pSize(fk);
    result = (poly) 0;
    for (i=0; i<size; i++) {
      s= mmwMult(gk[0],fk[i],Work,WSIZE);
      h = kanToM1(Work,s);
      p_add(&result,&h);
    }
    polyFree(gk); polyFree(fk);
    return(result);
}

poly 
p1_mult2(g, fk)   
poly g;
POLY fk ;
{
    poly result ;
    poly gnext;
    poly h;
    int s,i;
    POLY gk;
    int size;
    bigterm big;

    if (fk == (POLY) 0) return(NULL) ;

    gnext = g->next ;
    g->next = (poly) 0;
    gk = mToKan1(g);
    g->next = gnext;

    if (HeadStat) {
      printf("p1_mult2(");printMPoly(g); printf(")\n");
    }

    size = pSize(fk);
    result = (poly) 0;
    for (i=0; i<size; i++) {
      s= mmwMult(gk[0],fk[i],Work,WSIZE);
      h = kanToM1(Work,s);
      p_add(&result,&h);
    }
    polyFree(gk);
    return(result);
}

/* 
poly 
p_mult(f, g)  
poly f, g ;
{
    poly result, temp ;
 
    result = NULL ;
    while (f ISNT NULL) {
        temp = p1_mult(f->coef, INITIAL(f), g) ;
        p_add(&result, &temp) ;
        f = f->next ;
    }
    qrgReduce(&result) ;
    return(result) ;
}
*/


poly 
p_mult_kan(f, g)       /* f in ring, g in module */
poly f, g ;
{
    poly result, temp ;
    POLY gk;

    if (Debug1) {
      printf("p_mult_kan(");printMPoly(f); printf(",");printMPoly(g); printf(")\n");
    }
    result = NULL ;
    gk = mToKan1(g);
    while (f ISNT NULL) {
        temp = p1_mult2(f, gk) ;
        p_add(&result, &temp) ;
        f = f->next ;
    }
    polyFree(gk);
    qrgReduce(&result) ;
    return(result) ;
}

printMPoly(f)
poly f;
{
  POLY g;
  g = mToKan1(f);
  printPoly(g,pSize(g));
  polyFree(g);
}


kPrint(file,g,comp)
FILE *file;
poly g;
int comp;
{
  POLY f;
  int j,size;
  int printed = 0;
  extern char **varnames;
  int fi; /* index for monomials*/
  char multsym='*';
  int vi; /* index for variables */
  char *contStr = " \\\n";
  int length = 0;
  int lengthLimit = 0; /* e.g. = 15 */
  if (Kformat == 2) lengthLimit = 15;

  if (2*N != numvars) fprintf(file,"Error(kPrint): 2*N != numvars\n");
  f = mToKan1(g);
  size = pSize(f);
  fprintf(file,"$");
  if (size == 0) {
    fprintf(file,"0");
    printed = 1;
  }
  fi = 0;
  while (fi < size) {
    if (f[fi]->compt == comp) {
      printed = 1;
      /*print coefficient*/
      if (fi == 0) {
	if (isConstant(f[fi])) {
	  fprintf(file,"%d",f[fi]->coeff);
	}else if (isOne(f[fi]->coeff)) {
	  /* do nothing */
	}else if (isMinusOne(f[fi]->coeff)) {
	  fprintf(file,"-");
	}else{
	  fprintf(file,"%d",f[fi]->coeff);
	  fprintf(file,"%c",multsym);
	}
      }else{
	if (isConstant(f[fi])) {
	  if (isNegative(f[fi]->coeff)) {
	    fprintf(file,"%d",f[fi]->coeff);
	  }else{
	    fprintf(file,"+");
	    fprintf(file,"%d",f[fi]->coeff);
	  }
	}else if (isOne(f[fi]->coeff)) {
	  fprintf(file,"+");
	}else if (isMinusOne(f[fi]->coeff)) {
	  fprintf(file,"-");
	}else{
	  if (!isNegative(f[fi]->coeff)) fprintf(file,"+");
	  fprintf(file,"%d",f[fi]->coeff);
	  fprintf(file,"%c",multsym);
	}
      }
      /* output variables */
      vi = 0;
      for (j=0; j<N; j++) {
	if (f[fi]->e[j].x) {
	  vi++;
	  if (vi != 1) fprintf(file,"%c",multsym);
	  fprintf(file,"%s",varnames[j+N]);
	  if (f[fi]->e[j].x >= 2) {
	    fprintf(file,"^%d",f[fi]->e[j].x);
	  }else if (f[fi]->e[j].x < 0) {
	    fprintf(file,"^(%d)",f[fi]->e[j].x);
	    }
	}
      }
      for (j=0; j<N; j++) {
	if (f[fi]->e[j].D) {
	  vi++;
	  if (vi != 1) fprintf(file,"%c",multsym);
	  fprintf(file,"%s",varnames[j]);
	  if (f[fi]->e[j].D >= 2) {
	    fprintf(file,"^%d",f[fi]->e[j].D);
	  }else if (f[fi]->e[j].D < 0) {
	    fprintf(file,"^(%d)",f[fi]->e[j].D);
	    }
	}
      }
    }
    fi++;
    length += N/3+1;
    if (lengthLimit > 0  && length > lengthLimit) {
      length = 0;
      fprintf(file,"%s",contStr);
    }
  }
  if (!printed) fprintf(file,"0");
  fprintf(file,"$ ");
  polyFree(f);
}

isOne(c)
int c;
{
  if (c == 1) return(1); else return(0);
}
isMinusOne(c)
int c;
{
  if (c == -1) return(1); else return(0);
}
isNegative(c)
int c;
{
  if (c < 0) return(1); else return(0);
}

isConstant(fi)
struct monomial *fi;
{
  int i;
  for (i=0; i<N; i++) {
    if (fi->e[i].x  ||  fi->e[i].D) return(0);
  }
  return(1);
}

/* -------------------------------------- */
#define I(i,j) (i*NVARS+j)
#define LSIZE 10000
static int V[NVARS];  /* index of variables */
static int *CList;
static int *EList;
static int *DList;
static int *MList;
static int *Mark;
static int Lsize;
static int Plist;
static int Maxv;
static poly *RList;
static poly *RListRoot;

initT() {
  int i;
  Lsize = LSIZE;
  CList = (int *)malloc(sizeof(int)*Lsize);
  EList = (int *)malloc(sizeof(int)*Lsize);
  Mark = (int *)malloc(sizeof(int)*Lsize);
  
  DList = (int *)malloc(sizeof(int)*Lsize*NVARS);
  MList = (int *)malloc(sizeof(int)*Lsize*NVARS);

  RList = (poly *)malloc(sizeof(poly)*Lsize);
  RListRoot = (poly *)malloc(sizeof(poly)*Lsize);
  for (i=0; i<Lsize; i++) RListRoot[i] = (poly) malloc(sizeof(struct pol));
}
  

makeTable(c,big)
int c;
int big[];
{
  int i,j,k,p,q,deg;
  /* initialize */
  Maxv = 0; Plist = 1; deg = 0;
  for (i=0; i<hnumvars; i++) {
    if (big[i] != 0) {
      V[Maxv] = i;
      DList[I(0,Maxv)] = big[i];
      MList[I(0,Maxv)] = 0;
      deg += big[i];
      Maxv++;
    }
  }
  CList[0] = c; EList[0] = deg*2; Mark[0] = 0;

  for (i=0; i<Maxv; i++) {
    k = Plist;
    /* Copy j-th row to k-th row and modify it. */
    for (j=0; j<Plist; j++) {
      for (q=1; q<=DList[I(j,i)]; q++) {
	for (p=0; p<Maxv; p++) { /* copy */
	  DList[I(k,p)] = DList[I(j,p)];
	  MList[I(k,p)] = MList[I(j,p)];
	}
	/* modify */
	DList[I(k,i)] -= q;
	MList[I(k,i)] += q;

	CList[k] = normalize(CList[j]*BiiComb(DList[I(j,i)],q));
	EList[k] = EList[j]-2*q;
	Mark[k] = 0;
	k++;
	if (k>= Lsize) {
	  fprintf(stderr,"Lsize too large\n");
	  exit();
	}
      }
    }
    Plist = k;
  }
}


outputTable() {
  int i,j;
  printf("Maxv = %d Plist=%d\n",Maxv,Plist);
  for (i=0; i<Maxv; i++) printf("%5d",V[i]);
  printf("\n------ DList --------------\n");
  for (i=0; i<Plist; i++) {
    for (j=0; j<Maxv; j++) {
      printf("%5d",DList[I(i,j)]);
    }
    putchar('\n');
  }
  printf("\n--------- MList ------------\n");
  for (i=0; i<Plist; i++) {
    for (j=0; j<Maxv; j++) {
      printf("%5d",MList[I(i,j)]);
    }
    printf(" | c=%10d, e=%5d M=%1d\n",CList[i],EList[i],Mark[i]);
  }
}

dtermMult(bigt,cnumt,f)
int bigt[];
int cnumt;
poly f;
{
  int k;
  field a;
  field b;
  int bigf[NVARS];
  int cnumf;
  int tmp[NVARS];
  int i,j,e;
  poly m;

  cnumf = tm_component(INITIAL(f));
  sToExp(INITIAL(f),bigf);
  /* Clear Mark */
  for (k=Plist-1; k>=0; k--) Mark[k] = 0;
  for (k=Plist-1; k>=0; k--) {
    if (Mark[k]) goto no;
    /* coeff */
    a = normalize(CList[k]*(f->coef));
    if (a == 0) goto no;
    for (i=0; i<Maxv; i++) {
      if ((b = BiiPoch(bigf[hnumvars+V[i]],DList[I(k,i)])) == 0) {
                            /* x^p              D^q */
	/* Set Mark */
	e = DList[I(k,i)];
	for (j=k; j>=0; j--) {
	  if (DList[I(j,i)] >= e) Mark[j] = 1;
	}
	if (DebugT) {printf("i=%d, e=%d\n",i,e); outputTable();}
	goto no;
      }
      if ((a = normalize(a*b)) == 0) goto no;
    }
    /* set exp. copy */
    for (i=0; i<numvars; i++) tmp[i] = bigf[i];
    /* set E */
    tmp[numvars-1] += EList[k] + bigt[numvars-1];
    /* set D */
    for (i=0; i<Maxv; i++) {
      tmp[V[i]] += MList[I(k,i)];
      tmp[hnumvars+V[i]] -= DList[I(k,i)];
    }
    /* set X */
    for (i= hnumvars; i<numvars-1; i++) tmp[i] += bigt[i];

    m = p_monom(a);
    expToS(tmp,mymax(cnumt,cnumf),INITIAL(m));
    m->next = (poly)0;
    RList[k]->next = m;
    RList[k] = m;
  no: ;
  }
}

poly p1_mult(a,t,f)
field a;
term t;
poly f;
{
  int bigt[NVARS];
  int cnumt;
  poly top;
  poly temp;
  int k;
  poly gg;  gg = f;
  
  if (f IS NULL) return(NULL);
  if (Commutative) return(p1_mult_comm(a,t,f));
  if (M) return(p1_mult_kan(a,t,f));


  cnumt = tm_component(t); 
  sToExp(t,bigt);
  makeTable(a,bigt);
  if (DebugT) outputTable();
  for (k=0; k<Plist; k++) {
    RList[k] = RListRoot[k];
    RList[k]->next = (poly) 0;
  }


  while (f ISNT NULL) {
    dtermMult(bigt,cnumt,f);
    f = f->next;
  }

  top = NULL;
  for (k=0; k<Plist; k++) {
    temp = RListRoot[k]->next;
    p_add(&top,&temp);
  }
  qrgReduce(&top);
  if (DebugT || DebugCheck)
  {poly ff; 
   ff = p_copy(top);  gg = p1_mult_kan(a,t,gg);
   if (!DebugCheck) printf("Diff---");
   p_sub(&ff,&gg);
   if (!DebugCheck) {printMPoly(ff);printf("\n");}
   if (ff != (poly) 0) {
     printf("Macaulay--");
     printMPoly(gg);
     printf("\nNew--"); printMPoly(top); printf("\n");
     getchar();
   }
 }
  
  return(top);
}

	
poly 
p_mult(f, g)       /* f in ring, g in module */
poly f, g ;
{
    poly result, temp ;

    if (Debug1) {
      printf("p_mult(");printMPoly(f); printf(",");printMPoly(g); printf(")\n");
    }
    result = NULL ;
    while (f ISNT NULL) {
        temp = p1_mult(f->coef,INITIAL(f),g);
        p_add(&result, &temp) ;
        f = f->next ;
    }
    qrgReduce(&result) ;
    return(result) ;
}
  


dtermMult_org(bigt,cnumt,f)
int bigt[];
int cnumt;
poly f;
{
  int k;
  field a;
  int bigf[NVARS];
  int cnumf;
  int tmp[NVARS];
  int i;
  poly m;

  cnumf = tm_component(INITIAL(f));
  sToExp(INITIAL(f),bigf);
  for (k=Plist-1; k>=0; k--) {
    /* coeff */
    a = normalize(CList[k]*(f->coef));
    if (a == 0) goto no;

    /* set exp. copy */
    for (i=0; i<numvars; i++) tmp[i] = bigf[i];
    /* set E */
    tmp[numvars-1] += EList[k] + bigt[numvars-1];
    /* set D */
    for (i=0; i<Maxv; i++) {
      a = normalize(a*BiiPoch(tmp[hnumvars+V[i]],DList[I(k,i)]));
                             /* x^p              D^q */
      if (a == 0) goto no;
      tmp[V[i]] += MList[I(k,i)];
      tmp[hnumvars+V[i]] -= DList[I(k,i)];
    }
    /* set X */
    for (i= hnumvars; i<numvars-1; i++) tmp[i] += bigt[i];

    m = p_monom(a);
    expToS(tmp,mymax(cnumt,cnumf),INITIAL(m));
    m->next = (poly)0;
    RList[k]->next = m;
    RList[k] = m;
  no: ;
  }
}

