/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#ifdef MPWC
#include <Types.h>
#include <OSUtils.h>
#include <Files.h>	
#endif
#include <stdio.h>
#include <ctype.h>
extern int level ;
extern int echo ;
extern int prlevel ;
extern int nlines ;

#define PROMPT1 '%'
#define PROMPT2 '?'

#define EOLN(A) ((A) == '\n' || (A) == '\r' || (A) == EOF)
#ifndef MIN
#define MIN(A, B) ( (A) < (B) ? (A) : (B) )
#endif
#ifndef MAX
#define MAX(A, B) ( (A) > (B) ? (A) : (B) )
#endif
#define VISIBLE(A) ((A) > 32 && (A) < 127)

#define NVOICES 50 
#define NLEVELS 12 
#define NARGS 40
#define NCHARS 200
#define NNAMES 200
#define VNAMES 600

char linebuf[NCHARS];
char *argv[NARGS] ;
int cmd = 0, old_level = -1, cur_voice = -1 ;
int voice[NLEVELS] ;
FILE *fd ;
FILE *fj ;
int jf ;
FILE *fstack[NVOICES] ;
FILE *jstack[NVOICES] ;
int jflag[NVOICES] ;
int inam, nnam, inames[NVOICES], nnames[NVOICES], indnames[NNAMES] ;
char namespace[VNAMES];
static int top, sniff ;
static char prlev[] = "set prlevel 1" ;
static char prlev2[] = "incr-set prlevel 1" ;

int com = 0; /* was previous cmd line a comment ? */
int remnull = 0; /* was last line a cmd but empty? */

char *MclyPath;

void
init_path()
{
    int len, strlen();
    char *path, *getenv(), *strncpy(), *gimmy();
    
    path = getenv("MacaulayPath");
    if (path == NULL) 
      MclyPath = "" ;
    else {
	len = 1 + strlen(path);
	MclyPath = gimmy(len);
	strncpy(MclyPath, path, len);
	/* printf("MclyPath = {%s}\n", MclyPath); */
    }
}

#ifdef MPWC
char colon = ':', comma = ',';
#else
char colon = '/', comma = ':';
#endif

FILE *topen(fileName, mode)
char *fileName, *mode;
{
#ifdef MPWC
	FInfo fndrInfo;
#endif
	int flen, pos;
	FILE *fp, *fopen();
	char *path, *fname, *spos, *strchr(), *gimmy();
	
	if (*mode == 'r' && *MclyPath != '\0'
		&& strchr(fileName, colon) == NULL) {
		/* use MclyPath to search for file */
		flen = strlen(fileName);
		path = MclyPath;
		while (1) {
			/* printf("path = {%s}\n", path); */
			if (*path == '\0') break;
			
			/* pos = number of chars in next prefix */
			spos = strchr(path, comma);
			if (spos == NULL) pos = strlen(path);
			else pos = spos - path;

			fname = gimmy(pos+flen+2);
			
#ifdef MPWC
			if (pos > 1) {
				strncpy(fname, path, pos);
				strncpy(fname+pos, fileName, flen+1);
			}
#else					
			if (pos > 0) {
				strncpy(fname, path, pos);
				fname[pos] = colon;
				strncpy(fname+pos+1, fileName, flen+1);
			}
#endif
			else
				strncpy(fname, fileName, flen+1);
			/* printf("\ntrying {%s}\n", fname); */

			fp = fopen(fname, mode);
			ungimmy(fname);
			if (fp != NULL || path[pos] == '\0') break;
			path += pos+1;
		}
	}
	else {
		fp = fopen(fileName, mode);
	}
#ifdef MPWC
#ifdef MPW3
	if (fp != NULL) {
		getfinfo(fileName, 0, &fndrInfo);
		if(fndrInfo.fdType == 0) fndrInfo.fdType = 'TEXT';
		if(fndrInfo.fdCreator == 0) fndrInfo.fdCreator = 'MPS ';
		setfinfo(fileName, 0, &fndrInfo);
	}
#else
	if (fp != NULL) {
		GetFInfo(fileName, 0, &fndrInfo);
		if(fndrInfo.fdType == 0) fndrInfo.fdType = 'TEXT';
		if(fndrInfo.fdCreator == 0) fndrInfo.fdCreator = 'MPS ';
		SetFInfo(fileName, 0, &fndrInfo);
	}
#endif
#endif
	return fp;
} /* mod 24feb89 DB */

sniff_prlevel(linebuf)
char *linebuf;
{
	 if ((strcmp(linebuf, prlev) == 0) 
	     || (strcmp(linebuf, prlev2) == 0)) {
	 	sniff = 1;
		++prlevel;
	}
	else sniff = 0;
}

unsniff_prlevel()
{
	 if (sniff == 1) --prlevel;
}

/* break_voice added: MES 3/29/88 */
break_voice()
{
    if (cur_voice > 0)
	drop_voice() ;
}

drop_voice()
{
	if (cur_voice > 0) {
		if (fd != stdin) fclose(fd) ;
		if (fj != NULL) fclose(fj) ;
		voice[level] = --cur_voice ;
		fd = fstack[cur_voice] ;
		fj = jstack[cur_voice] ;
		jf = jflag[cur_voice] ; 
		inam = inames[cur_voice] ;
		nnam = nnames[cur_voice] ;
	}
	else {
		print("end of file ($) received, exiting Macaulay\n") ;
		exitMacaulay() ;
	}
}

int
change_level()
{
	int i ;

	if (level >= NLEVELS) return 0 ;
	if (level < 0) {
		for (i=0; i<=cur_voice; ++i) {
			if (fstack[i] != stdin) fclose(fstack[i]) ;
			if (jstack[i] != NULL) fclose(jstack[i]) ;
		}
		old_level = -1 ;
		cur_voice = -1 ;
		return 1;
	}
	if (level < old_level) {
		for (i=voice[level]+1; i<=cur_voice; ++i) {
			if (fstack[i] != stdin) fclose(fstack[i]) ;
			if (jstack[i] != NULL) fclose(jstack[i]) ;
		}
		cur_voice = voice[level] ;
		fd = fstack[cur_voice] ;
		fj = jstack[cur_voice] ;
		jf = jflag[cur_voice] ; 
		inam = inames[cur_voice] ;
		nnam = nnames[cur_voice] ;
	}
	else if (level > old_level) {
		voice[level] = ++cur_voice ;
		fd = fstack[cur_voice] = stdin ;
		fj = jstack[cur_voice] = NULL ;
		jf = jflag[cur_voice] = 0 ; 
		if (level == 0) 
			inam = inames[cur_voice] = 0 ;
		else
			inam = inames[cur_voice] = inam + nnam ;
		nnam = nnames[cur_voice] = 0 ;
	}
	old_level = level ;
	return 1;
}

prompt()
{
	int i ;

	if (!com)
		for (i=1; i<=nlines; i++) 
		  print("\n") ;
	for (i=0; i<=level; ++i) {
		if (voice[i] > 0) print("%d", voice[i]) ;
		print("%% ") ;
	}
} /* 2/10/89 DB */

int
get_chars(fd, a)
FILE *fd;
char *a;
{
	/* read text into array a starting past last prompt, leading space */
	/* return value indicates if prompt was seen */
	int c, i = 0, flag = 0;
	int comment = 0, dollar = 0;
	
	while (c = getc(fd), !EOLN(c)) {
		if (c == '$') dollar = 1;
		if (c == ';') comment = 1;
		if (!comment && (c == PROMPT1 || c == PROMPT2)) {
			i = 0;
			flag = 1;
			continue;
		}
		if (i == 0 && (c == ' ' || c == '\t')) continue;
		if (i<NCHARS-1) a[i++] = c ;
	}
	if ((c == EOF && i == 0) || dollar == 1) i=0, a[i++] = '$';
	a[i] = '\0' ;
	return flag ;
}

raw_line()
{
	int i, new = 1, pflag;
	char userchars[NCHARS], *p ;

beginning:
	do {
		if (new == 0) drop_voice() ;
		new = 0;
		if (cmd && fd == stdin && !remnull) prompt() ;
		pflag = get_chars(fd, linebuf);
		remnull = (cmd && linebuf[0] == '\0') ? 1 : 0;
#ifdef MPWC
		if (pflag == 0) {
			if (fd == stdin && !remnull) print("%s\n", linebuf) ;
		}
#endif
	} while (linebuf[0] == '$') ;  /* $ is our EOF char */
	sniff_prlevel(linebuf) ;
	if (fj != NULL && !remnull) fprint(fj, "%s\n", linebuf) ;
	subs_names() ;
	if (linebuf[0] == '?' && (linebuf[1] == '\0' || isspace(linebuf[1]))) {
		if (cmd) prompt(); else prinput("?");
		get_chars(stdin, linebuf);
		subs_names() ;
	}
	else if (fd != stdin) {
		if (cmd && !remnull) {
			if (linebuf[0] != ';') prompt() ;
			else if (!com)
				for (i=1; i<=nlines; i++) 
		  			print("\n") ;
		}
		if (!remnull) print("%s", linebuf) ;
		if (jf && linebuf[0] != '\0' && linebuf[0] != ';') {
			print(" ") ;
			get_chars(stdin, userchars);
			for (p=userchars; p[1]!=NULL; ++p);
			if (*p == '$') goto beginning ;
			else if (*p == '&') debug_voice();
			else if (*p == '!') jf = jflag[cur_voice] = 0 ; 
		}
		else if (!remnull) print("\n") ;
	}
	if (fd == stdin) {
	  if (echo > 0)
	    { if (!remnull) print("%s\n", linebuf) ; }
	  else
#ifdef MPWC
		if (pflag == 1) monprint("%s\n", linebuf) ;
#else
		monprint("%s\n", linebuf) ;	
	        /* put linebuf in monitor file, if any */
#endif
	}
	unsniff_prlevel() ;
} /* 2/10/89 DB */

get_line(pargc, pargv)
int *pargc;
char ***pargv;
{
	int i ;
	char *s ;

	raw_line() ;
	for (i=0, s=linebuf; i<NARGS; ) {
		while (!VISIBLE(*s) && *s != '\0') ++s ;
		if (*s == '\0' || *s == ';') break ;
		argv[i++] = s++ ;
		while (VISIBLE(*s)) ++s ;
		if (*s == '\0') break ;
		*s++ = '\0' ;
	}
	*pargc = i ;
	*pargv = argv ;
}

int
open_journal(s)
char *s;
{
	FILE *newfj, *topen() ;

	if (voice[level] == NVOICES-1) {
		prerror("; >>%s ignored, out of input voices\n", s) ;
		return 0;
	}
	newfj = topen(s, "w") ;
	if (newfj == NULL) {
		prerror("; >>%s ignored, error in opening file\n", s) ;
		return 0;
	}
	voice[level] = ++cur_voice ;
	fd = fstack[cur_voice] = stdin ;
	fj = jstack[cur_voice] = newfj ;
	jf = jflag[cur_voice] = 0 ; 
	inam = inames[cur_voice] = inam + nnam ;
	nnam = nnames[cur_voice] = 0 ;
	return 1;
}

int
debug_voice()
{
	if (voice[level] == NVOICES-1) {
		print("< ignored, out of input voices\n") ;
		return 0;
	}
	voice[level] = ++cur_voice ;
	fd = fstack[cur_voice] = stdin ;
	fj = jstack[cur_voice] = NULL ;
	jf = jflag[cur_voice] = 0 ; 
	inam = inames[cur_voice] = inam + nnam ;
	nnam = nnames[cur_voice] = 0 ;
	return 1;
}

int
open_tour(s)
char *s;
{
	FILE *newfd, *topen() ;
	int newjf ;

	if (voice[level] == NVOICES-1) {
		prerror("; <%s ignored, out of input voices\n", s) ;
		return 0;
	}
	newjf = (*s == '<') ? 1 : 0 ;
	newjf = jf ? 1 : newjf;
	if (*s == '<') ++s ;
	newfd = topen(s, "r") ;
	if (newfd == NULL) {
		prerror("; <%s ignored, error in opening file\n", s) ;
		return 0;
	}
	voice[level] = ++cur_voice ;
	fd = fstack[cur_voice] = newfd ;
	fj = jstack[cur_voice] = NULL ;
	jf = jflag[cur_voice] = newjf ; 
	inam = inames[cur_voice] = inam + nnam ;
	nnam = nnames[cur_voice] = 0 ;
	return 1;
}

set_names(ac, av)
int ac;
char **av;
{
	int i, len;

	if (cur_voice == 0)
		top = 0 ;
	else {
		top = inames[cur_voice-1] + nnames[cur_voice-1] ;
		if (top > 0)
			top = indnames[top-1]
				+ strlen(namespace+indnames[top-1]) + 1 ;
	}
	for (i=1; i<ac; ++i) {
		len = strlen(av[i]);
		if (top+len+1 >= VNAMES || inam+nnam >= NNAMES) {
			print("Out of space; ignoring %s\n", av[i]);
			break;
		}
		indnames[inam+nnam++] = top ;
		strcpy(namespace+top, av[i]) ;
		top += len + 1 ;
	}
	nnames[cur_voice] = nnam ;
}

subs_names()
{
    int len, i, iline, two;
    char *p, *q, *r, *s, parm[NCHARS], at[5];
    
    for (p=linebuf; *p!='\0'; ++p) {
	if (
	    (*p == '@')
	    && !(p-linebuf >= 3 && p[-3] == '@' && isdigit(p[-2]) && isdigit(p[-1])) 
	    && !(strlen(p) >= 3 && p[3] == '@' && isdigit(p[2]) && isdigit(p[1]))
	    ) {			
	    len = 4;
	    iline = strlen(linebuf);
	    if (iline + len - 1 >= NCHARS) {
		print("out of space; ") ;
		print("no substitution made for @\n") ;
		return ;
	    }
	    for (r=linebuf+iline, s=r+len-1; r!=p; --r, --s) *s = *r;
	    if (fd == stdin && fj == NULL) {
		if (voice[level] > 0)
		  sprintf(at, "@%02d@", voice[level]-1);
		else
		  sprintf(at, "@%02d@", voice[level]+1);
	    }
	    else /* normal case */
	      sprintf(at, "@%02d@", voice[level]);
	    q = at;
	    for (; *q!='\0'; ++p, ++q) *p = *q ;
	    --p ;
	}
    }
    
#define ZIP -31991 /* since parseInt() returns 0 on error */
    for (p=linebuf; *p!='\0'; ++p) {
	if (*p == '#') {
	    if (isdigit(p[1])) {
		i = p[1] - '0';
		if (i == 0) i = ZIP;
		two = 2;
	    }
	    else if (p[1] == '(') {
		for (
		     i=0, q=p+2, r=parm;
		     (*q != '\0') && (i>0 || *q!=')');
		     ++q, ++r)
		  {
		      if (*q == '(') ++i;
		      if (*q == ')') --i;
		      *r = *q;
		  }
		if (*q == '\0') --q;
		*r = '\0';
		r = parm;
		i = parseInt(&r);
		two = q - p + 1;
	    }
	    else {
		r = p+1;
		i = parseInt(&r);
		two = r - p;
	    }
	    
	    if (i == ZIP) {
		/* return # of args */
		sprintf(parm, "%d", nnam);
		q = parm;
	    }
	    else if (i < 1 || i > nnam) {
		continue; /* out of range; print warning? */
	    }
	    else q = namespace + indnames[inam+i-1];
	    
	    len = strlen(q) ;
	    if (len < two) {
		for (r=p+two, s=p+len; *s = *r, *r!='\0'; ++r, ++s) ;
	    }
	    else if (len > two) {
		iline = strlen(linebuf);
		if (iline + len - two >= NCHARS) {
		    print("out of space; ") ;
		    print("no substitution made for #%d\n", i) ;
		    return ;
		}
		for (r=linebuf+iline, s=r+len-two; r!=p; --r, --s) *s = *r;
	    }
	    for (; *q!='\0'; ++p, ++q) *p = *q ;
	    --p ;
	}
    }
} /* 5/18/89 DB 3/6 */

get_cmd_line(pargc, pargv, poutfile)
int *pargc;
char ***pargv, **poutfile;
{
	int i, ac;
	char *s, **av;
	int go_again ;

	cmd = 1 ;
	*poutfile = NULL ;
	do {
		get_line(&ac, &av) ;

		/* ignor label: arguments */
		if (ac > 0 && av[0][strlen(av[0])-1] == ':') {
			--ac;
			++av;
		}

		com = linebuf[0] == ';' ? 1 : 0;
		if (ac == 0) continue ;
		if (av[0][0] == '>' && av[0][1] == '>') {
			if (open_journal(av[0]+2)) set_names(ac, av) ;
			ac = 0;
		    continue;
		}
		
		go_again = 0 ;
		for (i=0; i<ac; ++i) {
			if (av[i][0] == '<') {
				if(open_tour(av[i]+1)) set_names(ac-i, av+i) ;
				ac = i;
			    go_again = 1 ;
			    break ;
			}
			if (av[i][0] == '>' && av[i][1] == '>') {
				if (open_journal(av[i]+2)) set_names(ac-i, av+i) ;
				ac = i;
			    go_again = 1 ;
			    break ;
			}
		}
		if (go_again) continue ; /* added MES 1/19/88, a crock? */
		/* of what, Mike? DB */
		s = av[ac-1] ;
		if (*s == '>') {
			--ac ;
			*poutfile = ++s ;
		}
	} while (ac == 0); 
	cmd = 0 ;

	*pargc = ac;
	*pargv = av;
} /* 2/26/89 DB */


branch(label)
char *label;
{
/* reset current file to beginning of line which starts "label:" */
	int len ;
	char buf[NCHARS], *p ;
	
	len = strlen(label) ;
	fseek(fd, 0L, 0) ;
	while (1) {
		if (fgets(buf, NCHARS-1, fd) == NULL) break ;
		for (p=buf; isspace(*p); ++p);
		if (p[len] == ':' && strncmp(label, p, len) == 0) {
			len = strlen(buf) ;
			/* fseek( , , 1) is possible portability problem */
			/* kill next line and only label empty lines if trouble */
			fseek(fd, (long) -len, 1) ;
			break ;
		}
	}
} /* 5/18/89 DB 4/6 */

if_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	int test ;

	if (argc < 3 || argc > 4) {
		printnew("if <integer> <label1> [<label2>]\n") ;
		printnew("if integer != 0 then jump to label1: [else jump to label2: ]\n") ;
	}
	else if (fd == stdin)
		printnew("if statements only take effect inside scripts\n") ;
	else {
		test = getInt(argv[1]) ;
		if (test != 0)
			branch(argv[2]) ;
		else if (argc == 4)
			branch(argv[3]) ;
	}
} /* new 2/26/89 DB */

jump_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	if (argc != 2) {
		printnew("jump <label>\n") ;
		printnew("jump to label: in current input script\n") ;
	}
	else if (fd == stdin)
		printnew("jump statements only take effect inside scripts\n") ;
	else
		branch(argv[1]) ;
} /* new 2/26/89 DB */

