#include <stdio.h>
#define NVARS 512
#define I(i,j) (i*NVARS+j)
#define normalize(x) x
#define LSIZE 30
typedef int   arith;
static int numvars;
static int hnumvars;
static int V[NVARS];  /* index of variables */
static int *CList;
static int *EList;
static int *DList;
static int *MList;
static int Lsize;
static int Plist;
static int Maxv;

initT() {
  Lsize = LSIZE;
  CList = (int *)malloc(sizeof(int)*Lsize);
  EList = (int *)malloc(sizeof(int)*Lsize);
  
  DList = (int *)malloc(sizeof(int)*Lsize*NVARS);
  MList = (int *)malloc(sizeof(int)*Lsize*NVARS);
}
  

makeTable(c,big)
int c;
int big[];
{
  int i,j,k,p,q;
  /* initialize */
  Maxv = 0; Plist = 1;
  for (i=0; i<hnumvars; i++) {
    if (big[i] != 0) {
      V[Maxv] = i;
      DList[I(0,Maxv)] = big[i];
      MList[I(0,Maxv)] = 0;
      Maxv++;
    }
  }
  CList[0] = c; EList[0] = 0;

  for (i=0; i<Maxv; i++) {
    k = Plist;
    /* Copy j-th row to k-th row and modify it. */
    for (j=0; j<Plist; j++) {
      for (q=1; q<=DList[I(j,i)]; q++) {
	for (p=0; p<Maxv; p++) { /* copy */
	  DList[I(k,p)] = DList[I(j,p)];
	  MList[I(k,p)] = MList[I(j,p)];
	}
	/* modify */
	DList[I(k,i)] -= q;
	MList[I(k,i)] += q;

	CList[k] = normalize(CList[j]*BiiComb(DList[I(j,i)],q));
	EList[k] = EList[j]+2*q;
	k++;
	if (k>= Lsize) {
	  fprintf(stderr,"Lsize too large\n");
	  exit();
	}
      }
    }
    Plist = k;
  }
}

outputTable() {
  int i,j;
  printf("Maxv = %d Plist=%d\n",Maxv,Plist);
  for (i=0; i<Maxv; i++) printf("%5d",V[i]);
  printf("\n------ DList --------------\n");
  for (i=0; i<Plist; i++) {
    for (j=0; j<Maxv; j++) {
      printf("%5d",DList[I(i,j)]);
    }
    putchar('\n');
  }
  printf("\n--------- MList ------------\n");
  for (i=0; i<Plist; i++) {
    for (j=0; j<Maxv; j++) {
      printf("%5d",MList[I(i,j)]);
    }
    printf(" | c=%10d, e=%5d\n",CList[i],EList[i]);
  }
}

main() {
  static int big[10] = {2,1,1,0,0};
  numvars = 10;
  hnumvars = 5;
  initT();
  makeTable(1,big);
  outputTable();
  printf("\n");
}
  




int BiiComb(p,q) 
int p,q;  /* return pCq */ 
{
/**
 foo[n_]:=Block[{p,q,ans},
    ans={};
    For[p=0,p<=n,p++,ans=Append[ans,Table[Binomial[p,q],{q,0,n}]]];
    Return[ans];
 ]
**/
/* We assume that int is 32 bit */
static int table[26][26]=
{{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,4,6,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,5,10,10,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,6,15,20,15,6,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,7,21,35,35,21,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,8,28,56,70,56,28,8,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,9,36,84,126,126,84,36,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,10,45,120,210,252,210,120,45,10,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,11,55,165,330,462,462,330,165,55,11,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,12,66,220,495,792,924,792,495,220,66,12,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,13,78,286,715,1287,1716,1716,1287,715,286,78,13,1,0,0,0,0,0,0,0,0,0,0,0,0},
{1,14,91,364,1001,2002,3003,3432,3003,2002,1001,364,91,14,1,0,0,0,0,0,0,0,0,0,0,0},
{1,15,105,455,1365,3003,5005,6435,6435,5005,3003,1365,455,105,15,1,0,0,0,0,0,0,0,0,0,0},
{1,16,120,560,1820,4368,8008,11440,12870,11440,8008,4368,1820,560,120,16,1,0,0,0,0,0,0,0,0,0},
{1,17,136,680,2380,6188,12376,19448,24310,24310,19448,12376,6188,2380,680,136,17,1,0,0,0,0,0,0,0,0},
{1,18,153,816,3060,8568,18564,31824,43758,48620,43758,31824,18564,8568,3060,816,153,18,1,0,0,0,0,0,0,0},
{1,19,171,969,3876,11628,27132,50388,75582,92378,92378,75582,50388,27132,11628,3876,969,171,19,1,0,0,0,0,0,0},
{1,20,190,1140,4845,15504,38760,77520,125970,167960,184756,167960,125970,77520,38760,15504,4845,1140,190,20,1,0,0,0,0,0},
{1,21,210,1330,5985,20349,54264,116280,203490,293930,352716,352716,293930,203490,116280,54264,20349,5985,1330,210,21,1,0,0,0,0},
{1,22,231,1540,7315,26334,74613,170544,319770,497420,646646,705432,646646,497420,319770,170544,74613,26334,7315,1540,231,22,1,0,0,0},
{1,23,253,1771,8855,33649,100947,245157,490314,817190,1144066,1352078,1352078,1144066,817190,490314,245157,100947,33649,8855,1771,253,23,1,0,0},
{1,24,276,2024,10626,42504,134596,346104,735471,1307504,1961256,2496144,2704156,2496144,1961256,1307504,735471,346104,134596,42504,10626,2024,276,24,1,0},
{1,25,300,2300,12650,53130,177100,480700,1081575,2042975,3268760,4457400,5200300,5200300,4457400,3268760,2042975,1081575,480700,177100,53130,12650,2300,300,25,1}};  

  int a,b;
  if ((p<=0) || (q<=0)) return( 1 );
  if (p <= q) return( 1 );
  if (p<26)  return( (int) normalize((arith)table[p][q]) );
  /* Stupid algorithm. It will rarely happen.*/
  fprintf(stderr,"Stupid algorithm for binomial coefficients is going on. ");  
  a=BiiComb(p-1,q-1); b=BiiComb(p-1,q);
  a = a+b; a = (int) normalize((arith)a);
  return(a);
}


	
  


