/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "types.h"

#include <setjmp.h>
extern int prlevel ;
extern int flushnum ;  /* used to control verbose output: reset in shell() */

int level ;
jmp_buf envbuf ;
FILE *outfile ;		/* either stdout, or redirected file */

extern char *names[] ;		/* names of all commands */
extern pfi proc[] ;		/* routine to call for each command */

char *greet[] = {
"                          Macaulay\n",
"        A computer algebra system for algebraic geometry",
"\n\n",
"    This program, Macaulay, may be freely copied for others.  We\n",
"request that you write us to join a mailing list of Macaulay users,\n",
"so that we can keep you informed of updates to Macaulay.\n",
/*
"    Type \"help\" for a list of commands.\n",
"    Type \"new\" for a list of new features.\n",
*/
"\n",
"    Dave Bayer               ",
"    Mike Stillman\n",
"    Department of Mathematics",
"    Department of Mathematics\n",
"    Barnard College          ",
"    Cornell University\n",
"    New York, NY 10027       ",
"    Ithaca, NY 14853\n",
"    (212)854-2643, 864-4235  ",
"    (607)255-7240, 257-5320\n",
"    dab@math.columbia.edu    ",
"    mike@math.cornell.edu\n",
"\n",
""
};

/* issubseq: returns -1 if s < t, 1 if s > t, and 
 * 0 if s is a substring of t.
 */

int issubseq(s, t) 
char *s, *t ;
{
    while ((*s ISNT '\0') AND (*t ISNT '\0')) {
	if (*s > *t)
	    return(1) ;
	if (*s < *t)
	    return(-1) ;
	*s++ ;
	*t++ ;
    }
    if (*s IS '\0')
        return(0) ;
    else 
        return(1) ;
}

int 
lookup(names,s)
char *names[] ;
char *s ;
{
    int i, val ;
 
    for (i=0; *(names[i]) ISNT '\0' ; i++) {
	val = issubseq(s, names[i]) ;
	if (val IS 0)
	    return(i) ;
	if (val IS -1)
	  return(-1) ;
    }
    return(-1) ;
}
 
do_init()
{
	extern char *Version, *Date ;

	i_set() ;
	init_mem() ;
	init_path() ;
	i_stashes() ;
	array_init() ;
	init_rings() ;
	init_generic() ;
	init_vars() ;
	init_polys() ;
	init_division() ;
	mn_first() ;
	initHack();
}

reset_cmd()
{
    i_set() ;
    reset_mem() ;
    init_path() ;
    i_stashes() ;
    array_init() ;
    init_rings() ;
    init_generic() ;
    init_vars() ;
    init_polys() ;
    init_division() ;
    mn_first() ;
    initHack();
    to_shell() ;
}

boolean doInitFile()
{
  FILE *fil, *topen() ;

  fil = topen("Macaulay.init", "r") ;
  if (fil IS NULL) return(FALSE) ;
  fclose(fil) ;
  open_tour("Macaulay.init") ;
  return(TRUE) ;
}

main()
{
	i_sniff() ;
	spec_init() ;
	do_init() ;
	if (setjmp(envbuf))
		prerror("; back to the top\n") ;
	
	level = -1 ;
	change_level() ;
	shell() ;
	exitMacaulay() ;
}

exit_cmd(argc,argv)
{
#ifdef ANSI
 #pragma unused(argv)
#endif
	if (argc > 1)
		exitMacaulay() ;
	else {
		level-- ;
		change_level() ;
	}
}

continue_cmd()
{
    /* need level = 0 means at "top" level */

    if (level > 0) {
	level-- ;
	change_level() ;
    }
}

break_cmd()
{
    break_voice() ;
}

shout_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	int i ;
	int oldlevel ;
	
	if (argc IS 1) {
		printnew("shout command arg1 arg2 ...\n") ;
		return ;
	}
	oldlevel = prlevel ;
	prlevel = 0 ;
	i = lookup(names, argv[1]) ;
	if (i >= 0) (*(proc[i]))(argc-1, argv+1) ;
	prlevel = oldlevel ;
}

vers_cmd()
{
	extern char *Version, *Date ;

	fnewline(outfile) ;
	fprint(outfile, "version %s, created %s\n", Version, Date) ;
}

to_shell()
{
	longjmp(envbuf, -1) ;
}

shell()
{
    char *outname ;
    int argc ;
    char **argv ;
    int i, thislevel ;
    FILE *topen();
    extern char *Version,*Date;

    flushnum = 0 ;  /* used to control verbose output */
    if (level == -1) {
	level = 0;
	change_level() ;
#ifdef THINK_C
	printf("\n");
	fflush(stdout);
#endif
	if (NOT doInitFile()) 
	  for (i=0; *greet[i]!='\0'; ++i)
	    print(greet[i]);
	print("Macaulay version %s, created %s\n", Version, Date) ;
    } else {
	level++ ;
	if (!change_level()) {
	    prerror("; Sorry, too many levels deep. Call first next time!\n");
	    level--;
	    return;
	}
    }
    thislevel = level ;	/* only calling exit_cmd changes level */
    while (thislevel == level) {
	get_cmd_line(&argc, &argv, &outname) ;
	if (outname IS NULL) 
	    outfile = stdout ;
	else {
	    outfile = topen(outname, "w") ;
	    if (outfile IS NULL) {
		prerror("; output file can't be opened\n") ;
		outfile = stdout ;
	    }
	}
	flushnum = 0 ;  /* reset verbose output */
	i = lookup(names, argv[0]) ;
	rmmouse() ;	/* remove any pending interrupts */
	markTime() ;
	if (i >= 0) (*(proc[i]))(argc, argv) ;
	else prerror("; command not found\n") ;
	prTime("elapsed time : ") ;

	if (outfile ISNT stdout) fclose(outfile) ;
	garb_collect() ;
    }
}

ech_cmd(argc, argv)
int argc ;
char *argv[] ;
{
	int i;

	for (i=1; i<argc; ++i) fprint(outfile, "%s ", argv[i]);
	fprint(outfile, "\n");
}

clac_cmd(argc, argv)
int argc ;
char *argv[] ;
{
    newline() ;
    print("calc\n");
    calc_cmd(argc, argv);
}
