#include <stdio.h>
#include "datatype.h"
#include "stackm.h"
#include "extern.h"
#include "extern2.h"

/*    Files from  msg*p.c */
int KpvmStartSlaves(char *name,int n);
int KpvmStopSlaves(void);
int KpvmChangeStateOfSlaves(int k);
int KpvmMcast(char *comm);
struct object KpvmJobPool(struct object obj);

struct object Kextension(struct object obj)
{
  char *key;
  int size;
  struct object keyo;
  struct object rob = NullObject;
  struct object obj1,obj2,obj3;
  int m,i;

  if (obj.tag != Sarray) errorKan1("%s\n","Kextension(): The argument must be an array.");
  size = getoaSize(obj);
  if (size < 1) errorKan1("%s\n","Kextension(): Empty array.");
  keyo = getoa(obj,0);
  if (keyo.tag != Sdollar) errorKan1("%s\n","Kextension(): No key word.");
  key = KopString(keyo);

  /* branch by they key word. */
  if (strcmp(key,"parse")==0) {
    if (size != 2) errorKan1("%s\n","[(parse)  string] extension.");
    obj1 = getoa(obj,1);
    if (obj1.tag != Sdollar) errorKan1("%s\n","[(parse)  string] extension");
    KSexecuteString(obj1.lc.str);
  }else if (strcmp(key,"asir0") == 0) {
    if (size != 2) errorKan1("%s\n","[(asir0)  string] extension result.");
    obj1 = getoa(obj,1);
    if (obj1.tag != Sdollar) errorKan1("%s\n","[(asir0)  string] extension result");
    KasirKanExecute0(obj1.lc.str);
    rob = KSpop();
  }else if (strcmp(key,"start slaves")==0) {
    if (size != 3)
      errorKan1("%s\n","[(start slaves) (slave name) n] extension");
    obj1 = getoa(obj,1);
    obj2 = getoa(obj,2);
    if (obj1.tag != Sdollar || obj2.tag != Sinteger)
      errorKan1("%s\n","[(start slaves) (slave name) n] extension");
    if (KpvmStartSlaves(obj1.lc.str,obj2.lc.ival)<0)
      errorKan1("%s\n","Failed to start slaves.");
  }else if (strcmp(key,"stop slaves")==0) {
    if (KpvmStopSlaves() < 0)
      errorKan1("%s\n","Failed to stop slaves.");
  }else if (strcmp(key,"mcast") == 0) {
    if (size != 2)
      errorKan1("%s\n","[(mcast) (command)] extension");
    obj1 = getoa(obj,1);
    if (obj1.tag != Sdollar)
      errorKan1("%s\n","[(mcast) (command)] extension");
    if (KpvmMcast(obj1.lc.str)<0)
      errorKan1("%s\n","Failed to mcast to slaves.");
  }else if (strcmp(key,"job pool") == 0) {
    if (size != 2)
      errorKan1("%s\n","[(job pool) list] extension");
    obj1 = getoa(obj,1);
    if (obj1.tag != Sarray)
      errorKan1("%s\n","[(job pool) list] extension. Argumet must be an array.");
    m = getoaSize(obj1);
    for (i=0; i<m; i++) {
      obj2 = getoa(obj1,i);
      if (obj2.tag != Sdollar) {
	errorKan1("%s\n","[(job pool) list] extension. Elements must be strings.");
      }
    }
    rob = KpvmJobPool(obj1);
  }else if (strcmp(key,"change slaves") == 0) {
    if (KpvmChangeStateOfSlaves(0)<0) {
      errorKan1("%s\n","Failed to change the state of slaves.");
    }
  }



  return(rob);
}

