#include <stdio.h>
#include "datatype.h"
#include "extern2.h"
#include "matrix.h"
#include "gradedset.h"

static int Message = 1;
  
static POLY getFactor0(struct gradedPolySet *grG,int grd,int index);
static void clearMark(struct gradedPolySet *grG);
static void printMatrixOfPOLY(struct matrixOfPOLY *mat);
static void printArrayOfPOLY(struct arrayOfPOLY *mat);
static int isZeroRow(struct matrixOfPOLY *mat,int i);

/* if (mark[j]), then the simplification is done. */
void getBackwardTransformation(grG)
struct gradedPolySet *grG;
/* grG->polys[i]->mark[j],syz[j] are modified. */
{
  int i,j;
  struct polySet *ps;


  for (i=0; i<grG->maxGrade; i++) {
    ps = grG->polys[i];
    for (j=0; j<ps->size; j++) {
      if (ps->mark[j] == 0 && ps->del[j] == 0) {
	simplifyBT(i,j,grG);
      }
    }
  }
}

void simplifyBT(grd,index,grG)
int grd;
int index;
struct gradedPolySet *grG;
{
  POLY s,r;
  int g0,i0;

  s = grG->polys[grd]->syz[index]->syz;
  r = ZERO;

  if (Message) {printf("."); fflush(stdout); }
  
  while (s != ZERO) {
    g0 = srGrade(s);
    i0 = srIndex(s);
    if (grG->polys[g0]->mark[i0]) {
      r = ppAdd(r,cpMult(s->coeffp,grG->polys[g0]->syz[i0]->syz));
    }else{
      simplifyBT(g0,i0,grG);
      r = ppAdd(r,cpMult(s->coeffp,grG->polys[g0]->syz[i0]->syz));
    }
    s = s->next;
  }
  grG->polys[grd]->syz[index]->syz = r;
  grG->polys[grd]->mark[index] = 1;
}


static POLY getFactor0(grG,grd,index)
struct gradedPolySet *grG;
int grd;
int index;
{
  POLY ans;
  int i,j;
  struct polySet *ps;

  ans = cxx(1,0,0,grG->polys[grd]->g[index]->m->ringp);
  for (i=0; i<grG->maxGrade; i++) {
    ps = grG->polys[i];
    for (j=0; j<ps->size; j++) {
      if (ps->mark[j] && !(i == grd && j == index)) {
	ans = ppMult(ps->syz[j]->cf,ans);
      }
    }
  }
  return(ans);
}

struct arrayOfPOLY *getSyzygy0(grG,zeroPairs)
struct gradedPolySet *grG;
struct pair *zeroPairs;
{
  struct pair *tmp;
  int size,k,i;
  POLY s;
  struct arrayOfPOLY *r;
  struct arrayOfPOLY *ans;

  tmp = zeroPairs; size = 0;
  while (tmp != (struct pair *)NULL) {
    size++;
    tmp = tmp->next;
  }
  ans = newArrayOfPOLY(size+1);

  k = 0;

  while (zeroPairs != (struct pair *)NULL) {
    s = getSyzPolyFromSp(zeroPairs,grG);
    if (s ISZERO) {

    }else {
      getArrayOfPOLY(ans,k) = s;
      k++;
    }
    zeroPairs = zeroPairs->next;
  }

  r = newArrayOfPOLY(k);
  for (i=0; i<k; i++) {
    getArrayOfPOLY(r,i) = getArrayOfPOLY(ans,i);
  }
  return(r);
}

struct matrixOfPOLY *getSyzygy(grG,zeroPairs,grBasesp,backwardMatp)
struct gradedPolySet *grG;
struct pair *zeroPairs;
struct gradedPolySet **grBasesp;
struct matrixOfPOLY **backwardMatp;
{
  int serial;
  int i,j,kk;
  struct polySet *ps;
  POLY fi;
  int grd,ind;
  struct gradedPolySet *newG;
  POLY r;
  struct syz0 syz;
  struct arrayOfPOLY *ap,*vec;
  struct matrixOfPOLY *mp;
  struct matrixOfPOLY *b,*nc,*m2,*m1,*ans,*ans2;
  struct arrayOfPOLY *dc;

  /* set grBases */
  *grBasesp = newGradedPolySet(0);
  serial = 0;
  for (i=0; i<grG->maxGrade; i++) {
    ps = grG->polys[i];
    for (j=0; j<ps->size; j++) {
      if (ps->del[j] == 0) {
	fi = ps->g[j];
	whereInG(*grBasesp,fi,&grd,&ind);
	*grBasesp =
	  putPolyInG(*grBasesp,fi,grd,ind,(struct syz0 *)NULL,0,serial);
	serial++;
      }
    }
  }

  /* set newG. Compute the forward transformations.*/
  newG = gradedPolySetCopy(grG);
  for (i=0; i<grG->maxGrade;i++) {
    ps = newG->polys[i];
    for (j=0; j<ps->size; j++) {
      fi = ps->g[j];
      r = (*reduction)(fi,*grBasesp,1,&syz);
      if (Message) {printf("."); fflush(stdout);}
      if (! (r ISZERO)) errorSyz0("Internal error; getSyzygy(): groebner basis must be given.");
      ps->syz[j] = newSyz0();
      /* printf("%s : ",POLYToString(syz.cf,'*',1));
         printf("%s\n",POLYToString(syz.syz,'*',1)); */
      ps->syz[j]->cf = syz.cf;
      ps->syz[j]->syz = syz.syz;
    }
  }

  ap = getSyzygy0(newG,zeroPairs);

  /* We compute E-CB. The number of G (G-basis) is serial. */
  /* F = - C G,  G = B F , then  F + CB F = 0*/
  b = getBackwardMatrixOfPOLY(grG);
  nc = getNC(newG,serial,*grBasesp);
  dc = getDC(newG);
  /*{
    printf("\nb=\n"); printMatrixOfPOLY(b);
    printf("\n\nnc=\n"); printMatrixOfPOLY(nc);
    printf("\n\ndc=\n"); printArrayOfPOLY(dc);
  }*/
    
  if (Message) {printf(":"); fflush(stdout);}
  m2 = getSyzygy1(b,nc,dc);
  *backwardMatp = b;
  
  /* mp is the syzygy of the G-basis. */
  mp = newMatrixOfPOLY(ap->n,serial);
  for (i=0; i < ap->n; i++) {
    vec = syzPolyToArrayOfPOLY(serial,getArrayOfPOLY(ap,i),*grBasesp);
    for (j=0; j < serial; j++) {
      getMatrixOfPOLY(mp,i,j) = getArrayOfPOLY(vec,j);
    }
  }

  if (Message) {printf(";"); fflush(stdout);}
  m1 = aaMult(mp,b);

  ans = newMatrixOfPOLY((m1->m)+(m2->m),m2->n);
  kk = 0;
  for (i=0; i<m1->m; i++) {
    if (!isZeroRow(m1,i)) {
      for (j=0; j<m1->n; j++) {
	getMatrixOfPOLY(ans,kk,j) = getMatrixOfPOLY(m1,i,j);
      }
      kk++;
    }
  }
  for (i=0; i<m2->m; i++) {
    if (!isZeroRow(m2,i)) {
      for (j=0; j<m2->n; j++) {
	getMatrixOfPOLY(ans,kk,j) = getMatrixOfPOLY(m2,i,j);
      }
      kk++; printf("*");
    }
  }
  if (kk != ans->m) {
    ans2 = newMatrixOfPOLY(kk,ans->n);
    for (i=0; i<kk; i++) {
      for (j=0; j<ans->n; j++) {
	getMatrixOfPOLY(ans2,i,j) = getMatrixOfPOLY(ans,i,j);
      }
    }
    return(ans2);
  }else{
    return(ans);
  }

}

POLY getSyzPolyFromSp(spij,grG)
struct pair *spij;
struct gradedPolySet *grG;
{
  int ig,ii,jg,ji;
  POLY dk;
  POLY f;
  POLY t,ans;
  int grd,ind;

  ig = spij->ig; ii = spij->ii;
  jg = spij->jg; ji = spij->ji;
  if (grG->polys[ig]->del[ii] != 0 || grG->polys[jg]->del[ji] != 0)
    return(ZERO);
  dk = spij->syz; /* in SyzRing */
  clearMark(grG);
  f = dk;
  while (f != POLYNULL) {
    grd = srGrade(f);
    ind = srIndex(f);
    grG->polys[grd]->mark[ind] = 1;
    f=f->next;
  }

  f = dk; ans = ZERO;
  while (f != POLYNULL) {
    grd = srGrade(f);
    ind = srIndex(f);
    t = grG->polys[grd]->syz[ind]->syz;
    t = cpMult(f->coeffp,t);
    t = cpMult(toSyzCoeff(getFactor0(grG,grd,ind)),t);
    ans = ppAdd(ans,t);
    f = f->next;
  }
  return(ans);
}

static void clearMark(grG)
struct gradedPolySet *grG;
{
  int i,j;
  struct polySet *ps;
  for (i=0; i<grG->maxGrade; i++) {
    ps = grG->polys[i];
    for (j=0; j<ps->size; j++) {
      ps->mark[j] = 0;
    }
  }
}


struct arrayOfPOLY *syzPolyToArrayOfPOLY(size,f,grG)
int size;
POLY f; /* f is in the SyzRingp */
struct gradedPolySet *grG;
{
  struct arrayOfPOLY *ap;
  int i,g0,i0,serial;

  ap = newArrayOfPOLY(size);
  for (i=0; i<size; i++) {
    getArrayOfPOLY(ap,i) = ZERO;
  }

  while (f != POLYNULL) {
    g0 = srGrade(f);
    i0 = srIndex(f);
    serial = grG->polys[g0]->serial[i0];
    if (serial < 0) {
      errorSyz0("syzPolyToArrayOfPOLY(): invalid serial[i] of grG.");
    }
    if (getArrayOfPOLY(ap,serial) != ZERO) {
      errorSyz0("syzPolyToArrayOfPOLY(): syzygy polynomial is broken.");
    }
    getArrayOfPOLY(ap,serial) = srSyzCoeffToPOLY(f->coeffp);
    f = f->next;
  }
  return(ap);
}



struct matrixOfPOLY *getBackwardMatrixOfPOLY(struct gradedPolySet *grG)
{
  /* use serial, del.  cf. getBackwardArray() */
  int inputSize,outputSize;
  int i,j,k,p;
  struct arrayOfPOLY *vec;
  struct matrixOfPOLY *mat;
  struct polySet *ps;
  
  inputSize = 0; outputSize = 0;
  for (i=0; i<grG->maxGrade; i++) {
    ps = grG->polys[i];
    for (j=0; j<ps->size; j++) {
      if (ps->serial[j] >= 0) ++inputSize;
      if (ps->del[j] == 0) ++outputSize;
    }
  }

  mat = newMatrixOfPOLY(outputSize,inputSize);
  k = 0;
  for (i=0; i<grG->maxGrade; i++) {
    ps = grG->polys[i];
    for (j=0; j<ps->size; j++) {
      if (ps->del[j] == 0) {
	vec = syzPolyToArrayOfPOLY(inputSize,ps->syz[j]->syz,grG);
	for (p=0; p<inputSize; p++) {
	  getMatrixOfPOLY(mat,k,p)=getArrayOfPOLY(vec,p);
	}
	k++;
      }
    }
  }
  return(mat);
}


struct matrixOfPOLY *getNC(newG,n,grBases)
struct gradedPolySet *newG;   /* F is stored and indexed by serial. */
int n;                        /* The number of G. */
struct gradedPolySet *grBases; /* G (G-basis) is stored. */
{
  int size,i,j,k,ii;
  struct matrixOfPOLY *mat;
  struct polySet *ps;
  struct arrayOfPOLY *vec;
  
  if (newG == (struct gradedPolySet *)NULL) {
    return(newMatrixOfPOLY(0,0));
  }
  size = 0;
  for (i=0; i<newG->maxGrade; i++) {
    ps = newG->polys[i];
    for (j=0; j<ps->size; j++) {
      if (ps->serial[j] >= 0) size++;
    }
  }
  mat = newMatrixOfPOLY(size,n);
  for (i=0; i<newG->maxGrade; i++) {
    ps = newG->polys[i];
    for (j=0; j<ps->size; j++) {
      if (ps->serial[j] >= 0) {
	ii = ps->serial[j]; 
	vec = syzPolyToArrayOfPOLY(n,ps->syz[j]->syz,grBases);
	for (k=0; k<n; k++) {
	  getMatrixOfPOLY(mat,ii,k) = getArrayOfPOLY(vec,k);
	}
      }
    }
  }
  return(mat);
}
  
struct arrayOfPOLY *getDC(newG)
struct gradedPolySet *newG;   /* F is stored and indexed by serial. */
{
  int size,i,j,k,ii;
  struct arrayOfPOLY *mat;
  struct polySet *ps;
  extern struct ring *CurrentRingp;
  
  if (newG == (struct gradedPolySet *)NULL) {
    return(newArrayOfPOLY(0));
  }
  size = 0;
  for (i=0; i<newG->maxGrade; i++) {
    ps = newG->polys[i];
    for (j=0; j<ps->size; j++) {
      if (ps->serial[j] >= 0) size++;
    }
  }
  mat = newArrayOfPOLY(size);
  for (i=0; i<newG->maxGrade; i++) {
    ps = newG->polys[i];
    for (j=0; j<ps->size; j++) {
      if (ps->serial[j] >= 0) {
	ii = ps->serial[j];
	getArrayOfPOLY(mat,ii) = ps->syz[j]->cf;
      }
    }
  }
  return(mat);
}
  


/* Syzygy from E-CB */
struct matrixOfPOLY *getSyzygy1(b,nc,dc)
struct matrixOfPOLY *b;
struct matrixOfPOLY *nc;
struct arrayOfPOLY *dc;
{
  int m,n2,n;
  struct matrixOfPOLY *mat;
  int i,j,k;
  POLY r;
  POLY tmp;

  m = nc->m;
  n2 = nc->n;
  n = b->n;
  mat = newMatrixOfPOLY(m,n);
  for (i=0; i<m; i++) {
    for (j=0; j<n; j++) {
      r = ZERO;
      if (i == j) {
	r = getArrayOfPOLY(dc,i);
      }
      for (k=0; k<n2; k++) {
	tmp = ppMult(getMatrixOfPOLY(nc,i,k),getMatrixOfPOLY(b,k,j));
	r = ppAdd(r,tmp);
      }
      getMatrixOfPOLY(mat,i,j) = r;
    }
  }
  return(mat);
}

static int isZeroRow(mat,i)
struct matrixOfPOLY *mat;
int i;
{
  int n,j;
  n = mat->n;
  for (j=0; j<n; j++) {
    if (getMatrixOfPOLY(mat,i,j) != ZERO) return(0);
  }
  return(1);
}

void errorSyz0(s)
char *s;
{
  fprintf(stderr,"Error(syz0.c): %s \n",s);
  exit(10);
}
    
			       
static void printMatrixOfPOLY(mat)
struct matrixOfPOLY *mat;
{
  int n,m,i,j;
  POLY f;
  m = mat->m; n = mat->n;
  for (i=0; i<m; i++) {
    for (j=0; j<n; j++) {
      f = getMatrixOfPOLY(mat,i,j);
      printf("%s,  ",POLYToString(f,'*',1));
    }
    printf("\n");
  }
  printf("\n\n");
}

static void printArrayOfPOLY(mat)
struct arrayOfPOLY *mat;
{
  int n,m,i,j;
  POLY f;
  m = mat->n;
  for (i=0; i<m; i++) {
    f = getArrayOfPOLY(mat,i);
    printf("%s,  ",POLYToString(f,'*',1));
  }
  printf("\n\n");
}

