/* sm.c */
#define DATE "1996/08/07"
#define RELEASE "2.960807"

#include <stdio.h>
#include "datatype.h"
#include "stackm.h"
#include "extern.h"

extern int StandardMacros;
extern int StartAFile;
extern char *StartFile;
extern int Quiet;


main(argc,argv) 
int argc;
char *argv[];
{
  int i;
  StandardMacros = 1;
  if (argc > 1) {
    for (i=1; i<argc; i++) {
      if (strcmp(argv[i],"-standardmacros") == 0) {
	StandardMacros = 0; /* disable of the standard macros */
      }else if (strcmp(argv[i],"-f") == 0) {
	StartAFile = 1;
	i++;
	if (i >= argc) {
	  fprintf(stderr,"Usage: 1. sm1\n2. sm1 -f filename\n");
	  fprintf(stderr,"3. sm1 -standardmacros\n");
	  exit(15);
	}
	StartFile = argv[i];
      } else if (strcmp(argv[i],"-q") == 0) {
	Quiet = 1;
      }else{
	fprintf(stderr,"Usage: 1. sm1\n2. sm1 -f filename\n");
	fprintf(stderr,"3. sm1 -standardmacros\n");
	fprintf(stderr,"4. sm1 -q  (quiet)\n");
	exit(15);
      }
    }
  }


  stackmachine_init();
  if (!Quiet) {
    fprintf(Fstack,"\n");
    fprintf(Fstack,"Kan/StackMachine1");
    fprintf(Fstack,"                         1991 April --- 1996.\n");
    fprintf(Fstack,"                              Release %s (c) N. Takayama\n",
	    RELEASE);
    fprintf(Fstack,"This software may be freely distributed as is ");
    fprintf(Fstack,"with no warranty expressed.\n");
    fprintf(Fstack,"Please address bug reports and advices to kan@math.s.kobe-u.ac.jp\n");
#ifdef NOGC
    fprintf(Fstack,"No garbage collector is installed.\n");
#endif
  }
  KinitKan();
  if (!Quiet) {
    fprintf(Fstack,"\nReady\n\n");
  }
  scanner();
  Kclose();  stackmachine_close();
}



