#include <stdio.h>
#include "datatype.h"
#include "stackm.h"
#include "extern.h"
#include "extern2.h"
#include "lookup.h"
#include "matrix.h"
#include "gradedset.h"

static int Message = 1;
  
/** :kan, :ring */
struct object Kreduction(f,set)
struct object f;
struct object set;
{
  POLY r;
  struct gradedPolySet *grG;
  struct syz0 syz;
  struct object rob;
  extern int ReduceLowerTerms;
  
  if (f.tag != Spoly) errorKan1("%s\n","Kreduction(): the first argument must be a polynomial.");
  if (set.tag != Sarray) errorKan1("%s\n","Kreduction(): the second argument must be a set of polynomials.");

  grG = arrayToGradedPolySet(set);
  if (ReduceLowerTerms) {
    r = (*reductionCdr)(f.lc.poly,grG,1,&syz);
  }else{
    r = (*reduction)(f.lc.poly,grG,1,&syz);
  }
  rob = newObjectArray(4);
  putoa(rob,0,KpoPOLY(r));
  putoa(rob,1,KpoPOLY(syz.cf));
  putoa(rob,2,syzPolyToArray(getoaSize(set),syz.syz,grG));
  putoa(rob,3,gradedPolySetToArray(grG,1));
  return(rob);
}

struct object Kgroebner(ob)
struct object ob;
{
  int needSyz = 0;
  int needBack = 0;
  int needInput = 0;
  int countDown = 0;
  int cdflag = 0;
  struct object ob1,ob2,ob2c;
  int i;
  struct gradedPolySet *grG;
  struct pair *grP;
  struct arrayOfPOLY *a;
  struct object rob;
  struct gradedPolySet *grBases;
  struct matrixOfPOLY *mp;
  struct matrixOfPOLY *backwardMat;
  struct object ob1New;
  extern char *F_groebner;
  extern int CheckHomogenization;

  if (ob.tag != Sarray) errorKan1("%s\n","Kgroebner(): The argument must be an array.");
  switch(getoaSize(ob)) {
  case 1:
    needBack = 0; needSyz = 0; needInput = 0;
    ob1 = getoa(ob,0);
    break;
  case 2:
    ob1 = getoa(ob,0);
    ob2 = getoa(ob,1);
    if (ob2.tag != Sarray) {
      errorKan1("%s\n","Kgroebner(): The options must be given by an array.");
    }
    for (i=0; i<getoaSize(ob2); i++) {
      ob2c = getoa(ob2,i);
      if (ob2c.tag == Sdollar) {
	if (strcmp(ob2c.lc.str,"needBack")==0) {
	  needBack = 1;
	}else if (strcmp(ob2c.lc.str,"needSyz")==0) {
	  if (!needBack) {
	    warningKan("Kgroebner(): needBack is automatically set.");
	  }
	  needSyz = needBack = 1;
	}else if (strcmp(ob2c.lc.str,"countDown")==0) {
	  countDown = 1; cdflag = 1;
	  if (needSyz) {
	    warningKan("Kgroebner(): needSyz is automatically turned off.");
	    needSyz = 0;
	  }
	}else {
	  warningKan("Unknown keyword for options.");
	}
      }else if (ob2c.tag == Sinteger) {
	if (cdflag) {
	  cdflag = 0;
	  countDown = KopInteger(ob2c);
	}
      }
    }
    break;
  default:
    errorKan1("%s\n","Kgroebner(): [ [polynomials] ] or [[polynomials] [options]].");
  }
	 
  if (ob1.tag != Sarray) errorKan1("%s\n","Kgroebner(): The argument must be an array. Example: [ [$x-1$ . $x y -2$ .] [$needBack$ $needSyz$ $needInput$]] ");
  ob1New = newObjectArray(getoaSize(ob1));
  for (i=0; i< getoaSize(ob1); i++) {
    if (getoa(ob1,i).tag == Spoly) {
      putoa(ob1New,i,getoa(ob1,i));
    }else if (getoa(ob1,i).tag == Sarray) {
      /* If the generater is given as an array, flatten it. */
      putoa(ob1New,i,KpoPOLY( arrayToPOLY(getoa(ob1,i))));
    }else{
      errorKan1("%s\n","Kgroebner(): The elements must be polynomials or array of polynomials.");
    }
    /* getoa(ob1,i) is poly, now check the homogenization. */
    if (CheckHomogenization) {
      if ((strcmp(F_groebner,"standard")==0) &&
	  !isHomogenized(KopPOLY(getoa(ob1New,i)))) {
	fprintf(stderr,"\n%s",KPOLYToString(KopPOLY(getoa(ob1New,i))));
	errorKan1("%s\n","Kgroebner(): The above polynomial is not homogenized. cf. homogenize.");
      }
    }
  }
  ob1 = ob1New;
  a = arrayToArrayOfPOLY(ob1);
  for (i=0; i< a->n; i++) {
    if (getArrayOfPOLY(a,i) ISZERO) {
      errorKan1("%s\n","groebner(): 0 is given as an element of the generator.");
    }
  }
  grG = (*groebner)(a,needBack,needSyz,&grP,countDown);

  if (strcmp(F_groebner,"gm") == 0 && (needBack || needSyz)) {
    warningKan("The options needBack and needSyz are ignored.");
    needBack = needSyz = 0;
  }
  
  /*return(gradedPolySetToGradedArray(grG,0));*/
  if (needBack && needSyz) {
    rob = newObjectArray(3);
    if (Message) {
      printf("Computing the backward transformation   ");
      fflush(stdout);
    }
    getBackwardTransformation(grG); /* mark and syz is modified. */
    if (Message) printf("Done.\n");

    /* Computing the syzygies. */
    if (Message) {
      printf("Computing the syzygies    ");
      fflush(stdout);
    }
    mp = getSyzygy(grG,grP->next,&grBases,&backwardMat);
    if (Message) printf("Done.\n");

    putoa(rob,0,gradedPolySetToArray(grG,0));
    putoa(rob,1,matrixOfPOLYToArray(backwardMat));
    putoa(rob,2,matrixOfPOLYToArray(mp));
  }else if (needBack) {
    rob = newObjectArray(2);
    if (Message) {
      printf("Computing the backward transformation.....");
      fflush(stdout);
    }
    getBackwardTransformation(grG); /* mark and syz is modified. */
    if (Message) printf("Done.\n");
    putoa(rob,0,gradedPolySetToArray(grG,0));
    putoa(rob,1,getBackwardArray(grG));
  }else { 
    rob = newObjectArray(1);
    putoa(rob,0,gradedPolySetToArray(grG,0));
  }
  return(rob);
}
  
  
  
/* :misc */

#define INITGRADE 3
#define INITSIZE 0

struct gradedPolySet *arrayToGradedPolySet(ob)
struct object ob;
{
  int n,i,grd,ind;
  POLY f;
  struct gradedPolySet *grG;
  int serial;
  
  if (ob.tag != Sarray) errorKan1("%s\n","arrayToGradedPolySet(): the argument must be array.");
  n = getoaSize(ob);
  for (i=0; i<n; i++) {
    if (getoa(ob,i).tag != Spoly)
      errorKan1("%s\n","arrayToGradedPolySet(): the elements must be polynomials.");
  }
  grG = newGradedPolySet(INITGRADE);

  for (i=0; i<grG->lim; i++) {
    grG->polys[i] = newPolySet(INITSIZE);
  }
  for (i=0; i<n; i++) {
    f = KopPOLY(getoa(ob,i));
    whereInG(grG,f,&grd,&ind);
    serial = i;
    grG = putPolyInG(grG,f,grd,ind,(struct syz0 *)NULL,1,serial);
  }
  return(grG);
}


struct object polySetToArray(ps,keepRedundant)
struct polySet *ps;
int keepRedundant;
{
  int n,i,j;
  struct object ob;
  if (ps == (struct polySet *)NULL) return(newObjectArray(0));
  n = 0;
  if (keepRedundant) {
    n = ps->size;
  }else{
    for (i=0; i<ps->size; i++) {
      if (ps->del[i] == 0) ++n;
    }
  }
  ob = newObjectArray(n);
  j = 0;
  for (i=0; i<ps->size; i++) {
    if (keepRedundant || (ps->del[i] == 0)) {
      putoa(ob,j,KpoPOLY(ps->g[i]));
      j++;
    }
  }
  return(ob);
}


struct object gradedPolySetToGradedArray(gps,keepRedundant)
struct gradedPolySet *gps;
int keepRedundant;
{
  struct object ob,vec;
  int i;
  if (gps == (struct gradedPolySet *)NULL) return(NullObject);
  ob = newObjectArray(gps->maxGrade +1);
  vec = newObjectArray(gps->maxGrade);
  for (i=0; i<gps->maxGrade; i++) {
    putoa(vec,i,KpoInteger(i));
    putoa(ob,i+1,polySetToArray(gps->polys[i],keepRedundant));
  }
  putoa(ob,0,vec);
  return(ob);
}

  
struct object gradedPolySetToArray(gps,keepRedundant)
struct gradedPolySet *gps;
int keepRedundant;
{
  struct object ob,vec;
  struct polySet *ps;
  int k;
  int i,j;
  int size;
  if (gps == (struct gradedPolySet *)NULL) return(NullObject);
  size = 0;
  for (i=0; i<gps->maxGrade; i++) {
    ps = gps->polys[i];
    if (keepRedundant) {
      size += ps->size;
    }else{
      for (j=0; j<ps->size; j++) {
	if (ps->del[j] == 0) ++size;
      }
    }
  }
    
  ob = newObjectArray(size);
  k = 0;
  for (i=0; i<gps->maxGrade; i++) {
    ps = gps->polys[i];
    for (j=0; j<ps->size; j++) {
      if (keepRedundant || (ps->del[j] == 0)) {
	putoa(ob,k,KpoPOLY(ps->g[j]));
	k++;
      }
    }
  }
  return(ob);
}
  

/* serial == -1  :  It's not in the marix input. */
struct object syzPolyToArray(size,f,grG)
int size;
POLY f;
struct gradedPolySet *grG;
{
  struct object ob;
  int i,g0,i0,serial;

  ob = newObjectArray(size);
  for (i=0; i<size; i++) {
    putoa(ob,i,KpoPOLY(ZERO));
  }

  while (f != POLYNULL) {
    g0 = srGrade(f);
    i0 = srIndex(f);
    serial = grG->polys[g0]->serial[i0];
    if (serial < 0) {
      errorKan1("%s\n","syzPolyToArray(): invalid serial[i] of grG.");
    }
    if (KopPOLY(getoa(ob,serial)) != ZERO) {
      errorKan1("%s\n","syzPolyToArray(): syzygy polynomial is broken.");
    }
    putoa(ob,serial,KpoPOLY(f->coeffp->val.f));
    f = f->next;
  }
  return(ob);
}

struct object getBackwardArray(grG)
struct gradedPolySet *grG;
{
  /* use serial, del.  cf. getBackwardTransformation(). */
  int inputSize,outputSize;
  int i,j,k;
  struct object ob;
  struct polySet *ps;
  
  inputSize = 0; outputSize = 0;
  for (i=0; i<grG->maxGrade; i++) {
    ps = grG->polys[i];
    for (j=0; j<ps->size; j++) {
      if (ps->serial[j] >= 0) ++inputSize;
      if (ps->del[j] == 0) ++outputSize;
    }
  }

  ob = newObjectArray(outputSize);
  k = 0;
  for (i=0; i<grG->maxGrade; i++) {
    ps = grG->polys[i];
    for (j=0; j<ps->size; j++) {
      if (ps->del[j] == 0) {
	putoa(ob,k,syzPolyToArray(inputSize,ps->syz[j]->syz,grG));
	k++;
      }
    }
  }
  return(ob);
}


POLY arrayToPOLY(ob)
struct object ob;
{
  int size,i;
  struct object f;
  POLY r;
  static int nn,mm,ll,cc,n,m,l,c;
  static struct ring *cr = (struct ring *)NULL;
  POLY ff,ee;
  MONOMIAL tf;

  if (ob.tag != Sarray) errorKan1("%s\n","arrayToPOLY(): The argument must be an array.");
  size = getoaSize(ob);
  r = ZERO;
  for (i=0; i<size; i++) {
    f = getoa(ob,i);
    if (f.tag != Spoly) errorKan1("%s\n","arrayToPOLY(): The elements must be polynomials.");
    ff = KopPOLY(f);
    if (ff != ZERO) {
      tf = ff->m;
      if (tf->ringp != cr) {
	n = tf->ringp->n;
	m = tf->ringp->m;
	l = tf->ringp->l;
	c = tf->ringp->c;
	nn = tf->ringp->nn;
	mm = tf->ringp->mm;
	ll = tf->ringp->ll;
	cc = tf->ringp->cc;
	cr = tf->ringp;
      }
      if (n-nn >0) ee = cxx(1,n-1,i,tf->ringp);
      else if (m-mm >0) ee = cxx(1,m-1,i,tf->ringp);
      else if (l-ll >0) ee = cxx(1,l-1,i,tf->ringp);
      else if (c-cc >0) ee = cxx(1,c-1,i,tf->ringp);
      else ee = ZERO;
      r = ppAddv(r,ppMult(ee,ff));
    }
  }
  return(r);
}

struct object POLYToArray(ff)
POLY ff;
{
  
  static int nn,mm,ll,cc,n,m,l,c;
  static struct ring *cr = (struct ring *)NULL;
  POLY ee;
  MONOMIAL tf;
  int k,i,matn,size;
  struct matrixOfPOLY *mat;
  POLY ex,sizep;
  struct object ob;

  if (ff != ZERO) {
    tf = ff->m;
    if (tf->ringp != cr) {
      n = tf->ringp->n;
      m = tf->ringp->m;
      l = tf->ringp->l;
      c = tf->ringp->c;
      nn = tf->ringp->nn;
      mm = tf->ringp->mm;
      ll = tf->ringp->ll;
      cc = tf->ringp->cc;
      cr = tf->ringp;
    }
    if (n-nn >0) ee = cxx(1,n-1,1,tf->ringp);
    else if (m-mm >0) ee = cxx(1,m-1,1,tf->ringp);
    else if (l-ll >0) ee = cxx(1,l-1,1,tf->ringp);
    else if (c-cc >0) ee = cxx(1,c-1,1,tf->ringp);
    else ee = ZERO;
  }else{
    ob = newObjectArray(1);
    getoa(ob,0) = KpoPOLY(ZERO);
    return(ob);
  }
  mat = parts(ff,ee);
  matn = mat->n;
  sizep = getMatrixOfPOLY(mat,0,0);
  if (sizep == ZERO) size = 1;
  else size = coeffToInt(sizep->coeffp)+1;
  ob = newObjectArray(size);
  for (i=0; i<size; i++) getoa(ob,i) = KpoPOLY(ZERO);
  for (i=0; i<matn; i++) {
    ex = getMatrixOfPOLY(mat,0,i);
    if (ex == ZERO) k = 0;
    else {
      k = coeffToInt(ex->coeffp);
    }
    getoa(ob,k) = KpoPOLY(getMatrixOfPOLY(mat,1,i));
  }
  return(ob);
}

static int isThereh(f)
POLY f;
{
  POLY t;
  if (f == 0) return(0);
  t = f;
  while (t != POLYNULL) {
    if (t->m->e[0].D) return(1);
    t = t->next;
  }
  return(0);
}

struct object homogenizeObject(ob,gradep)
struct object ob;
int *gradep;
{
  struct object rob,ob1;
  int maxg;
  int gr,flag,i,d,size;
  struct ring *rp;
  POLY f;
  extern struct ring *CurrentRingp;
  
  switch(ob.tag) {
  case Spoly:
    if (isThereh(KopPOLY(ob))) {
      fprintf(stderr,"\n%s\n",KPOLYToString(KopPOLY(ob)));
      errorKan1("%s\n","homogenizeObject(): The above polynomial has already had a homogenization variable.\nPut the homogenization variable 1 before homogenization.\ncf. replace.");
    }
    f = homogenize( KopPOLY(ob) );
    *gradep = (*grade)(f);
    return(KpoPOLY(f));
    break;
  case Sarray:
    size = getoaSize(ob);
    if (size == 0) {
      errorKan1("%s\n","homogenizeObject() is called for the empty array.");
    }
    rob = newObjectArray(size);
    flag = 0;
    ob1 = getoa(ob,0);
    ob1 = homogenizeObject(ob1,&gr);
    maxg = gr;
    getoa(rob,0) = ob1;
    for (i=1; i<size; i++) {
      ob1 = getoa(ob,i);
      ob1 = homogenizeObject(ob1,&gr);
      if (gr > maxg) {
	maxg = gr;
      }
      getoa(rob,i) = ob1;
    }
    maxg = maxg+size-1;
    if (1) {
      rp = oRingp(rob);
      if (rp == (struct ring *)NULL) rp = CurrentRingp;
      for (i=0; i<size; i++) {
	gr = oGrade(getoa(rob,i));
	/**printf("maxg=%d, gr=%d(i=%d) ",maxg,gr,i); fflush(stdout);**/
	if (maxg > gr) {
	  f = cdd(1,0,maxg-gr-i,rp); /* h^{maxg-gr-i} */
	  getoa(rob,i) = KooMult(KpoPOLY(f),getoa(rob,i));
	}
      }
    }
    *gradep = maxg;
    return(rob);
    break;
  default:
    errorKan1("%s\n","homogenizeObject(): Invalid argument data type.");
    break;
  }
}

struct ring *oRingp(ob)
struct object ob;
{
  struct ring *rp,*rptmp;
  int i,size;
  POLY f;
  switch(ob.tag) {
  case Spoly:
    f = KopPOLY(ob);
    if (f == ZERO) return((struct ring *)NULL);
    return( f->m->ringp);
    break;
  case Sarray:
    size = getoaSize(ob);
    rp = (struct ring *)NULL;
    for (i=0; i<size; i++) {
      rptmp = oRingp(getoa(ob,i));
      if (rptmp != (struct ring *)NULL) rp = rptmp;
      return(rp);
    }
    break;
  default:
    errorKan1("%s\n","oRingp(): Invalid argument data type.");
    break;
  }
}

int oGrade(ob)
struct object ob;
{
  int i,size;
  POLY f;
  int maxg,tmpg;
  switch(ob.tag) {
  case Spoly:
    f = KopPOLY(ob);
    return( (*grade)(f) );
    break;
  case Sarray:
    size = getoaSize(ob);
    if (size == 0) return(0);
    maxg = oGrade(getoa(ob,0));
    for (i=1; i<size; i++) {
      tmpg = oGrade(getoa(ob,i));
      if (tmpg > maxg) maxg = tmpg;
    }
    return(maxg);
    break;
  default:
    errorKan1("%s\n","oGrade(): Invalid data type for the argument.");
    break;
  }
}


struct object oPrincipalPart(ob)
struct object ob;
{
  POLY f;
  struct object rob;

  switch(ob.tag) {
  case Spoly:
    f = KopPOLY(ob);
    return( KpoPOLY(POLYToPrincipalPart(f)));
    break;
  default:
    errorKan1("%s\n","oPrincipalPart(): Invalid data type for the argument.");
    break;
  }
}


