#include <stdio.h>
#include "datatype.h"
#include "stackm.h"
#include "extern.h"
#include "lookup.h"


struct object KsystemVariable(ob)
struct object ob; /* Sarray */
{
  /* Don't forget to write the keys in usage.c */
  extern int PrintDollar;
  extern int Wrap;
  extern struct ring *CurrentRingp;
  extern int Verbose;
  extern int UseCriterion1;
  extern int ReduceLowerTerms;
  extern int CheckHomogenization;
  extern int Homogenize;
  extern int Statistics;
  
  struct object ob1,ob2,ob3;
  struct object rob = NullObject;
  switch (getoaSize(ob)) {
  case 1:   /* get the value */
    ob1 = getoa(ob,0);
    switch(ob1.tag) {
    case Sdollar:
      if (strcmp(ob1.lc.str,"PrintDollar") == 0) {
	rob = KpoInteger(PrintDollar);
      }else if (strcmp(ob1.lc.str,"Wrap") == 0) {
	rob = KpoInteger(Wrap);
      }else if (strcmp(ob1.lc.str,"P") == 0) {
	rob = KpoInteger(CurrentRingp->p);
      }else if (strcmp(ob1.lc.str,"N") == 0) {
	rob = KpoInteger(CurrentRingp->n);
      }else if (strcmp(ob1.lc.str,"CurrentRingp") == 0) {
	rob = KpoRingp(CurrentRingp);
      }else if (strcmp(ob1.lc.str,"Verbose") == 0) {
	rob = KpoInteger(Verbose);
      }else if (strcmp(ob1.lc.str,"UseCriterion1") == 0) {
	rob = KpoInteger(UseCriterion1);
      }else if (strcmp(ob1.lc.str,"ReduceLowerTerms") == 0) {
	rob = KpoInteger(ReduceLowerTerms);
      }else if (strcmp(ob1.lc.str,"CheckHomogenization") == 0) {
	rob = KpoInteger(CheckHomogenization);
      }else if (strcmp(ob1.lc.str,"Homogenize") == 0) {
	rob = KpoInteger(Homogenize);
      }else if (strcmp(ob1.lc.str,"Statistics") == 0) {
	rob = KpoInteger(Statistics);
      }else{
	warningKan("KsystemVariable():Unknown key word.\n");
      }
      break;
    default: 
      warningKan("KsystemVariable():Invalid argument\n");
      break;
    }
    break;
  case 2: /* set value */
    ob1 = getoa(ob,0);
    ob2 = getoa(ob,1);
    switch (Lookup[ob1.tag][ob2.tag]) {
    case SdollarSinteger:
      if (strcmp(ob1.lc.str,"PrintDollar") == 0) {
	PrintDollar = ob2.lc.ival;
	rob = KpoInteger(PrintDollar);
      }else if (strcmp(ob1.lc.str,"Wrap") == 0) {
	Wrap = ob2.lc.ival;
	rob = KpoInteger(Wrap);
      /*}else if (strcmp(ob1.lc.str,"P") == 0) {
	P = ob2.lc.ival;  Q should be set here too. 
	CurrentRingp->p = P;
	rob = KpoInteger(P); */
      }else if (strcmp(ob1.lc.str,"Verbose") == 0) {
	Verbose = ob2.lc.ival;
	rob = KpoInteger(Verbose);
      }else if (strcmp(ob1.lc.str,"UseCriterion1") == 0) {
	UseCriterion1 = ob2.lc.ival;
	rob = KpoInteger(UseCriterion1);
      }else if (strcmp(ob1.lc.str,"ReduceLowerTerms") == 0) {
	ReduceLowerTerms = ob2.lc.ival;
	rob = KpoInteger(ReduceLowerTerms);
      }else if (strcmp(ob1.lc.str,"CheckHomogenization") == 0) {
	CheckHomogenization = ob2.lc.ival;
	rob = KpoInteger(CheckHomogenization);
      }else if (strcmp(ob1.lc.str,"Homogenize") == 0) {
	Homogenize = ob2.lc.ival;
	rob = KpoInteger(Homogenize);
      }else if (strcmp(ob1.lc.str,"Statistics") == 0) {
	Statistics = ob2.lc.ival;
	rob = KpoInteger(Statistics);
      }else{
	warningKan("KsystemVariable():Unknown key word.\n");
      }
      break;
    case SdollarSring:
      if (strcmp(ob1.lc.str,"CurrentRingp") == 0) {
	CurrentRingp = ob2.lc.ringp;
	rob = KpoRingp(CurrentRingp);
      }else{
	warningKan("KsystemVariable():Unknown key word.\n");
      }
      break;
    default:
      warningKan("KsystemVariable():Invalid argument.\n");
    }
    break;
  case 3:
    ob1 = getoa(ob,0); ob2 = getoa(ob,1); ob3 = getoa(ob,2);
    switch(Lookup[ob1.tag][ob2.tag]) {
    case SdollarSdollar:
      if (strcmp(ob2.lc.str,"var") == 0) {
	if (strcmp(ob1.lc.str,"x")==0) {
	  if (ob3.tag != Sinteger) {
	    warningKan("[$x$ $var$ ? ] The 3rd argument must be integer.");
	    break;
	  }
	  if (ob3.lc.ival >= 0 && ob3.lc.ival < CurrentRingp->n) {
	    rob = KpoString(CurrentRingp->x[ob3.lc.ival]);
	  }else{
	    warningKan("[$x$ $var$ ? ] The 3rd argument is out of range.");
	    break;
	  }
	}else if (strcmp(ob1.lc.str,"D")==0) {
	  if (ob3.tag != Sinteger) {
	    warningKan("[$D$ $var$ ? ] The 3rd argument must be integer.");
	    break;
	  }
	  if (ob3.lc.ival >= 0 && ob3.lc.ival < CurrentRingp->n) {
	    rob = KpoString(CurrentRingp->D[ob3.lc.ival]);
	  }else{
	    warningKan("[$D$ $var$ ? ] The 3rd argument is out of range.");
	    break;
	  }
	}
      }else{
	warningKan("KsystemVariable(): Invalid argument.\n");
      }
      break;
    default:
      warningKan("KsystemVariable(): Invalid argument.\n");
      break;
    }
    break;
  default:
    warningKan("KsystemVariable():Invalid argument.\n");
    break;
  }
  return(rob);
}

warningOption(str)
char *str;
{
  fprintf(stderr,"Warning(option.c): %s\n",str);
}
