#include <stdio.h>
#include "datatype.h"
#include "stackm.h"
#include "extern.h"
#include "extern2.h"
#include "msgxs.h"
#include <signal.h>

/*    Files from  msg*p.c */
int KpvmStartSlaves(char *name,int n);
int KpvmStopSlaves(void);
int KpvmChangeStateOfSlaves(int k);
int KpvmMcast(char *comm);
struct object KpvmJobPool(struct object obj);

#define SIZE_OF_ENVSTACK 5
static jmp_buf EnvStack[SIZE_OF_ENVSTACK];
static int Envp = 0;
static void pushEnv(jmp_buf jb) {
  if (Envp < SIZE_OF_ENVSTACK) {
    *(EnvStack[Envp]) = *jb;
    Envp++;
  }else{
    fprintf(stderr,"Overflow of  EnvStack.\n");
    exit(2);
  }
}
static void popEnv(jmp_buf jbp) {
  if (Envp <= 0) {
    fprintf(stderr,"Underflow of EnvStack.\n");
    exit(3);
  }else{
    Envp--;
    *jbp = *EnvStack[Envp];
  }
}

struct object Kextension(struct object obj)
{
  char *key;
  int size;
  struct object keyo;
  struct object rob = NullObject;
  struct object obj1,obj2,obj3;
  int m,i;
  extern struct context *CurrentContextp;
  extern jmp_buf EnvOfStackMachine;
  extern void ctrlC();
  extern int SigIgn;

  if (obj.tag != Sarray) errorKan1("%s\n","Kextension(): The argument must be an array.");
  size = getoaSize(obj);
  if (size < 1) errorKan1("%s\n","Kextension(): Empty array.");
  keyo = getoa(obj,0);
  if (keyo.tag != Sdollar) errorKan1("%s\n","Kextension(): No key word.");
  key = KopString(keyo);

  /* branch by they key word. */
  if (strcmp(key,"parse")==0) {
    if (size != 2) errorKan1("%s\n","[(parse)  string] extension.");
    obj1 = getoa(obj,1);
    if (obj1.tag != Sdollar) errorKan1("%s\n","[(parse)  string] extension");

    pushEnv(EnvOfStackMachine);
    m = KSexecuteString(obj1.lc.str);
    /* This is critical area. If you catch ctrl-c here, program crashes. */
    signal(SIGINT,SIG_IGN);
    popEnv(EnvOfStackMachine);
    /* OK! We passed the critical area. */
    if (!SigIgn) signal(SIGINT,ctrlC);
    rob = KpoInteger(m);
  }else if (strcmp(key,"getpid") == 0) {
    rob = KpoInteger( (int) getpid() );
  }else if (strcmp(key,"asir0") == 0) {
    if (size != 2) errorKan1("%s\n","[(asir0)  string] extension result.");
    obj1 = getoa(obj,1);
    if (obj1.tag != Sdollar) errorKan1("%s\n","[(asir0)  string] extension result");
    KasirKanExecute0(obj1.lc.str);
    rob = KSpop();
  }else if (strcmp(key,"start slaves")==0) {
    if (size != 3)
      errorKan1("%s\n","[(start slaves) (slave name) n] extension");
    obj1 = getoa(obj,1);
    obj2 = getoa(obj,2);
    if (obj1.tag != Sdollar || obj2.tag != Sinteger)
      errorKan1("%s\n","[(start slaves) (slave name) n] extension");
    if (KpvmStartSlaves(obj1.lc.str,obj2.lc.ival)<0)
      errorKan1("%s\n","Failed to start slaves.");
  }else if (strcmp(key,"stop slaves")==0) {
    if (KpvmStopSlaves() < 0)
      errorKan1("%s\n","Failed to stop slaves.");
  }else if (strcmp(key,"mcast") == 0) {
    if (size != 2)
      errorKan1("%s\n","[(mcast) (command)] extension");
    obj1 = getoa(obj,1);
    if (obj1.tag != Sdollar)
      errorKan1("%s\n","[(mcast) (command)] extension");
    if (KpvmMcast(obj1.lc.str)<0)
      errorKan1("%s\n","Failed to mcast to slaves.");
  }else if (strcmp(key,"job pool") == 0) {
    if (size != 2)
      errorKan1("%s\n","[(job pool) list] extension");
    obj1 = getoa(obj,1);
    if (obj1.tag != Sarray)
      errorKan1("%s\n","[(job pool) list] extension. Argumet must be an array.");
    m = getoaSize(obj1);
    for (i=0; i<m; i++) {
      obj2 = getoa(obj1,i);
      if (obj2.tag != Sdollar) {
	errorKan1("%s\n","[(job pool) list] extension. Elements must be strings.");
      }
    }
    rob = KpvmJobPool(obj1);
  }else if (strcmp(key,"change slaves") == 0) {
    if (KpvmChangeStateOfSlaves(0)<0) {
      errorKan1("%s\n","Failed to change the state of slaves.");
    }
  }else if (strcmp(key,"chattrs")==0) {
    if (size != 2) errorKan1("%s\n","[(chattrs)  num] extension.");
    obj1 = getoa(obj,1);
    if (obj1.tag != Sinteger) errorKan1("%s\n","[(chattrs)  num] extension.");
    m = KopInteger(obj1);
    if (!( m == 0 || m == PROTECT || m == ABSOLUTE_PROTECT))
      errorKan1("%s\n","The number must be 0, 1 or 2.");
    putUserDictionary2((char *)NULL,0,0,m | SET_ATTR_FOR_ALL_WORDS,
		       CurrentContextp->userDictionary);
  }else if (strcmp(key,"chattr")==0) {
    if (size != 3) errorKan1("%s\n","[(chattr)  num symbol] extension.");
    obj1 = getoa(obj,1);
    obj2 = getoa(obj,2);
    if (obj1.tag != Sinteger) errorKan1("%s\n","[(chattr)  num symbol] extension.");
    if (obj2.tag != Sstring)  errorKan1("%s\n","[(chattr)  num symbol] extension.");
    m = KopInteger(obj1);
    if (!( m == 0 || m == PROTECT || m == ABSOLUTE_PROTECT))
      errorKan1("%s\n","The number must be 0, 1 or 2.");
    putUserDictionary2(obj2.lc.str,(obj2.rc.op->lc).ival,(obj2.rc.op->rc).ival,
		       m,CurrentContextp->userDictionary);
  
  /*  For msgxs.h  */
  }else if (strcmp(key,"sm1.socket") == 0) {
    if (size != 3)  {
      errorKan1("%s\n","[(sm1.socket) (key for sm1.socket) [ args ]] extension");
    }
    obj1 = getoa(obj,1);
    obj2 = getoa(obj,2);
    if (obj1.tag != Sdollar) {
      errorKan1("%s\n","[(sm1.socket) (key for sm1.socket) [ args ]] extension : the second argument must be a keyword.");
    }
    if (obj2.tag != Sarray) {
      errorKan1("%s\n","[(sm1.socket) (key for sm1.socket) [ args ]] extension : the third argument must be an array of argument.");
    }
    rob = Ksm1Socket(KopString(obj1),obj2);
  }else{
    errorKan1("%s\n","Unknown tag for extension.");
  }


  return(rob);
}

