#include <stdio.h>
#include "datatype.h"
#include "extern2.h"
#include "matrix.h"
#include "gradedset.h"

#define INITGRADE 4
#define INITSIZE 2

static int Debug = 0;
static int Message = 1;

extern int Statistics;
extern int Criterion1;
extern int Spairs;
extern int Criterion2B, Criterion2F, Criterion2M;


struct gradedPairs *updatePairs(grD,gt,gtGrade,t,grG)
struct gradedPairs *grD;  /* set of pairs */
POLY gt;                 /* new polynomial */
int gtGrade;
int t;
struct gradedPolySet *grG; /* (f,gt), f \in grG, should be added to grD. */
{
  int gmax,newGrade;
  struct pair *node,*new,*inode,*jnode;
  int i,k;
  struct polySet *g;
  POLY lcmp;
  POLY it,jt;
  extern int Verbose;


  if (Verbose) {
    printf("\nupdatePairs(): ");
  }

  gmax = grG->maxGrade;
  node = new = newPair((struct pair *)NULL);
  /* (f,gt) are stored in new as a list. */
  for (k=0; k<gmax; k++) {
    g = grG->polys[k];
    for (i=0; i<g->size; i++) {
      if (g->del[i] == 0 && (gtGrade != k || t != i)) {
	lcmp = (*lcm)(g->g[i],gt);
	if (lcmp == ZERO) {

	}else {
	  new->del = 0;
	  newGrade = (*grade)(lcmp);
	  new->next = newPair(new);
	  new = new->next;
	  new->lcm = lcmp;
	  new->ig = k; new->ii = i;  /* g->g[i] */
	  new->jg = gtGrade; new->ji = t; /* gt */
	  new->grade = newGrade;
	}
      }
    }
  }


  /* Check the criterion */
  /*  See Gebauer and Mora, 1988, Journal of Symbolic Computation
      279.  We must not use the test T(i)T(j) = T(i,j) because it
      does not hold in the ring of diff op.
   */
  inode = node->next;
  while (inode != (struct pair *)NULL) {
    jnode = inode->next;
    while (jnode != (struct pair *)NULL) {
      it = inode->lcm;
      jt = jnode->lcm;
      switch((*mmLarger)(it,jt)) {
      case 2:
	/* F(j,t), i<j */
	jnode->del = 1;
	if (Verbose) printf("F[%d,%d]([%d,%d],[%d,%d]) ",
			    inode->ig,inode->ii,
			    jnode->ig,jnode->ii,
			    gtGrade,t);
	Criterion2F++;
	break;
      case 1:
	/* g[i] > g[j], M(i,t) */
	if ((*isReducible)(it,jt)) {
	  inode->del = 1;
	  if (Verbose) printf("M[%d,%d]([%d,%d],[%d,%d]) ",
			      jnode->ig,jnode->ii,
			      inode->ig,inode->ii,
			      gtGrade,t);
	  Criterion2M++;
	}
	break;
      case 0: /* M(j,t) */
	if ((*isReducible)(jt,it)) {
	  jnode->del = 1;
	  if (Verbose) printf("M[%d,%d]([%d,%d],[%d,%d]) ",
			      inode->ig,inode->ii,
			      jnode->ig,jnode->ii,
			      gtGrade,t);
	  Criterion2M++;
	}
	break;
      }
      jnode = jnode->next;
    }
    inode = inode->next;
  }
	  
    
  /* Merge to grD */
  inode = node->next;
  if (Debug) outputNode(inode);
  while (inode != (struct pair *)NULL) {
    if (inode->del == 0) {
      if (grD->lim <= inode->grade) {
	grD = enlargeGradedPairs(2*(inode->grade)+1,grD);
      }
      insertPair(inode,grD->pairs[inode->grade]);
      grD->maxGrade = max(grD->maxGrade,inode->grade+1); /* don't forget */
    }
    inode = inode->next;
  }
  if (Debug) printf("OK.\n");
  if (Verbose) {
    printf(" Remaining pairs are %d. maxGrade=%d\n",countPairs(grD),grD->maxGrade);
  }
  return(grD);
}

struct gradedPolySet *groebner_gen(f,needBack,needSyz,grP,countDown)
struct arrayOfPOLY *f;
int needBack;
int needSyz;
struct pair **grP;  /* if (needSyz), it is set. */
int countDown;
{
  int r;
  struct gradedPolySet *g;
  struct gradedPairs *d;
  int i;
  int grade,ind;
  POLY gt;
  struct pair *top;
  int ig,ii,jg,ji;
  POLY gi,gj;
  struct spValue h;
  struct syz0 syz;
  int pgrade = 0;
  POLY rd;
  POLY syzPoly;
  POLY syzCf;
  struct syz0 *syzp;
  int serial;
  struct pair *listP;
  extern int Verbose;
  extern int ReduceLowerTerms;
  extern int StopDegree;
  extern struct ring *CurrentRingp;
  struct ring *rp;

  r = f->n;
  if (r<=0) return((struct gradedPolySet *)NULL);

  Spairs = Criterion1 = Criterion2B = Criterion2F = Criterion2M = 0;
  
  g = newGradedPolySet(INITGRADE);
  d = newGradedPairs(INITGRADE*2);
  for (i=0; i<g->lim; i++) {
    g->polys[i] = newPolySet(INITSIZE);
  }

  for (i=0; i<r; i++) {
    gt = getArrayOfPOLY(f,i);
    if (gt ISZERO) { rp = CurrentRingp; } else { rp = gt->m->ringp; }
    whereInG(g,gt,&grade,&ind);
    d = updatePairs(d,gt,grade,ind,g);
    serial = i;
    if (!needBack) {
      g = putPolyInG(g,gt,grade,ind,
		     (struct syz0 *)NULL,1,serial);
    }else {
      syzp = newSyz0();
      syzp->cf = cxx(1,0,0,rp);
      syzp->syz = toSyzPoly(cxx(1,0,0,rp),grade,ind);
      g = putPolyInG(g,gt,grade,ind,syzp,1,serial);
    }

    markRedundant0(g,grade,ind);
    if (Debug) {
      outputGradedPairs(d); outputGradedPolySet(g);
    }
  }
  if (needSyz) {
    *grP = newPair((struct pair *)NULL);
    listP = *grP;
  }

  while ((top = getPair(d)) != (struct pair *)NULL) {
    ig = top->ig; ii = top->ii; /* [ig,ii] */
    jg = top->jg; ji = top->ji; /* [jg,ji] */
    gi = g->polys[ig]->g[ii];
    gj = g->polys[jg]->g[ji];

    Spairs++;
    h = (*sp)(gi,gj);
    rd = ppAddv(ppMult(h.a,gi),ppMult(h.b,gj));
    rd = (*reduction)(rd,g,needBack,&syz);
    syzPoly = syz.syz;
    syzCf = syz.cf;

    if (Message) {
      if (pgrade != top->grade) {
	pgrade = top->grade;
	printf(" %d",pgrade);
	fflush(stdout);
      }else{
	if (rd ISZERO) {
	  printf("o"); fflush(stdout);
	}else{
	  printf("."); fflush(stdout);
	}
      }
    }

    if (!(rd ISZERO)) {
      if (needBack || needSyz) {
	syzp = newSyz0();
	syzp->cf = syzCf; /* no meaning */
	syzp->syz = ppAdd(toSyzPoly(h.a,ig,ii),toSyzPoly(h.b,jg,ji));
	syzp->syz = cpMult(toSyzCoeff(syzCf),syzp->syz);
	syzp->syz = ppAdd(syzp->syz,syzPoly);
      }
      
      if (ReduceLowerTerms) {
	rd = (*reductionCdr)(rd,g,needBack,&syz);
	if (needBack || needSyz) {
	  /* syzp->cf = ppMult(syz.cf,syzp->cf); no meaning */
	  syzp->syz = ppAdd(syz.syz,
			    cpMult(toSyzCoeff(syz.cf),syzp->syz)); 
	}
      }

      whereInG(g,rd,&grade,&ind);
      d = updatePairs(d,rd,grade,ind,g);
      g = putPolyInG(g,rd,grade,ind,syzp,0,-1); 
      markRedundant(g,rd,grade,ind);

      if (Message && (StopDegree < pgrade)) {
	printf("Computation of the Groebner basis is suspended bacause of StopDegree < computing grade.\n");
	printf("Note that the result is NOT groebner basis.\n");
	break;
      }
      if (countDown) {
	if (eliminated(rd) == 1) {
	  --countDown;
	  printf("x"); fflush(stdout);
	  if (countDown == 0) {
	    printf("\nThe computation of the Groebner basis is suspended because of countDown==0.\n");
	    printf("Note that the result is NOT groebner basis.\n");
	    break;
	  }
	}
      }
      if (Debug) {
	outputGradedPairs(d); outputGradedPolySet(g);
      }
    }else{
      if (needSyz) {
	top->syz = ppAdd(toSyzPoly(h.a,ig,ii),toSyzPoly(h.b,jg,ji));
	top->syz = cpMult(toSyzCoeff(syzCf),top->syz);
	top->syz = ppAdd(top->syz,syzPoly);
	listP->next = top; top->prev = listP; listP = listP->next;
      }
    }
  }

  if (Message) {
    printf("\nCompleted.\n");
  }

  if (Statistics) {
    printf("\nThe number of s-pairs is %d.\n",Spairs);
    printf("Criterion1 is applied %d times.\n",Criterion1);
    printf("Criterions M,F and B are applied M=%d, F=%d, B=%d times.\n",Criterion2M,Criterion2F,Criterion2B);
    Spairs = Criterion1 = Criterion2M = Criterion2F = Criterion2B = 0;
  }

  
  return(g);
}

  



