#include <stdio.h>
#include "datatype.h"
#include "extern2.h"

/* The format of order.
   Example:   graded lexicographic order
   x_{N-1}  x_{N-2}  ...  x_0  D_{N-1}  ....  D_{0}
    1        1             1    1              1
    1        0             0    0              0
    0        1             0    0              0
    ..............................................

   (ringp->order)[i][j] should be (ringp->order)[i*2*N+j].
   All order matrix is generated by functions in smacro.sm1
*/

static void errorOrder(char *s);

void setOrderByMatrix(order,n,c,l,omsize)
int order[];
int n,c,l,omsize;
{
  int i,j;
  int *Order;
  extern struct ring *CurrentRingp;

  switch_mmLarger("default");
    /* q-case */
  if ( l-c > 0) {
    switch_mmLarger("qmatrix");
  }

  Order = (int *)GC_malloc(sizeof(int)*(2*n)*(omsize));
  if (Order == (int *)NULL) errorOrder("No memory.");
  CurrentRingp->order = Order;
  CurrentRingp->orderMatrixSize = omsize;
  for (i=0; i<omsize; i++) {
    for (j=0; j<2*n; j++) {
      Order[i*2*n+j] = order[i*2*n+j];
    }
  }
}
  
void showRing(level,ringp) 
int level;
struct ring *ringp;
{
  int i,j;
  FILE *fp;
  char tmp[100];
  int N,M,L,C,NN,MM,LL,CC;
  char **TransX,**TransD;
  int *Order;
  int P;
  fp = stdout;

  N=ringp->n; M = ringp->m; L = ringp->l; C = ringp->c;
  NN=ringp->nn; MM = ringp->mm; LL = ringp->ll; CC = ringp->cc;
  TransX = ringp->x; TransD = ringp->D;
  Order = ringp->order;
  P = ringp->p;
  

  fprintf(fp,"\n----------  the current ring -----------\n");
  fprintf(fp,"Characteristic is %d. ",P);
  fprintf(fp,"N0=%d N=%d NN=%d M=%d MM=%d L=%d LL=%d C=%d CC=%d omsize=%d\n",N0,N,NN,M,MM,L,LL,C,CC,ringp->orderMatrixSize);
  fprintf(fp,"\n");

  /* print identifier names */
  fprintf(fp,"Differential variables: ");
  for (i=M; i<N; i++) fprintf(fp," %4s ",TransX[i]);
  for (i=M; i<N; i++) fprintf(fp," %4s ",TransD[i]);
  fprintf(fp,"\n");
  if (N-M >0) {
    fprintf(fp,"where ");
    for (i=M; i<N; i++) {
      fprintf(fp," %s %s - %s %s = 1, ",TransD[i],TransX[i],
	                                TransX[i],TransD[i]);
    }
    fprintf(fp,"\n\n");
  }
  fprintf(fp,"Difference  variables: ");
  for (i=L; i<M; i++) fprintf(fp," %4s ",TransX[i]);
  for (i=L; i<M; i++) fprintf(fp," %4s ",TransD[i]);
  fprintf(fp,"\n");
  if (M-L >0) {
    fprintf(fp,"where ");
    for (i=L; i<M; i++) {
      fprintf(fp," %s %s - %s %s = %s, ",TransD[i],TransX[i],
	                                 TransX[i],TransD[i],
	                                 TransD[i]);
    }
    fprintf(fp,"\n\n");
  }
  fprintf(fp,"q-Difference  variables: ");
  for (i=C; i<L; i++) fprintf(fp," %4s ",TransX[i]);
  for (i=C; i<L; i++) fprintf(fp," %4s ",TransD[i]);
  fprintf(fp,"\n");
  if (L-C >0) {
    fprintf(fp,"where ");
    for (i=C; i<L; i++) {
      fprintf(fp," %s %s = %s %s %s, ",TransD[i],TransX[i],
	                               TransX[0],
	                               TransX[i],TransD[i]);
    }
    fprintf(fp,"\n\n");
  }
  fprintf(fp,"Commutative  variables: ");
  for (i=0; i<C; i++) fprintf(fp," %4s ",TransX[i]);
  for (i=0; i<C; i++) fprintf(fp," %4s ",TransD[i]);
  fprintf(fp,"\n\n");

  fprintf(fp,"Integral or summation or graduation variables are : ");
  for (i=CC; i<C; i++) fprintf(fp," %4s ",TransX[i]);
  for (i=LL; i<L; i++) fprintf(fp," %4s ",TransX[i]);
  for (i=MM; i<M; i++) fprintf(fp," %4s ",TransX[i]);
  for (i=NN; i<N; i++) fprintf(fp," %4s ",TransX[i]);
  fprintf(fp,"\n");
  fprintf(fp,"The homogenization variable is : ");
  fprintf(fp," %4s ",TransD[0]);
  fprintf(fp,"\n");



  fprintf(fp,"-------------------------------------------\n");

  fprintf(fp,"Multiplication function ----- %xH.\n",
	  (unsigned int) ringp->multiplication);

  if (level) printOrder(ringp);
  
  if (ringp->next != (struct ring *)NULL) {
    fprintf(fp,"\n\n-------- The next ring is .... --------------\n");
    showRing(level,ringp->next);
  }
}

/***************************************************************
   functions related to order
******************************************************************/
#define xtoi(k) ((N-1)-(k))
#define dtoi(k) ((2*N-1)-(k))
#define itox(k) ((N-1)-(k))
#define itod(k) ((2*N-1)-(k))
#define isX(i) (i<N? 1: 0)
#define isD(i) (i<N? 0: 1)
/****************************************************
i : 0       1         N-1       N           2N-1
x :x_{N-1} x_{N-2}   x_0  
d :                          D_{N-1}        D_{0}
if (isX(i))  x_{itox(i)}
if (isD(i))  D_{itod(i)}
******************************************************/
/* xtoi(0):N-1   xtoi(1):N-2  ....
   dtoi(0):2N-1  dtoi(1):2N-2 ...
   itod(N):N-1   dtoi(N-1):N ...
*/

void printOrder(ringp)
struct ring *ringp;
{
  int i,j;
  FILE *fp;
  char tmp[100];
  int N,M,L,C,NN,MM,LL,CC;
  char **TransX,**TransD;
  int *Order;
  int P;
  int omsize;

  N=ringp->n; M = ringp->m; L = ringp->l; C = ringp->c;
  NN=ringp->nn; MM = ringp->mm; LL = ringp->ll; CC = ringp->cc;
  TransX = ringp->x; TransD = ringp->D;
  Order = ringp->order;
  P = ringp->p;
  omsize = ringp->orderMatrixSize;

  fp = stdout;

  
  for (i=0; i<2*N; i++) printf("%4d",i);
  fprintf(fp,"\n");
  
  /* print variables names */
  for (i=0; i<N; i++) {
    sprintf(tmp,"x%d",N-1-i);
    fprintf(fp,"%4s",tmp);
  }
  for (i=0; i<N; i++) {
    sprintf(tmp,"D%d",N-1-i);
    fprintf(fp,"%4s",tmp);
  }
  fprintf(fp,"\n");

  /* print identifier names */
  for (i=0; i<N; i++) fprintf(fp,"%4s",TransX[itox(i)]);
  for (i=N; i<2*N; i++) fprintf(fp,"%4s",TransD[itod(i)]);
  fprintf(fp,"\n");

  /* print D: differential     DE: differential, shoud be eliminated
           E: difference
	   Q: q-difference
	   C: commutative
  */
  for (i=0; i<N; i++) {
    if ((NN<=itox(i)) && (itox(i)<N)) fprintf(fp,"%4s","DE");
    if ((M<=itox(i)) && (itox(i)<NN)) fprintf(fp,"%4s","D");
    if ((MM<=itox(i)) && (itox(i)<M)) fprintf(fp,"%4s","EE");
    if ((L<=itox(i)) && (itox(i)<MM)) fprintf(fp,"%4s","E");
    if ((LL<=itox(i)) && (itox(i)<L)) fprintf(fp,"%4s","QE");
    if ((C<=itox(i)) && (itox(i)<LL)) fprintf(fp,"%4s","Q");
    if ((CC<=itox(i)) && (itox(i)<C)) fprintf(fp,"%4s","CE");
    if ((0<=itox(i)) && (itox(i)<CC)) fprintf(fp,"%4s","C");
  }
  for (i=N; i<2*N; i++) {
    if ((M<=itod(i)) && (itod(i)<N)) fprintf(fp,"%4s","D");
    if ((L<=itod(i)) && (itod(i)<M)) fprintf(fp,"%4s","E");
    if ((C<=itod(i)) && (itod(i)<L)) fprintf(fp,"%4s","Q");
    if ((0<=itod(i)) && (itod(i)<C)) fprintf(fp,"%4s","C");
  }
  fprintf(fp,"\n");

  for (i=0; i< omsize; i++) {
    for (j=0; j<2*N; j++) {
      fprintf(fp,"%4d", Order[i*2*N+j]);
    }
    fprintf(fp,"\n");
  }
  fprintf(fp,"\n");

}


int mmLarger_matrix(ff,gg)
POLY ff; POLY gg;
{
  int exp[2*N0]; /* exponents */
  int i,k;
  int sum,flag;
  int *Order;
  int N;
  MONOMIAL f,g;
  struct ring *rp;
  int in2;
  int *from, *to;
  int omsize;
  
  if (ff == POLYNULL ) {
    if (gg == POLYNULL) return( 2 );
    else return( 0 );
  }
  if (gg == POLYNULL) {
    if (ff == POLYNULL) return( 2 );
    else return( 1 );
  }
  f = ff->m; g=gg->m;

  rp = f->ringp;
  Order = rp->order;
  N = rp->n;
  from = rp->from;
  to = rp->to;
  omsize = rp->orderMatrixSize;
 
  flag = 1;
  for (i=N-1,k=0; i>=0; i--,k++) {
    exp[k] = (f->e[i].x) - (g->e[i].x);
    exp[k+N] = (f->e[i].D) - (g->e[i].D);
    if ((exp[k] != 0) || (exp[k+N] != 0)) flag =0;
  }
  if (flag==1) return(2);
  /* exp > 0   <--->  f>g
     exp = 0   <--->  f=g
     exp < 0   <--->  f<g
  */
  for (i=0; i< omsize; i++) {
    sum = 0; in2 = i*2*N;
    /* for (k=0; k<2*N; k++) sum += exp[k]*Order[in2+k]; */
    for (k=from[i]; k<to[i]; k++) sum += exp[k]*Order[in2+k];
    if (sum > 0) return(1);
    if (sum < 0) return(0);
  }
  return(2);
}

/* This should be used in case of q */
int mmLarger_qmatrix(ff,gg)
POLY ff; POLY gg;
{
  int exp[2*N0]; /* exponents */
  int i,k;
  int sum,flag;
  int *Order;
  int N;
  MONOMIAL f,g;
  int omsize;
  
  if (ff == POLYNULL ) {
    if (gg == POLYNULL) return( 2 );
    else return( 0 );
  }
  if (gg == POLYNULL) {
    if (ff == POLYNULL) return( 2 );
    else return( 1 );
  }
  f = ff->m; g = gg->m;
  Order = f->ringp->order;
  N = f->ringp->n;
  omsize = f->ringp->orderMatrixSize;
  
  flag = 1;
  for (i=N-1,k=0; i>=0; i--,k++) {
    exp[k] = (f->e[i].x) - (g->e[i].x);
    exp[k+N] = (f->e[i].D) - (g->e[i].D);
    if ((exp[k] != 0) || (exp[k+N] != 0)) flag =0;
  }
  if (flag==1) return(2);
  /* exp > 0   <--->  f>g
     exp = 0   <--->  f=g
     exp < 0   <--->  f<g
  */
  for (i=0; i< omsize; i++) {
    sum = 0;
    /* In case of q, you should do as follows */
    for (k=0; k<N-1; k++) sum += exp[k]*Order[i*2*N+k]; /* skip k= N-1 -->q */
    for (k=N; k<2*N-1; k++) sum += exp[k]*Order[i*2*N+k]; /* SKip k= 2*N-1 */
    if (sum > 0) return(1);
    else if (sum < 0) return(0);
  }
  if (exp[N-1] > 0) return(1);
  else if (exp[N-1] < 0) return(0);
  else return(2);
}

/* x(N-1)>x(N-2)>....>D(N-1)>....>D(0) */
mmLarger_pureLexicographic(f,g)
POLY f;
POLY g;
{
  int i,r;
  int n;
  MONOMIAL fm,gm;
  /* Note that this function ignores the order matrix of the given
     ring. */
  if (f == POLYNULL ) {
    if (g == POLYNULL) return( 2 );
    else return( 0 );
  }
  if (g == POLYNULL) {
    if (f == POLYNULL) return( 2 );
    else return( 1 );
  }


  fm = f->m; gm = g->m;
  n = fm->ringp->n;
  for (i=n-1; i>=0; i--) {
    r = (fm->e[i].x) - (gm->e[i].x);
    if (r > 0) return(1);
    else if (r < 0) return(0);
    else ;
  }

  for (i=n-1; i>=0; i--) {
    r = (fm->e[i].D) - (gm->e[i].D);
    if (r > 0) return(1);
    else if (r < 0) return(0);
    else ;
  }

  return(2);

}


void setFromTo(ringp)
struct ring *ringp;
{
  int n;
  int i,j,oasize;
  if (ringp->order == (int *)NULL) errorOrder("setFromTo(); no order matrix.");
  n = (ringp->n)*2;
  oasize = ringp->orderMatrixSize;
  ringp->from = (int *)GC_malloc(sizeof(int)*oasize);
  ringp->to = (int *)GC_malloc(sizeof(int)*oasize);
  if (ringp->from == (int *)NULL  || ringp->to == (int *)NULL) {
    errorOrder("setFromTo(): No memory.");
  }
  for (i=0; i<oasize; i++) {
    ringp->from[i] = 0; ringp->to[i] = n;
    for (j=0; j<n; j++) {
      if (ringp->order[i*n+j] != 0) {
	ringp->from[i] = j;
	break;
      }
    }
    for (j=n-1; j>=0; j--) {
      if (ringp->order[i*n+j] != 0) {
	ringp->to[i] = j+1;
	break;
      }
    }
  }
}

static void errorOrder(s)
char *s;
{
  fprintf(stderr,"order.c: %s\n");
  exit(14);
}

