/*********** global variables for module stackmachine***************/
extern int VerboseStack;
extern int DebugStack;
extern FILE *Fstack;
extern jmp_buf EnvOfStackMachine;
extern struct object NullObject;
extern struct object NoObject;
extern int Lookup[TYPES][TYPES];


/* scanner.c */
/*struct tokens getokenSM(actionType kind,char *str);
struct tokens *decomposeToTokens(char *str,int *size);*/
struct tokens getokenSM();
struct tokens *decomposeToTokens();


/* stackmachine.c  object */
struct object *newObject(void);
struct object newObjectArray(int size);
int isNullObject(struct object obj);

/* stackmachine.c  dictionary */
int putSystemDictionary(char *str,struct object ob);
int findSystemDictionary(char *str);
int putUserDictionary(char *str,int h0,int h1,struct object ob,
		      struct dictionary *dic);
struct object findUserDictionary(char *str,int h0,int h1,
				 struct context *cp);
int putPrimitiveFuction(char *str,int number);
int hash0(char *s);
int hash1(char *s);
void hashInitialize(struct dictionary *dic);
struct tokens lookupTokens(struct tokens t);
struct object lookupLiteralString(char *s);
int putUserDictionary2(char *str,int h0,int h1,int attr,
		       struct dictionary *dic);
void KdefinePrimitiveFunctions(void);
int showSystemDictionary(void);
int showUserDictionary(void) ;


/* stackmachine.c  stack */
struct object Kpop(void); /* Kpush and Kpop may be used only in stackmachine.c
			     and primitive.c */
int Kpush(struct object ob);
struct object peek(int k);
void printOperandStack(void);
struct object newOperandStack(int size);
void setOperandStack(struct object ob);
void stdOperandStack(void);

/* stackmachine.c  printing */
void printObject(struct object ob,int nl,FILE *fp) ;
void printObjectArray(struct object ob,int nl,FILE *fp);

/* stackmachine.c  misc*/
void scanner(void);
void ctrlC(int sig);
int executeToken(struct tokens token);
int executePrimitive(struct object ob);
int isLiteral(char *str);

/* stackmachine.c  export */
int KSdefineMacros(void);
struct object KSpop(void);
void KSpush(struct object ob);
char * KSstringPop(void);

/* stackmachine.c context */
struct context *newContext0(struct context *super,char *name);
struct object KnewContext(struct object superobj, char *name);
void fprintContext(FILE *fp,struct context *c);
void KsetContext(struct object contextobj);
void contextControl(actionOfContextControl ctl);
struct object getSuperContext(struct object contextObj) ;

/* kclass.c */
int initClassDataBase();
void fprintClass(FILE *fp,struct object ob);
int KclassEqualQ(struct object ob1,struct object ob2);
struct object KcreateClassIncetance(struct object ob1,
				    struct object ob2,
				    struct object ob3);
/* ErrorStack */
int pushErrorStack(struct object obj);
struct object popErrorStack(void);
int KScheckErrorStack(void);
struct object KnewErrorPacket(char *message);

/** usage.c */
void Kusage(struct object ob);
void Kusage2(FILE *fp,char *s);

/*  list.c */
struct object *newList(struct object *op);
int klength(struct object *op);
struct object *vJoin(struct object *list1,struct object *list2);
struct object car(struct object *list);
struct object *cdr(struct object *list);
void printObjectList(struct object *op);
int memberQ(struct object *list1,struct object list2);

/* list:conversion */
struct object listToArray(struct object *op);
struct object *arrayToList(struct object ob);

/* kanExport0.c */
/** arithmetic **/
struct object KooAdd(struct object ob1, struct object ob2);
struct object KooSub(struct object ob1, struct object ob2);
struct object KooMult(struct object ob1,struct object ob2);
struct object KooDiv(struct object ob1,struct object ob2);
struct object KaoMult(struct object aa,struct object bb);
struct object KooDiv2(struct object ob1,struct object ob2);
struct object KoNegate(struct object ob1);
struct object KreduceRationalFunction(struct object ob);

/* for rational function object */
struct object KoInverse(struct object ob);
int KisInvalidRational(objectp ob);
objectp copyObjectp(objectp op);
struct object KnewRationalFunction0(objectp op1, objectp op2);
int KisZeroObject(objectp ob);
int KisOneObject(objectp ob);
int KisMinusOneObject(objectp ob);


/** relation */
struct object KoIsPositive(struct object ob);
int KooEqualQ(struct object o1,struct object o2);
struct object KooGreater(struct object o1,struct object o2);
struct object KooLess(struct object o1,struct object o2);


/** Conversion */
struct object KdataConversion(struct object ob1, char *key);
struct object KpoInteger(int i);
struct object KpoString(char *s);
struct object KpoPOLY(POLY f);
struct object KpoArrayOfPOLY(struct arrayOfPOLY *ap);
struct object KpoMatrixOfPOLY(struct matrixOfPOLY *mp);
struct object KpoRingp(struct ring *ringp);
struct object KpoDouble(double a);
#define KopInteger(o) ( (o).lc.ival )
#define KopString(o)  ( (o).lc.str )
#define KopPOLY(o)    ( (o).lc.poly )
#define KopArrayOfPOLY(o) ( *((o).lc.arrayp) )
#define KopMatrixOfPOLY(o) ( *((o).lc.matrixp))
#define KopArrayOfPOLYp(o) ( (o).lc.arrayp )
#define KopMatrixOfPOLYp(o) ( (o).lc.matrixp)
#define KopRingp(o)  ( (o).lc.ringp )
#define KopUniversalNumber(o)  ( (o).lc.universalNumber )
#define Knumerator(o)  ( (o).lc.op )
#define Kdenominator(o) ( (o).rc.op )
#define KopDouble(ob)  (*((ob).lc.dbl))
char *KPOLYToString(POLY f);
/** conversion 2 **/
struct object arrayOfPOLYToArray(struct arrayOfPOLY *aa);
struct object matrixOfPOLYToArray(struct matrixOfPOLY *pmat);
struct arrayOfPOLY *arrayToArrayOfPOLY(struct object oa);
struct matrixOfPOLY *arrayToMatrixOfPOLY(struct object oa);
double toDouble0(struct object ob);

/** :ring :kan **/
int objArrayToOrderMatrix(struct object oA,int order[],int n,int oasize);
int KsetOrderByObjArray(struct object oA);
int KsetUpRing(struct object ob1,struct object ob2, struct object ob3,struct object ob4,struct object ob5);
void KshowRing(struct ring *ringp);
void KswitchFunction(struct object ob1,struct object ob2);
void KprintSwitchStatus(void);
struct object  KoReplace(struct object ob,struct object rule);
struct object Kparts(struct object f,struct object v);
struct object Kdegree(struct object f,struct object v);
struct object KringMap(struct object ob);
struct object Ksp(struct object ob1,struct object ob2);
struct object Khead(struct object ob);
int KpolyLength(POLY f);

/* :eval */
struct object Keval(struct object obj);

/** misc **/
struct object KtoRecords(struct object ob1);
void Kclose(void);
int warningKan(char *s);
int errorKan1(char *s,char *m);
struct object test(struct object ob);
struct object Kextension(struct object ob);
struct object KgbExtension(struct object ob);
struct object KmpzExtension(struct object ob);

/** Utilities */
char *KremoveSpace(char *s);
int KtoArgvbyCurryBrace(char *str,char *argv[],int limit);


/** kanExport1.c */
/* :ring :kan */
struct object Kreduction(struct object f,struct object set);
struct object Kgroebner(struct object ob);

/* :conversion */
struct object gradedPolySetToGradedArray(struct gradedPolySet *gps,
					 int keepRedundant);
struct object polySetToArray(struct polySet *ps,int keepRedundant);
struct object gradedPolySetToArray(struct gradedPolySet *g,int keepRedundant);
struct gradedPolySet *arrayToGradedPolySet(struct object ob);
struct object syzPolyToArray(int size,POLY f,struct gradedPolySet *grG);
struct object getBackwardArray(struct gradedPolySet *grG);
POLY arrayToPOLY(struct object ob);
struct object POLYToArray(POLY f);
struct object oPrincipalPart(struct object ob);

/* :misc  */
struct object homogenizeObject(struct object ob,int *gradep);
int oGrade(struct object ob);
struct ring *oRingp(struct object ob);


/* option.c */
struct object KsystemVariable(struct object ob);

void KasirKanExecute0(char *s);

struct object KbinaryToObject(int size, char *data);
char *KobjectToBinary(struct object ob,int *size);

