#include <stdio.h>
#include <string.h>
#include <netinet/in.h>
#include "datatype.h"
#include "stackm.h"
#include "extern.h"
#include "extern2.h"
#include "kclass.h"

#include "gmp.h"
#include "gmp-impl.h"

#include "cmo.h"
/* From gmp/mpz/out_raw.c and inp_raw.c */

/* mpz_out_raw -- Output a mpz_t in binary.  Use an endianess and word size
   independent format.

Copyright (C) 1995 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
License for more details.

You should have received a copy of the GNU Library General Public License
along with the GNU MP Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

static int myfputc(int i) {
  char tmp[1];
  tmp[0] = i;
  cmoOutputToBuf(CMOPUT,tmp,1);
}

size_t
cmoOutGMPCoeff(mpz_srcptr x)
{
  int i;
  mp_size_t s;
  mp_size_t xsize = ABS (x->_mp_size);
  mp_srcptr xp = x->_mp_d;
  mp_size_t out_bytesize;
  mp_limb_t hi_limb;
  int n_bytes_in_hi_limb;
  cmoint tmp[1];
  tmp[0] = htonl(CMO_GMPCOEFF);
  cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint));
  
  if (xsize == 0)
    {
      for (i = 4 - 1; i >= 0; i--)
	myfputc (0);
      return  4;
    }

  hi_limb = xp[xsize - 1];
  for (i = BYTES_PER_MP_LIMB - 1; i > 0; i--)
    {
      if ((hi_limb >> i * BITS_PER_CHAR) != 0)
	break;
    }
  n_bytes_in_hi_limb = i + 1;
  out_bytesize = BYTES_PER_MP_LIMB * (xsize - 1) + n_bytes_in_hi_limb;
  if (x->_mp_size < 0)
    out_bytesize = -out_bytesize;

  /* Make the size 4 bytes on all machines, to make the format portable.  */
  for (i = 4 - 1; i >= 0; i--)
    myfputc ((out_bytesize >> (i * BITS_PER_CHAR)) % (1 << BITS_PER_CHAR));

  /* Output from the most significant limb to the least significant limb,
     with each limb also output in decreasing significance order.  */

  /* Output the most significant limb separately, since we will only
     output some of its bytes.  */
  for (i = n_bytes_in_hi_limb - 1; i >= 0; i--)
    myfputc ((hi_limb >> (i * BITS_PER_CHAR)) % (1 << BITS_PER_CHAR));

  /* Output the remaining limbs.  */
  for (s = xsize - 2; s >= 0; s--)
    {
      mp_limb_t x_limb;

      x_limb = xp[s];
      for (i = BYTES_PER_MP_LIMB - 1; i >= 0; i--)
	myfputc ((x_limb >> (i * BITS_PER_CHAR)) % (1 << BITS_PER_CHAR));
    }
  return ( ABS (out_bytesize) + 4);
}


/* mpz_inp_raw -- Input a mpz_t in raw, but endianess, and wordsize
   independent format (as output by mpz_out_raw).

Copyright (C) 1991, 1993, 1994, 1995 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
License for more details.

You should have received a copy of the GNU Library General Public License
along with the GNU MP Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */


static int myfgetc(struct cmoBuffer *cb)
{ int k;
  k = ((unsigned char *)(cb->buf))[cb->rpos];
  cb->rpos++;
  if (cb->rpos > cb->pos) {
    cb->rpos--;
    errorCmo("myfgetc(): no data in the buffer.");
  }
  return(k);
}

cmoGetGMPCoeff(MP_INT *x, struct cmoBuffer *cb)
{
  int i;
  mp_size_t s;
  mp_size_t xsize;
  mp_ptr xp;
  unsigned int c;
  mp_limb_t x_limb;
  mp_size_t in_bytesize;
  int neg_flag;

  /* Read 4-byte size */
  in_bytesize = 0;
  for (i = 4 - 1; i >= 0; i--)
    {
      c = myfgetc (cb);
      in_bytesize = (in_bytesize << BITS_PER_CHAR) | c;
    }

  /* Size is stored as a 32 bit word; sign extend in_bytesize for non-32 bit
     machines.  */
  if (sizeof (mp_size_t) > 4)
    in_bytesize |= (-(in_bytesize < 0)) << 31;

  neg_flag = in_bytesize < 0;
  in_bytesize = ABS (in_bytesize);
  xsize = (in_bytesize + BYTES_PER_MP_LIMB - 1) / BYTES_PER_MP_LIMB;

  if (xsize == 0)
    {
      x->_mp_size = 0;
      return 4;			/* we've read 4 bytes */
    }

  if (x->_mp_alloc < xsize)
    _mpz_realloc (x, xsize);
  xp = x->_mp_d;

  x_limb = 0;
  for (i = (in_bytesize - 1) % BYTES_PER_MP_LIMB; i >= 0; i--)
    {
      c = myfgetc (cb);
      x_limb = (x_limb << BITS_PER_CHAR) | c;
    }
  xp[xsize - 1] = x_limb;

  for (s = xsize - 2; s >= 0; s--)
    {
      x_limb = 0;
      for (i = BYTES_PER_MP_LIMB - 1; i >= 0; i--)
	{
	  c = myfgetc (cb);
	  x_limb = (x_limb << BITS_PER_CHAR) | c;
	}
      xp[s] = x_limb;
    }

  if (c == EOF)
    return 0;			/* error */

  MPN_NORMALIZE (xp, xsize);
  x->_mp_size = neg_flag ? -xsize : xsize;
  return in_bytesize + 4;
}
