#include <stdio.h>
#include <string.h>
#include <netinet/in.h>
#include "datatype.h"
#include "stackm.h"
#include "extern.h"
#include "extern2.h"
#include "kclass.h"


#include "cmo.h"
/* void *malloc(int s);
  #define GC_malloc(x) malloc(x) */

extern struct ring *CurrentRingp;

#define BUFFERSIZE  1024
struct cmoBuffer *cmoOutputToBuf(cmoAction a,void *data, int size)
{
  static struct cmoBuffer b;
  static int bufferIsInitialized = 0;
  void *tmp;
  struct cmoBuffer *cb;
  int i;
  if (!bufferIsInitialized) {
    bufferIsInitialized = 1;
    b.size = BUFFERSIZE;
    b.pos = 0;
    b.rpos = 0;
    b.buf = GC_malloc(BUFFERSIZE);
  }
  switch(a) {
  case CMOINIT:
    b.pos = 0;
    break;
  case CMOPUT:
    if (b.pos + size >= b.size) {
      tmp = GC_malloc((b.size)*2+size);
      memcpy(tmp,b.buf,b.pos);
      b.buf = tmp;
      b.size = (b.size)*2+size;
    }
    memcpy((void *) &(((char *)(b.buf))[b.pos]),data,size);
    b.pos += size;
    break;
  case CMOFLUSH:
    cb = (struct cmoBuffer *)GC_malloc(sizeof(struct cmoBuffer));
    cb->size = b.pos;
    cb->pos = b.pos;
    cb->buf = GC_malloc((b.pos<=0?1:b.pos));
    memcpy(cb->buf,b.buf,b.pos);
    return(cb);
    break;
  default:
    break;
  }
  return(NULL);
}

dumpCmoBuf(struct cmoBuffer *cb)
{
  int i,size;
  char *s;
  size = cb->pos;
  printf("dumpCmoBuf : size = %d, size/sizeof(int) = %d\n",size,size/sizeof(int));
  s = (char *)(cb->buf);
  for (i=0; i<size; i++) {
    if (i % 20 == 0) putchar('\n');
    printf("%3x",(int)(unsigned char)s[i]);
  }
  putchar('\n');
}

/* unsigned short int must be 32 bits */
cmoOutInt32Coeff(int k)
{
  cmoint tmp[2];
  tmp[0] = htonl((cmoint) CMO_INT32COEFF);
  tmp[1] = htonl((cmoint ) k);
  cmoOutputToBuf(CMOPUT,tmp,2*sizeof(cmoint));
}

int cmoOutMonomial32(POLY cell)
{
  cmoint tmp[2+N0*2];
  int i,nn,tt;
  if (cell == POLYNULL) {
    tmp[0] = htonl(CMO_ZEROMONOMIAL);
    cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint));
    return(0);
  }
  tmp[0] = htonl(CMO_MONOMIAL32);
  nn = cell->m->ringp->n;
  tmp[1] = htonl(nn*2);
  for (i=0; i<nn; i++) {
    tmp[2+i] = htonl(cell->m->e[i].x);
    tmp[2+nn+i] = htonl(cell->m->e[i].D);
  }
  cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint)*(2+2*nn));
  switch(cell->coeffp->tag) {
  case INTEGER:
    cmoOutInt32Coeff(cell->coeffp->val.i);
    return(0);
    break;
  case MP_INTEGER:
    /* errorCmo("Not implemented."); */
    cmoOutGMPCoeff(cell->coeffp->val.bigp);
    return(0); 
    break;
  default:
    errorCmo("cmoOutMonomial32(): unknown coefficient tag.");
    return(-1);
    break;
  }
}
    
int cmoOutAdd() 
{
  cmoint tmp[1];
  tmp[0] = htonl(CMO_ADD);
  cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint));
  return(0);
}

int cmoOutPolynomial(POLY f) 
{
  int size;
  cmoint tmp[2];
  if (f == POLYNULL) {
    return(cmoOutMonomial32(f));
  }
  size = pLength(f);
  tmp[0] = htonl(CMO_LIST);
  tmp[1] = htonl(size+1);
  cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint)*2);
  cmoOutAdd();
  while (f != POLYNULL) {
    cmoOutMonomial32(f);
    f = f->next;
  }
  return(0);
}

/* ------------------------------ */
int cmoGetIntFromBuf(cmoAction a,struct cmoBuffer *cb)
{
  cmoint tmp[1];
  switch(a) {
  case CMOGET:
    if (cb->rpos + sizeof(cmoint) > cb->pos) {
      fprintf(stderr,"No more data in the buffer. Returns 0.\n");
      return(0);
    }
    memcpy(tmp,(void *) &(((char *)(cb->buf))[cb->rpos]),
	   sizeof(cmoint));
    cb->rpos += sizeof(cmoint);
    return( (int) ntohl(tmp[0]));
    break;
  case CMOINIT:
    cb->rpos = 0;
    break;
  }
  return(0);
}


/* ------------------------------------- */
/* This function is called after reading the tag CMO_INT32COEFF */
struct coeff * cmoGetInt32Coeff(struct cmoBuffer *cb)
{
  struct coeff *c;
  c = intToCoeff(cmoGetIntFromBuf(CMOGET,cb),CurrentRingp);
  return(c);
}
POLY cmoGetMonomial32(struct cmoBuffer *cb)
{
  int nn,i,tt;
  struct coeff *c;
  struct monomial *m;
  MP_INT *mi;
  nn = cmoGetIntFromBuf(CMOGET,cb);
  if (nn != (CurrentRingp->n)*2 ) {
    errorCmo("cmoGetMonomial32(): serialized polynomial \\not\\in CurrentRing.");
  }
  m = newMonomial(CurrentRingp);
  for (i=0; i<nn/2; i++) {
    m->e[i].x = cmoGetIntFromBuf(CMOGET,cb);
  }
  for (i=0; i<nn/2; i++) {
    m->e[i].D = cmoGetIntFromBuf(CMOGET,cb);
  }
  tt = cmoGetIntFromBuf(CMOGET,cb);
  switch(tt) {
  case CMO_INT32COEFF:
    c = cmoGetInt32Coeff(cb);
    break;
  case CMO_GMPCOEFF:
    mi = newMP_INT();
    cmoGetGMPCoeff(mi, cb);
    c = mpintToCoeff(mi,CurrentRingp);
    /* errorCmo("Not implemented."); */
    break;
  default:
    errorCmo("cmoGetMonomial32(): coeff type that is not implemented.");
    break;
  }
  return(newCell(c,m));
}



/* ------------------------------------- */
void cmoObjectToCmo00(struct object ob)
{
  struct object rob;
  cmoint tmp[2];
  int i,size;
  /* NO initialization */
  switch(ob.tag) {
  case Sinteger:
    /* fprintf(stderr,"For test.\n"); */
    cmoOutInt32Coeff(ob.lc.ival); 
    break;
  case Spoly:
    cmoOutPolynomial(KopPOLY(ob));
    break;
  case Sarray:
    tmp[0] = htonl(CMO_LIST);
    tmp[1] = htonl(size=getoaSize(ob));
    cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint)*2);
    for (i=0; i<size; i++) {
      cmoObjectToCmo00(getoa(ob,i));
    }
    break;
  default:
    errorCmo("cmoObjectToCmo(): unknown tag.");
    break;
  }
  /* no flush */
}

struct object cmoObjectToCmo(struct object ob)
{
  struct object rob;
  cmoOutputToBuf(CMOINIT,NULL,0);
  cmoObjectToCmo00(ob);
  rob.tag = CMO;
  rob.lc.voidp = cmoOutputToBuf(CMOFLUSH,NULL,0);
  return(rob);
}
void cmoDumpCmo(struct object ob)
{
  if (ob.tag == CMO) {
    dumpCmoBuf((struct cmoBuffer *) ob.lc.voidp);
  }else {
    errorCmo("cmoDUmpCmo(): Object is not CMO.");
  }
}

struct object cmoCmoToObject00(struct cmoBuffer *cb)
{
  struct object rob;
  int tt,ival;
  int i,size;
  tt = cmoGetIntFromBuf(CMOGET,cb); /* read the tag */
  switch (tt) {
  case CMO_INT32COEFF:
    /* For test. */
    ival = cmoGetIntFromBuf(CMOGET,cb);
    rob = KpoInteger(ival);
    break;
  case CMO_LIST:
    size = cmoGetIntFromBuf(CMOGET,cb);
    if (size < 0) errorCmo("cmoCmoToObject00(): size of array is negative.");
    rob = newObjectArray(size);
    /* printf("size=%d\n",size); */
    for (i=0; i<size; i++) {
      putoa(rob,i,cmoCmoToObject00(cb));
      /* printObject(getoa(rob,i),0,stdout); */
    }
    break;
  case CMO_ADD:
    rob.tag = CMO+CMO_ADD;  /* OK?? */
    break;
  case CMO_MONOMIAL32:
    rob = KpoPOLY(cmoGetMonomial32(cb));
    break;
  case CMO_ZEROMONOMIAL:
    rob = KpoPOLY(POLYNULL);
    break;
  defaut:
    errorCmo("cmoCmoToObject00(): unknown CMO tag.");
    break;
  }
  return(rob);
}
    
struct object cmoCmoToObject(struct object ob)
{
  struct object rob;
  struct object ob0;
  struct cmoBuffer *cb;
  if (ob.tag != CMO) {
    rob.tag = Snull;
    errorCmo("cmoCmoToObject(): the argument is not CMO.");
    return(rob);
  }
  cb = (struct cmoBuffer *) ob.lc.voidp;
  cmoGetIntFromBuf(CMOINIT,cb);
  if (cb->pos == 0) {
    /* null */
    rob.tag = Snull;
    return(rob);
  }
  rob = cmoCmoToObject00(cb);
  if (rob.tag == Sarray) {
    if (getoaSize(rob) >= 1) {
      ob0 = getoa(rob,0);
      if (ob0.tag == CMO+CMO_ADD) {
	rob = KpoPOLY(cmoListToPOLY(rob));
      }
    }
  }
  return(rob);
}

/*
main() {
 int i;
 struct cmoBuffer *cb;
 printf("%d\n",sizeof(long int));
 for (i=0; i<300; i++) {
   cmoOutInt32Coeff(i);
 }
 dumpCmoBuf(cb=cmoOutputToBuf(CMOFLUSH,NULL,0));
 cmoGetIntFromBuf(CMOINIT,cb);
 for (i=0; i<300; i++) {
   printf("%5d",cmoGetIntFromBuf(CMOGET,cb));
 }
 putchar('\n');
}
*/

POLY cmoListToPOLY(struct object ob) 
{
  int size,i;
  struct object ob0,ob1;
  POLY f;
  /*
     printf("<<");printObject(ob,0,stdout); printf(">>\n"); fflush(stdout);
     */
  if (ob.tag != Sarray) {
    errorCmo("cmoListToPoly(): the argument must be array.");
  }
  size = getoaSize(ob);
  if (size < 1) {
    errorCmo("cmoListToPoly(): the first element of the array must be CMO-tag.");
  }
  ob0 = getoa(ob,0);
  switch(ob0.tag) {
  case (CMO+CMO_ADD):
    f = POLYNULL;
    for (i=size-1; i>=1; i--) {
      ob1 = getoa(ob,i);
      if (ob1.tag == Spoly) {
	f = ppAdd(f,KopPOLY(ob1));
      }else{
	f = ppAdd(f,cmoListToPOLY(ob1));
      }
    }
    return(f);
    break;
  default:
    errorCmo("cmoListToPoly(): unknown tag.");
    break;
  }
}


int Kan_PushBinary(int size,void *data)
{
  struct cmoBuffer cb;
  struct object ob;
  cb.pos = size;
  cb.rpos = 0;
  cb.buf = data;
  cb.size = size;
  ob.tag = CMO;
  ob.lc.voidp = &cb;
  KSpush(cmoCmoToObject(ob));
  return(0);
}

void *Kan_PopBinary(int *sizep)
{
  struct object ob;
  struct cmoBuffer *cb;
  ob = KSpop();
  ob = cmoObjectToCmo(ob);
  if (ob.tag == CMO) {
    cb = (struct cmoBuffer *) (ob.lc.voidp);
    *sizep = cb->pos;
    return(cb->buf);
  }
  return(NULL);
}


errorCmo(char *s) {
  fprintf(stderr,"plugin/cmo.c : %s\n",s);
  KSexecuteString(" error ");
}



