
/* kclass.c,  1997, 3/1
   This module handles class data base.
*/
#include <stdio.h>
#include "datatype.h"
#include "stackm.h"
#include "extern.h"
#include "gradedset.h"
#include "extern2.h"
#include "kclass.h"

#define CLASSTABLE_SIZE 1024


struct object * ClassDictionaries[CLASSTABLE_SIZE];
char *ClassNames[CLASSTABLE_SIZE];
int ClassTypes[CLASSTABLE_SIZE];

initClassDataBase() {
  int i;
  for (i=0; i<CLASSTABLE_SIZE; i++) {
    ClassTypes[i] = CLASS_NOT_USED;
  }
  /* Initialize CLASS_INTERNAL */
  ClassTypes[CLASSNAME_OPERANDSTACK] = CLASS_INTERNAL;
  ClassNames[CLASSNAME_OPERANDSTACK] = "Class.OperandStack";
  ClassDictionaries[CLASSNAME_OPERANDSTACK] = (struct object *)NULL;
                           /* We have to creat new dictionary in a future. */

  ClassTypes[CLASSNAME_ERROR_PACKET] = CLASS_OBJ;
  ClassNames[CLASSNAME_ERROR_PACKET] = "Class.ErrorPacket";
  ClassDictionaries[CLASSNAME_ERROR_PACKET] = (struct object *)NULL;
                           /* We have to creat new dictionary in a future. */

  ClassTypes[CLASSNAME_CONTEXT] = CLASS_INTERNAL;
  ClassNames[CLASSNAME_CONTEXT] = "Class.Context";
  ClassDictionaries[CLASSNAME_CONTEXT] = (struct object *)NULL;
                           /* We have to creat new dictionary in a future. */

  ClassTypes[CLASSNAME_GradedPolySet] = CLASS_INTERNAL;
  ClassNames[CLASSNAME_GradedPolySet] = "Class.GradedPolySet";
  ClassDictionaries[CLASSNAME_GradedPolySet] = (struct object *)NULL;
                           /* We have to creat new dictionary in a future. */

}


void fprintClass(FILE *fp,struct object obj) {
  int tag;
  tag = ectag(obj);
  if (tag == -1) {
    return ;
  }
  if (ClassTypes[tag] != CLASS_NOT_USED) {
    fprintf(fp,"%s",ClassNames[tag]);
  }
  switch(tag) {
  case CLASSNAME_OPERANDSTACK:
    break;
  case CLASSNAME_ERROR_PACKET:
    fprintErrorPacket(fp,KopErrorPacket(obj));
    break;
  case CLASSNAME_CONTEXT:
    fprintContext(fp,KopContext(obj));
    break;
  case CLASSNAME_GradedPolySet:
    outputGradedPolySet(KopGradedPolySet(obj),0);
    break;
  default:
    fprintf(fp,"Unknown class tag.\n");
    break;
  }
}

int KclassEqualQ(struct object ob1,struct object ob2) {
  if (ectag(ob1) != ectag(ob2)) return(0);
  switch(ectag(ob1)) {
  case CLASSNAME_OPERANDSTACK:
  case CLASSNAME_CONTEXT:
    if (ecbody(ob1) == ecbody(ob2)) return(1);
    else return(0);
    break;
  default:
    errorKan1("%s\n","kclass.c (KclassEqualQ cannot compare these objects.)");
    break;
  }
}

void fprintErrorPacket(FILE *fp,struct object *op)
{
  printObject(*op,0,fp);
}



