/* ox_kan0.h */

#define mymalloc(n) malloc(n)
#define myfree(p) free(p)
typedef FILE2 *  ox_stream;

int socketOpen(char *serverName,int portNumber);
int socketAccept(int snum);
int oxSocketSelect0(int fd,int t);
int oxSocketMultiSelect(int sid[],int size,int t,int result[]);
int socketConnect(char *serverName,int portNumber);


/* ------------------------------------- */
extern FILE *MyErrorOut;

typedef struct CMO_Object {
  int tag;
  char data[1];
} CMO_Object ;

typedef struct CMO_string_object {
  int tag;
  int size;
  char data[1];
} CMO_string_object;

typedef struct CMO_int32_object {
  int tag;
  int n;
} CMO_int32_object ;

void printCMO_object(FILE *fp,CMO_Object *op);

/* --------------------------------------- */
#define DSTATE_ERROR -1
#define DSTATE_ANY  0
#define DSTATE_FIRST_SYNC 1
#define DSTATE_SECOND_SYNC 2
#define DSTATE_WAIT_OX_DATA 256

typedef  struct oxclient {
  ox_stream datafp2;
  int dataport;
  int controlfd;
  int controlport;
  int dstate;    /* state of data channel */
     /*  0 : any 
         1 : waiting the first OX_SYNC_BALL
	 2 : waiting the second OX_SYNC_BALL
        256: waiting the OX_DATA to stack.
     */
  int cstate;    /* state of control channel */
     /*  0 : any
	 1 : waiting resultOfControlInt32
     */
  int humanio;   /* 1: stdin,  0: not */
  int type;      /* 0: CLIENT_SOCKET socket, 1: CLIENT_FILE file */
  int id;  /* client identifier. */
} oxclient;
#define N_OF_CLIENT_FIELDS  10
typedef oxclient * oxclientp;

#define CLIENT_SOCKET 0
#define CLIENT_FILE   1

int oxGetResultOfControlInt32(int fd);
int oxclientMultiSelect(oxclientp clients[],int dataready[],int controlready[],
			int size, int t);
int oxInitClient(oxclientp c);
int oxGetControl(oxclientp client);
int oxIsThereErrorClient(oxclientp client);  /* 1 : error, 0 : OK. */
oxclientp oxCreateClient(char *ipname,int portStream,int portControl);
oxclientp oxCreateClientFile(char *fileName,char *mode,char *controlFileName,char *cmode);


/* -------------------------------------- */
int readOneByte(int fd);   /* blocking */
int oxfdGetInt32(int fd);
int oxGetInt32(ox_stream ostream);
int oxGetCMOInt32(ox_stream ostream);
char *oxGetCMOString(ox_stream ostream);

void oxfdSendInt32(int fd,int k);
void oxfdSendCmoNull(int fd);
void oxfdSendCmoInt32(int fd,int k);
void oxfdSendCmoString(int fd,char *s);
void oxfdSendSyncBall(int fd);

void oxSendInt32(ox_stream ostream,int k);
void oxSendCmoNull(ox_stream ostream);
void oxSendCmoError(ox_stream ostream);
void oxSendCmoError2(ox_stream ostream,char *s);
void oxSendCmoInt32(ox_stream ostream,int k);
void oxSendCmoString(ox_stream,char *s);

void oxSendSyncBall(ox_stream ostream);
int  oxWaitSyncBall(ox_stream ostream);

void oxSendResultOfControl(int fd);
void oxSendResultOfControlInt32(int fd, int k);


void oxReqMathCap(ox_stream os);
void oxReqPops(ox_stream os,int n);
void oxReqSetName(ox_stream os,char *name);
void oxReqEvalName(ox_stream os,char *name);
void oxReqExecuteStringByLocalParser(ox_stream os,char *s);
void oxReqExecuteFunction(ox_stream os,char *s);
void oxReqPopString(ox_stream os);
void oxReqPushString(ox_stream os,char *s);
void oxReqPopCMO(ox_stream os);

void oxReqControlResetConnection(int fd);
void oxReqControlKill(int fd);


