#include <stdio.h>
#include <string.h>
#include <netinet/in.h>
#include "datatype.h"
#include "stackm.h"
#include "extern.h"
#include "extern2.h"
#include "kclass.h"


#include "file2.h"
#include "cmo.h"
/* void *malloc(int s);
  #define GC_malloc(x) malloc(x) */

extern struct ring *CurrentRingp;
extern struct ring *SmallRingp;
extern int CmoDMSOutputOption;

struct object NullObjectInCmo;

extern int SerialCurrent;

#define BUFFERSIZE  1024
struct cmoBuffer *cmoOutputToBuf(cmoAction a,void *data, int size)
{
  static struct cmoBuffer b;
  static int bufferIsInitialized = 0;
  void *tmp;
  struct cmoBuffer *cb;
  int i;
  if (!bufferIsInitialized) {
    NullObjectInCmo.tag = Snull;
    bufferIsInitialized = 1;
    b.size = BUFFERSIZE;
    b.pos = 0;
    b.rpos = 0;
    b.isStream = 0;
    b.fp = (FILE2 *)NULL;
    b.buf = GC_malloc(BUFFERSIZE);
    if (b.buf == NULL) errorCmo("cmoOutputToBuf: no memory.");
  }
  if (b.isStream) {
    switch(a) {
    case CMOINIT:
      b.pos = 0;
      b.rpos = 0;  /* added, 1997, 12/5 */
      b.isStream = 0;
      b.fp = (FILE2 *)data ;
      b.errorno = 0;
      break;
    case CMOINITSTREAM:
      b.pos = 0;
      b.isStream = 1;
      b.rpos = 0;  /* added, 1997, 12/5 */
      b.fp = (FILE2 *)data;
      b.errorno = 0;
      break;
    case CMOPUT:
      for (i=0; i<size; i++) {
	fp2fputc(((char *)data)[i], b.fp);
      }
      break;
    case CMOFLUSH:
      if (fp2fflush(b.fp)<0) {
	errorCmo("cmoOutputToBuf: CMOFLUSH failed in stream mode.");
      }
      cb = (struct cmoBuffer *)GC_malloc(sizeof(struct cmoBuffer));
      cb->isStream = b.isStream;
      cb->size = b.pos;
      cb->pos = b.pos;
      cb->buf = NULL;
      return(cb);
      break;
    case CMOERROR:
      b.errorno = size;
      break;
    default:
      errorCmo("Unknown action.");
      break;
    }
    return(NULL);
  }else{
    switch(a) {
    case CMOINIT:
      b.pos = 0;
      b.rpos = 0;  /* added, 1997, 12/5 */
      b.isStream = 0;
      b.errorno = 0;
      break;
    case CMOINITSTREAM:
      b.pos = 0;
      b.isStream = 1;
      b.rpos = 0;  /* added, 1997, 12/5 */
      b.fp = (FILE2 *)data;
      b.errorno = 0;
      break;
    case CMOPUT:
      if (b.pos + size >= b.size) {
	tmp = GC_malloc((b.size)*2+size);
	memcpy(tmp,b.buf,b.pos);
	b.buf = tmp;
	b.size = (b.size)*2+size;
      }
      memcpy((void *) &(((char *)(b.buf))[b.pos]),data,size);
      b.pos += size;
      break;
    case CMOFLUSH:
      cb = (struct cmoBuffer *)GC_malloc(sizeof(struct cmoBuffer));
      cb->isStream = b.isStream;
      cb->size = b.pos;
      cb->pos = b.pos;
      cb->buf = GC_malloc((b.pos<=0?1:b.pos));
      memcpy(cb->buf,b.buf,b.pos);
      return(cb);
      break;
    case CMOERROR:
      b.errorno = size;
      break;
    default:
      errorCmo("Unknown action.");
      break;
    }
    return(NULL);
  }
}

dumpCmoBuf(struct cmoBuffer *cb)
{
  int i,size;
  char *s;
  if (cb->isStream) {
    printf("cmoBuffer is directed to a stream.\n");
    return;
  }
  size = cb->pos;
  printf("dumpCmoBuf : size = %d, size/sizeof(int) = %d\n",size,size/sizeof(int));
  s = (char *)(cb->buf);
  for (i=0; i<size; i++) {
    if (i % 20 == 0) putchar('\n');
    printf("%3x",(int)(unsigned char)s[i]);
  }
  putchar('\n');
}

/* This obsolete function is used to write data
   in cmoBuffer (cmo object in kan)
   to a stream */
cmoToStream(struct object cmoObj,struct object of)
{
  int i,size;
  struct cmoBuffer *cb;
  char *s;
  int file2=0;
  if (cmoObj.tag != CMO) {
    errorCmo("cmoToStream: the first argument is not cmoObject.");
  }
  if (of.tag != Sfile) {
    errorCmo("cmoToStream: the second argument is not file object.");
  }
  if (strcmp(of.lc.str,MAGIC2) == 0) {
    file2 = 1;
  }
  cb = cmoObj.lc.voidp;
  size = cb->pos;
  s = (char *)(cb->buf);
  for (i=0; i<size; i++) {
    if (file2) {
      fp2fputc(s[i],(FILE2 *)(of.rc.voidp));
    }else{
      fputc(s[i],of.rc.file);
    }
  }
}
/* This obsolete function is used to store data from the stream
   to cmoBuffer in the raw form. (cmo object in kan).
   cf. cmoObjectFromStream, cmoObjectToStream: these function 
       directly transmit objects of kan to a stream in CMO format.
*/
struct object streamToCmo(struct object of)
{
  int c;
  unsigned char s[1];
  struct object ob;
  int file2 = 0;
  if (of.tag == Sfile) {

  }else{
    errorCmo("streamToCmo: no file is opened.");
  }
  if (strcmp(of.lc.str,MAGIC2) == 0) {
    file2 = 1;
  }
  cmoOutputToBuf(CMOINIT,NULL,0);
  /* Raw reading to the buffer from file. No cmoOutHeader(). */
  if (file2) {
    while ((c=fp2fgetc((FILE2 *)of.rc.voidp)) != EOF) {
      s[0] = c;
      cmoOutputToBuf(CMOPUT,s,1);
    }
  }else{
    while ((c=fgetc(of.rc.file)) != EOF) {
      s[0] = c;
      cmoOutputToBuf(CMOPUT,s,1);
    }
  }
  /* Raw reading to the buffer from file. No cmoOutTail(). */
  ob.tag = CMO;
  ob.lc.voidp = cmoOutputToBuf(CMOFLUSH,NULL,0);
  return(ob);
}


cmoOutCmoNull() {
  cmoint tmp[1];
  tmp[0] = htonl((cmoint) CMO_NULL);
  cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint));
}

  


/* unsigned short int must be 32 bits */
cmoOutInt32(int k)
{
  cmoint tmp[2];
  tmp[0] = htonl((cmoint) CMO_INT32);
  tmp[1] = htonl((cmoint ) k);
  cmoOutputToBuf(CMOPUT,tmp,2*sizeof(cmoint));
}

cmoOutString(char *d,int size) {
  cmoint tmp[2];
  tmp[0] = htonl((cmoint) CMO_STRING);
  tmp[1] = htonl((cmoint ) size);
  cmoOutputToBuf(CMOPUT,tmp,2*sizeof(cmoint));
  cmoOutputToBuf(CMOPUT,d,size);
}


int cmoOutMonomial32(POLY cell)
{
  cmoint tmp[3+N0*2];
  extern int ReverseOutputOrder;
  int i,nn,tt;
  if (cell == POLYNULL) {
    tmp[0] = htonl(CMO_ZERO);
    cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint));
    return(0);
  }
  tmp[0] = htonl(CMO_MONOMIAL32);
  nn = cell->m->ringp->n;
  tmp[1] = htonl(nn*2);
  if (ReverseOutputOrder) {
    for (i=0; i<nn; i++) {
      tmp[2+i] = htonl(cell->m->e[nn-i-1].x);
      tmp[2+nn+i] = htonl(cell->m->e[nn-i-1].D);
    }
  }else{
    for (i=0; i<nn; i++) {
      tmp[2+i] = htonl(cell->m->e[i].x);
      tmp[2+nn+i] = htonl(cell->m->e[i].D);
    }
  }
  cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint)*(2+2*nn));
  switch(cell->coeffp->tag) {
  case INTEGER:
    cmoOutInt32(cell->coeffp->val.i);
    return(0);
    break;
  case MP_INTEGER:
    /* errorCmo("Not implemented."); */
    cmoOutGMPCoeff(cell->coeffp->val.bigp);
    return(0); 
    break;
  default:
    cmoOutputToBuf(CMOERROR,NULL,-1); /* fatal, need reset_connection */
    errorCmo("cmoOutMonomial32(): unknown coefficient tag.");
    return(-1);
    break;
  }
}
    
int cmoOutDMS() 
{
  cmoint tmp[1];
  tmp[0] = htonl(CMO_DMS);
  cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint));
  return(0);
}

int cmoOutPolynomial(POLY f) 
{
  int size;
  cmoint tmp[2];
  if (f == POLYNULL) {
    return(cmoOutMonomial32(f));
  }
  size = pLength(f);
  tmp[0] = htonl(CMO_LIST);
  tmp[1] = htonl(size+2);
  cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint)*2);
  cmoOutDMS();
  cmoOutRingDefinition(f->m->ringp,CmoDMSOutputOption);
  while (f != POLYNULL) {
    cmoOutMonomial32(f);
    f = f->next;
  }
  return(0);
}

int cmoOutRingDefinition(struct ring *rp,int option)
{
  cmoint tmp[3];
  /* minimal information */
  switch(option) {
  case 1: /* RING_BY_NAME */
    cmoOutRawInt(CMO_RING_BY_NAME);
    cmoOutString(rp->name,strlen(rp->name));
    break;
  case 2: 
    tmp[0] = htonl(CMO_DMS_OF_N_VARIABLES);
    tmp[1] = htonl(CMO_LIST);
    tmp[2] = htonl(2);
    cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint)*3);
    cmoOutInt32((rp->n)*2); /* number of variables */
    cmoOutInt32(rp->p);     /* coefficient field.
			       CMO_INT32 or CMO_DMS_OF_N_VARIABLES */
    /* Optional arguments are  name of variables, weight_vector, output_order */
    break;
  default:   /* including 0. */
    cmoOutInt32(CMO_DMS_GENERIC);
    break;
  }
  
}

/* ------------------------------ */
int cmoGetIntFromBuf(cmoAction a,struct cmoBuffer *cb)
{
  cmoint tmp[1];
  char data[4];
  int i;
  int cc;
  if (cb->isStream) {
    switch(a) {
    case CMOGET:
      for (i=0; i<4; i++) {
	cc = fp2fgetc(cb->fp);
	if (cc < 0) {
	  return(-1);
	  errorCmo("cmoGetIntFromBuf CMOGET: unexpected EOF.\n");
	}
	data[i] = cc;
      }
      return( (int) ntohl( *((cmoint *) data) ));
      break;
    case CMOGETBYTE:
      cc = fp2fgetc(cb->fp);
      if (cc < 0) {
	return(-1);
	errorCmo("cmoGetIntFromBuf CMOGETBYTE: unexpected EOF.\n");
      }
      return(cc);
      break;
    case CMOINIT:
      fprintf(stderr,"Invalid action CMOINIT for cmoBuffer in the stream mode.\n");
      cb->rpos = 0;
      cb->errorno = 0;
      break;
    case CMOINITSTREAM:
      cb->errorno = 0;
      break;
    case CMOERROR:
      cb->errorno = 1;
      break;
    case CMOERROR2:
      cb->errorno = -1;
      break;
    }
    return(0);
  }else{
    switch(a) {
    case CMOGET:
      if (cb->rpos + sizeof(cmoint) > cb->pos) {
	fprintf(stderr,"No more data in the buffer. Returns -1.\n");
	return(-1);
      }
      memcpy(tmp,(void *) &(((char *)(cb->buf))[cb->rpos]),
	     sizeof(cmoint));
      cb->rpos += sizeof(cmoint);
      return( (int) ntohl(tmp[0]));
      break;
    case CMOGETBYTE:
      if (cb->rpos + 1 > cb->pos) {
	fprintf(stderr,"No more data in the buffer. Returns -1.\n");
	return(-1);
      }
      tmp[0] = ((unsigned char *)(cb->buf))[cb->rpos];
      cb->rpos += 1;
      return( (int) tmp[0]);
      break;
    case CMOINIT:
      cb->rpos = 0;
      cb->errorno = 0;
      break;
    case CMOINITSTREAM:
      cb->errorno = 0;
      break;
    case CMOERROR:
      cb->errorno = 1;
      break;
    case CMOERROR2:
      cb->errorno = -1;
      break;
    }
    return(0);
  }
}


/* ------------------------------------- */
/* This function is called after reading the tag CMO_INT32COEFF */
struct coeff * cmoGetInt32Coeff(struct cmoBuffer *cb)
{
  struct coeff *c;
  c = intToCoeff(cmoGetIntFromBuf(CMOGET,cb),CurrentRingp);
  return(c);
}
void *cmoGetString(struct cmoBuffer *cb, int size)
{
  char *d;
  int i;
  if (size > 0) {
    d = (char *)GC_malloc(size);
    if (d == NULL) {
      errorCmo("No more memory in cmoGetString().\n");
    }
  }else{ 
    d = (char *)GC_malloc(1); d[0] = '\0';
    if (d == NULL) {
      errorCmo("No more memory in cmoGetString().\n");
    }
  }
  for (i=0; i<size; i++) {
    d[i] = cmoGetIntFromBuf(CMOGETBYTE, cb);
  }
  return(d);
}
    
POLY cmoGetMonomial32(struct cmoBuffer *cb)
{
  int nn,i,tt;
  struct coeff *c;
  struct monomial *m;
  MP_INT *mi;
  MP_INT *mi2;
  int skip;
  int nn0,nn1;
  extern int ReverseOutputOrder;
  skip = 0;
  nn = cmoGetIntFromBuf(CMOGET,cb);
  if (nn > (CurrentRingp->n)*2 ) {  /* it was nn ! = */
    skip = nn - (CurrentRingp->n)*2;
    nn1 = nn0 = CurrentRingp->n;
    if (! (cb->errorno) ) {
      warningCmo("cmoGetMonomial32(): serialized polynomial \\not\\in CurrentRing.");
    }
    cmoGetIntFromBuf(CMOERROR,cb);
  }else if (nn == (CurrentRingp->n)*2 ) {
    nn1 = nn0 = CurrentRingp->n;
    skip = 0;
  }else {
    nn0 = nn/2;
    nn1 = nn - nn0;
    skip = 0;
  }

  m = newMonomial(CurrentRingp);
  if (ReverseOutputOrder) {
    for (i=0; i<nn0; i++) {
      m->e[nn0-i-1].x = cmoGetIntFromBuf(CMOGET,cb);
    }
    for (i=0; i<nn1; i++) {
      m->e[nn1-i-1].D = cmoGetIntFromBuf(CMOGET,cb);
    }
  }else{
    for (i=0; i<nn0; i++) {
      m->e[i].x = cmoGetIntFromBuf(CMOGET,cb);
    }
    for (i=0; i<nn1; i++) {
      m->e[i].D = cmoGetIntFromBuf(CMOGET,cb);
    }
  }

  /* Throw a way extra data. */
  for (i=0; i<skip; i++) {
    cmoGetIntFromBuf(CMOGET,cb);
  }
  
  tt = cmoGetIntFromBuf(CMOGET,cb);
  switch(tt) {
  case CMO_INT32:
    c = cmoGetInt32Coeff(cb);
    break;
  case CMO_ZZ:
    mi = newMP_INT();
    cmoGetGMPCoeff(mi, cb);
    c = mpintToCoeff(mi,CurrentRingp);
    /* errorCmo("Not implemented."); */
    break;
  case CMO_QQ:
    if (! (cb->errorno) ) {
      warningCmo("cmoGetMonomial32(): coefficient CMO_QQ is not supported. Denominators are ignored.");
    }
    cmoGetIntFromBuf(CMOERROR,cb);
    mi = newMP_INT();
    cmoGetGMPCoeff(mi,cb);
    c = mpintToCoeff(mi,CurrentRingp);  /* we take only numerator */
    /* Throw a way denominators. */
    mi2 = newMP_INT();
    cmoGetGMPCoeff(mi2,cb);
    break;
  default:
    cmoGetIntFromBuf(CMOERROR2,cb);
    errorCmo("cmoGetMonomial32(): coeff type that is not implemented.");
    break;
  }
  return(newCell(c,m));
}



/* ------------------------------------- */
void cmoObjectToCmo00(struct object ob)
{
  struct object rob;
  cmoint tmp[2];
  int i,size;
  /* NO initialization */
  switch(ob.tag) {
  case Snull:
    cmoOutCmoNull();
    break;
  case Sinteger:
    /* fprintf(stderr,"For test.\n"); */
    cmoOutInt32(ob.lc.ival); 
    break;
  case Sdollar:
    cmoOutString(ob.lc.str,strlen(ob.lc.str));
    break;
  case Spoly:
    cmoOutPolynomial(KopPOLY(ob));
    break;
  case Sarray:
    tmp[0] = htonl(CMO_LIST);
    tmp[1] = htonl(size=getoaSize(ob));
    cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint)*2);
    for (i=0; i<size; i++) {
      cmoObjectToCmo00(getoa(ob,i));
    }
    break;
  case SuniversalNumber:
    cmoOutGMPCoeff(ob.lc.universalNumber->val.bigp);
    break;
  case Sclass:
    switch(ectag(ob)) {
    case CLASSNAME_ERROR_PACKET:
      /* fprintf(stderr,"ectag=%d\n",ectag(*KopErrorPacket(ob)));  **kxx:CMO_ERROR*/
      if (ectag(*KopErrorPacket(ob)) == CLASSNAME_ERROR_PACKET) {
	tmp[0] = htonl(CMO_ERROR);
	cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint));
      }else{
	tmp[0] = htonl(CMO_ERROR2);
	cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint));
	/* Send without OX_DATA header !! */
	cmoObjectToCmo00(*(KopErrorPacket(ob)));
      }
      break;
    default:
      warningCmo("cmoObjectToCmo(): unknown etag for Sclass. Output CMO_NULL");
      cmoOutCmoNull(); /* otherwise core dump. */
      break;
    }
    break; 
  default:
    warningCmo("cmoObjectToCmo(): unknown tag. Output CMO_NULL");
    cmoOutCmoNull(); /* otherwise core dump. */
    break;
  }
  /* no flush */
}

struct object cmoObjectToCmo(struct object ob)
{
  struct object rob;
  cmoOutputToBuf(CMOINIT,NULL,0);
  cmoObjectToCmo00(ob);
  rob.tag = CMO;
  rob.lc.voidp = cmoOutputToBuf(CMOFLUSH,NULL,0);
  return(rob);
}
void cmoDumpCmo(struct object ob)
{
  if (ob.tag == CMO) {
    dumpCmoBuf((struct cmoBuffer *) ob.lc.voidp);
  }else {
    errorCmo("cmoDUmpCmo(): Object is not CMO.");
  }
}

struct object cmoCmoToObject00(struct cmoBuffer *cb)
{
  struct object rob;
  struct object ob1;
  struct object ob2;
  int tt,ival;
  int i,size;
  MP_INT *mi;
  MP_INT *mi2;
  struct ring *oldringp;


  tt = cmoGetIntFromBuf(CMOGET,cb); /* read the tag */
  /* fprintf(stderr,"CmoToObject00: tag=%d\n",tt); */
  switch (tt) {
  case CMO_ERROR2:
    rob = KnewErrorPacketObj(cmoCmoToObject00(cb));
    break;
  case CMO_ERROR:
    rob = KnewErrorPacketObj(KnewErrorPacket(SerialCurrent,-1,"CMO_ERROR"));
    break;
  case CMO_NULL:
    rob.tag = Snull; 
    break;
  case CMO_INT32:
    /* For test. */
    ival = cmoGetIntFromBuf(CMOGET,cb);
    rob = KpoInteger(ival);
    break;
  case CMO_STRING:
    size = cmoGetIntFromBuf(CMOGET,cb);
    rob = KpoString((char *)cmoGetString(cb,size));
    break;
  case CMO_LIST:
    size = cmoGetIntFromBuf(CMOGET,cb);
    if (size < 0) errorCmo("cmoCmoToObject00(): size of array is negative.");
    rob = newObjectArray(size);
    /* printf("size=%d\n",size); */
    for (i=0; i<size; i++) {
      putoa(rob,i,cmoCmoToObject00(cb));
      /* printObject(getoa(rob,i),0,stdout); */
      if (i==0) {
	ob1 = getoa(rob,0);
	if (ob1.tag == CMO+CMO_DMS) {
	  goto dmscase ;
	}
      }
    }
    break;
  case CMO_DMS:
    rob.tag = CMO+CMO_DMS;  /* OK?? */
    break;
  case CMO_DMS_GENERIC:
    rob.tag = Snull;
    break;
  case CMO_DMS_OF_N_VARIABLES:
    rob = cmoCmoToObject00(cb); /* list structure will come. */
    break;
  case CMO_RING_BY_NAME:
    rob = cmoCmoToObject00(cb); /* read the string. */
    break;
  case CMO_MONOMIAL32:
    rob = KpoPOLY(cmoGetMonomial32(cb));
    break;
  case CMO_ZERO:
    rob = KpoPOLY(POLYNULL);
    break;
  case CMO_ZZ:
    mi = newMP_INT();
    cmoGetGMPCoeff(mi, cb);
    rob.tag = SuniversalNumber;
    rob.lc.universalNumber = mpintToCoeff(mi,SmallRingp);
    break;
  case CMO_QQ:
    mi = newMP_INT();
    cmoGetGMPCoeff(mi, cb);
    mi2 = newMP_INT();
    cmoGetGMPCoeff(mi2, cb);
    ob1.tag = SuniversalNumber;
    ob1.lc.universalNumber = mpintToCoeff(mi,SmallRingp);
    ob2.tag = SuniversalNumber;
    ob2.lc.universalNumber = mpintToCoeff(mi2,SmallRingp);
    rob = KooDiv2(ob1,ob2);
    break;
  defaut:
    fprintf(stderr,"tag=%d (%x) ",tt,tt);
    errorCmo("cmoCmoToObject00(): unknown CMO tag. returns null object.");
    rob.tag = Snull;
    break;
  }
  return(rob);

 dmscase: ;
  /* Case for DMS. */
  oldringp = CurrentRingp;
  i = 1;
  if (i >= size) errorCmo("cmoCmoToObject00(): DMS, ring-def, ...");
  putoa(rob,i,cmoCmoToObject00(cb));
  ob1 = getoa(rob,1);
  if (ob1.tag == Sdollar) {
    /* Change the CurrentRingp by looking up the name. */
    ob1 = KfindUserDictionary(KopString(ob1));
    if (ob1.tag != Sring) {
      errorCmo("cmoCmoToObject00(): your ring is not defined in the name space.");
    }
    CurrentRingp = KopRingp(ob1);
  }
  i = 2;
  while (i<size) {
    putoa(rob,i,cmoCmoToObject00(cb));
    i++;
  }
  CurrentRingp = oldringp;
  return(rob);
}
    
struct object cmoCmoToObject(struct object ob)
{
  struct object rob;
  struct object ob0;
  struct cmoBuffer *cb;
  if (ob.tag != CMO) {
    rob.tag = Snull;
    errorCmo("cmoCmoToObject(): the argument is not CMO.");
    return(rob);
  }
  cb = (struct cmoBuffer *) ob.lc.voidp;
  cmoGetIntFromBuf(CMOINIT,cb);
  if (cb->pos == 0) {
    /* null */
    rob.tag = Snull;
    return(rob);
  }
  rob = cmoCmoToObject00(cb);
  rob = cmoListToPoly(rob);
  return(rob);
}

struct object cmoListToPoly(struct object ob) {
  struct object ob0;
  struct object rob;
  int i,n;
  if (ob.tag == Sarray) {
    n = getoaSize(ob);
    if (n >= 1) {
      ob0 = getoa(ob,0);
      if (ob0.tag == CMO+CMO_DMS) {
	rob = KpoPOLY(cmoListToPOLY(ob)); /* not ToPoly, ToPOLY */
      }else{
	rob = newObjectArray(n);
	for (i=0; i<n; i++) {
	  putoa(rob,i,cmoListToPoly(getoa(ob,i)));
	}
      }
    }else{
      rob = ob;
    }
  }else{
    rob = ob;
  }
  return(rob);
}

/*
main() {
 int i;
 struct cmoBuffer *cb;
 printf("%d\n",sizeof(long int));
 for (i=0; i<300; i++) {
   cmoOutInt32(i);
 }
 dumpCmoBuf(cb=cmoOutputToBuf(CMOFLUSH,NULL,0));
 cmoGetIntFromBuf(CMOINIT,cb);
 for (i=0; i<300; i++) {
   printf("%5d",cmoGetIntFromBuf(CMOGET,cb));
 }
 putchar('\n');
}
*/

POLY cmoListToPOLY(struct object ob) 
{
  int size,i;
  struct object ob0,ob1;
  POLY f;
  /*
     printf("<<");printObject(ob,0,stdout); printf(">>\n"); fflush(stdout);
     */
  if (ob.tag != Sarray) {
    errorCmo("cmoListToPOLY(): the argument must be array.");
  }
  size = getoaSize(ob);
  if (size < 2) {
    errorCmo("cmoListToPOLY(): the first element of the array must be CMO-tag.");
    errorCmo("cmoListToPOLY(): the second element must be the ring definition.");
  }
  ob0 = getoa(ob,0);
  ob1 = getoa(ob,1);  /* ring defintion. It is not used for now. */
  /* printObject(ob1,0,stdout); */
  switch(ob0.tag) {
  case (CMO+CMO_DMS):
    f = POLYNULL;
    for (i=size-1; i>=2; i--) {
      ob1 = getoa(ob,i);
      if (ob1.tag == Spoly) {
	f = ppAdd(f,KopPOLY(ob1));
      }else{
	f = ppAdd(f,cmoListToPOLY(ob1));
      }
    }
    return(f);
    break;
  default:
    errorCmo("cmoListToPoly(): unknown tag.");
    break;
  }
}


int Kan_PushBinary(int size,void *data)
{
  struct cmoBuffer cb;
  struct object ob;
  cb.pos = size;
  cb.rpos = 0;
  cb.buf = data;
  cb.size = size;
  ob.tag = CMO;
  ob.lc.voidp = &cb;
  KSpush(cmoCmoToObject(ob));
  return(0);
}

void *Kan_PopBinary(int *sizep)
{
  struct object ob;
  struct cmoBuffer *cb;
  ob = KSpop();
  ob = cmoObjectToCmo(ob);
  if (ob.tag == CMO) {
    cb = (struct cmoBuffer *) (ob.lc.voidp);
    *sizep = cb->pos;
    return(cb->buf);
  }
  return(NULL);
}





struct object cmoObjectFromStream(struct object obStream)
{
  struct cmoBuffer cb;
  struct object rob;
  if (obStream.tag != Sfile) {
    errorCmo("cmoObjectFromStream: Argument must be of type file.");
  }
  if (strcmp(obStream.lc.str,MAGIC2) != 0) {
    errorCmo("cmoObjectFromStream: Argument must be of type plugin/file2 buffered IO.");
  }
  return(cmoObjectFromStream2((FILE2 *)obStream.rc.voidp));
}
struct object cmoObjectFromStream2(FILE2 *fp2)
{
  struct cmoBuffer cb;
  struct object rob;
  cb.isStream=1; cb.fp = fp2;
  cmoGetIntFromBuf(CMOINITSTREAM,&cb);
  rob = cmoCmoToObject00(&cb);
  rob = cmoListToPoly(rob);
  if (cb.errorno) errorCmo("at cmoObjectFromStream2");
  return(rob);
}

struct object cmoObjectToStream(struct object ob, struct object obStream)
{
  struct object rob;
  if (obStream.tag != Sfile) {
    errorCmo("cmoObjectToStream: Argument must be of type file.");
  }
  if (strcmp(obStream.lc.str,MAGIC2) != 0) {
    errorCmo("cmoObjectToStream: Argument must be of type plugin/file2 buffered IO.");
  }
  return(cmoObjectToStream2(ob,(FILE2 *)obStream.rc.voidp));
}

struct object cmoObjectToStream2(struct object ob, FILE2 *fp2)
{
  struct object rob;
  cmoOutputToBuf(CMOINITSTREAM,(void *)fp2,0);
  cmoObjectToCmo00(ob);
  fp2fflush(fp2);
  rob = KpoInteger(0);
  return(rob);
}

int Kan_pushCMOFromStream(FILE2 *fp)
{
  struct object ob;
  struct object rob;
  ob.tag = Sfile; ob.rc.voidp = (void *)fp; ob.lc.str = MAGIC2;
  rob = cmoObjectFromStream(ob);
  KSpush(rob);
  return(0);
}

int Kan_popCMOToStream(FILE2 *fp)
{
  struct object ob;
  struct object sob;
  sob.tag = Sfile; sob.rc.file = (void *)fp; sob.lc.str = MAGIC2;
  ob = Kpop();
  cmoObjectToStream(ob,sob);
  return(0);
}
  

int cmoOutRawInt(int k)
{
  cmoint tmp[1];
  tmp[0] = htonl((cmoint ) k);
  cmoOutputToBuf(CMOPUT,tmp,sizeof(cmoint));
}  

warningCmo(char *s) {
  fprintf(stderr,"Warning: plugin/cmo.c : %s\n",s);
}

errorCmo(char *s) {
  fprintf(stderr,"plugin/cmo.c : %s\n",s);
  errorKan1("%s\n","cmo fatal error. ox servers need SM_control_reset_connection.");
  /* ErrorPacket is automatically push on the ErrorStack.
     cf. var.sm1, [(ErrorStack)] system_variable */
  /*   KSexecuteString(" error "); */
}
