#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>
/* -lnsl -lsocket /usr/ucblib/libucb.a */
#include "ox_kan.h"

#define READBUFSIZE 10000
static void errorMsg1s(char *s) {
  fprintf(stderr,"%s\n",s);
}

FILE *TcpioError = stdout;
int OpenedSocket = 0;
extern int Quiet;

socketOpen(char *serverName,int portNumber) {
  static struct hostent *myhost;
  static struct sockaddr_in me;
  static int s_waiting;
  static int on;
  extern int errno;
  int tt;


  fprintf(TcpioError,"Hello from open. serverName is %s and portnumber is %d\n",
	  serverName,portNumber);
  if ((myhost = gethostbyname(serverName)) == NULL) {
    errorMsg1s("Bad server name.");
    return(-1);
  }
  bzero((char *)&me,sizeof(me));
  me.sin_family = AF_INET;
  me.sin_port = htons(portNumber);
  bcopy(myhost->h_addr,
	&me.sin_addr,myhost->h_length);

  if ((s_waiting = socket(AF_INET,SOCK_STREAM,0)) < 0) {
    errorMsg1s("Socket allocation is failed.");
    return(-1);
  }

  on=1; setsockopt(s_waiting,SOL_SOCKET,SO_REUSEADDR,&on,sizeof(on)); 
  /* important */
  if ((tt = bind(s_waiting,(struct sockaddr *) &me,sizeof(me))) == -1) {
    fprintf(TcpioError,"Bind error. Error no is %d. See /usr/include/sys/errno.h. (asm/errno.h)\n",errno);
    errorMsg1s("cannot bind");
    return(-1);
  }
  /* printf("bind returns %d\n",tt); */
  tt = sizeof(me);
  if (getsockname(s_waiting,(struct sockaddr *)&me,&tt) < 0) {
    fprintf(TcpioError,"getsockname error. Error no is %d. See /usr/include/sys/errno.h (asm/errno.h).\n",errno);
    errorMsg1s("cannot getsockname");
    return(-1);
  }

  if (listen(s_waiting,1) < 0) {
    errorMsg1s("Listen failed");
    return(-1);
  }
  fprintf(TcpioError,"Done the initialization. port =%d\n",ntohs(me.sin_port));
  OpenedSocket = ntohs(me.sin_port);
  return(s_waiting);
}

socketAccept(int snum) {
  int s, news;
    
  s = snum;
  fprintf(TcpioError,"Trying to accept... "); fflush(TcpioError);
  if ((news = accept(s,NULL,NULL)) < 0) {
    errorMsg1s("Error in accept.");
    return(-1);
  }
  fprintf(TcpioError,"Accepted.\n"); fflush(TcpioError);
  if (close(s) < 0) {
    errorMsg1s("Error in closing the old socket.");
    return(-1);
  }
  return(news);
}

int oxSocketSelect0(int fd,int t) {
  fd_set readfds;
  struct timeval timeout;
  int debug = 0;
  extern int errno;
  FD_ZERO(&readfds);
  FD_SET(fd,&readfds);
  timeout.tv_sec = 0;
  timeout.tv_usec = (long) t;
  if (t >= 0) {
    if (debug) {printf("select t>=0 for fd = %d\n",fd); fflush(NULL);}
    if (select(fd+1,&readfds,(fd_set *)NULL,(fd_set *)NULL,&timeout)<0) {
      /* It must be fd+1 !,  Not fd. */
      fprintf(TcpioError,"select (non-block) error. Error no is %d. See /usr/include/sys/errno.h (asm/errno.h).\n",errno);
      errorMsg1s("oxSocketSelect0() : select failed.");
      return(0);
    }
    if(debug){printf("Return from select t>=0 for fd = %d\n",fd);fflush(NULL);}
  }else{ /* block */
    if (select(fd+1,&readfds,(fd_set *)NULL,(fd_set *)NULL,(struct timeval *)NULL)<0) {
      fprintf(TcpioError,"select (block) error. Error no is %d. See /usr/include/sys/errno.h (asm/errno.h).\n",errno);
      errorMsg1s("socketSelect0() : select failed.");
      return(0);
    }
  }
  if (FD_ISSET(fd,&readfds)) return(1);
  else return(0);
}

oxSocketMultiSelect(int sid[],int size,int t,int result[])
{
  int i,fd,p;
  fd_set readfds;
  struct timeval timeout;
  int isdata = 0;
  extern errno;

  FD_ZERO(&readfds);
  timeout.tv_sec = 0;
  timeout.tv_usec = (long)t;

  fd = 0;

  for (i=0; i<size; i++) {
    if (sid[i] >= 0) {
      p = sid[i];
      if (p > fd) fd = p;
      FD_SET(p,&readfds);
      /* printf("p = %d, fd=%d",p,fd); */
    }
  }

  /* printf("MultiSelect..\n"); fflush(NULL); */
  if (t >= 0) {
    if (select(fd+1,&readfds,(fd_set *)NULL,(fd_set *)NULL,&timeout)<0) {
      /* It must be fd+1 !,  Not fd. */
      fprintf(TcpioError,"Select error. Error no is %d. See /usr/include/sys/errno.h (asm/errno.h).\n",errno);
      errorMsg1s("oxSocketMultiSelect() : select failed.");
      return(0);
    }
  }else{ /* block */
    if (select(fd+1,&readfds,(fd_set *)NULL,(fd_set *)NULL,(struct timeval *)NULL)<0) {
      fprintf(TcpioError,"Select error. Error no is %d. See /usr/include/sys/errno.h (asm/errno.h).\n",errno);
      errorMsg1s("oxSocketMultiSelect() : (block) select failed.");
      return(0);
    }
  }
  /* printf("Done. MultiSelect.\n"); fflush(NULL); */
  for (i=0; i<size; i++) {
    p = sid[i];
    if ((sid[i] >=0) && FD_ISSET(p,&readfds)) {
      result[i] = 1; isdata = 1;
    }else{
      result[i] = 0;
    }
  }
  return(isdata);
}


socketConnect(char *serverName,int portNumber) {
  struct hostent *servhost;
  struct sockaddr_in server;
  int socketid;
  int on;

  if ((servhost = gethostbyname(serverName)) == NULL) {
    errorMsg1s("bad server name.\n");
    return(-1);
  }
  bzero((char *)&server,sizeof(server));
  server.sin_family = AF_INET;
  server.sin_port = htons(portNumber);
  bcopy(servhost->h_addr,
	(char *)&server.sin_addr,servhost->h_length);

  if ((socketid = socket(AF_INET,SOCK_STREAM,0)) <0) {
    errorMsg1s("socket allocation is failed.\n");
    return(-1);
  }
  /* on=1; setsockopt(socketid,SOL_SOCKET,SO_REUSEADDR,&on,sizeof(on));  */
  if (!Quiet) {
    fprintf(TcpioError,"Trying to connect port %d, ip=%x\n",ntohs(server.sin_port),server.sin_addr);
  }
  if (connect(socketid,(struct sockaddr *)&server,sizeof(server)) == -1) {
    errorMsg1s("cannot connect");
    return(-1);
  }
  if (!Quiet) fprintf(TcpioError,"connected.\n");
  return(socketid);
}

