#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "datatype.h"
#include "stackm.h"
#include "extern.h"
#include "extern2.h"
#include <signal.h>
#include "plugin.h"


#define SIZE_OF_ENVSTACK 5
static jmp_buf EnvStack[SIZE_OF_ENVSTACK];
static int Envp = 0;
static void pushEnv(jmp_buf jb) {
  if (Envp < SIZE_OF_ENVSTACK) {
    *(EnvStack[Envp]) = *jb;
    Envp++;
  }else{
    fprintf(stderr,"Overflow of  EnvStack.\n");
    exit(2);
  }
}
static void popEnv(jmp_buf jbp) {
  if (Envp <= 0) {
    fprintf(stderr,"Underflow of EnvStack.\n");
    exit(3);
  }else{
    Envp--;
    *jbp = *EnvStack[Envp];
  }
}

struct object Kextension(struct object obj)
{
  char *key;
  int size;
  struct object keyo;
  struct object rob = NullObject;
  struct object obj1,obj2,obj3;
  int m,i;
  extern struct context *CurrentContextp;
  extern jmp_buf EnvOfStackMachine;
  extern void ctrlC();
  extern int SigIgn;
  void (*oldsig)();  

  if (obj.tag != Sarray) errorKan1("%s\n","Kextension(): The argument must be an array.");
  size = getoaSize(obj);
  if (size < 1) errorKan1("%s\n","Kextension(): Empty array.");
  keyo = getoa(obj,0);
  if (keyo.tag != Sdollar) errorKan1("%s\n","Kextension(): No key word.");
  key = KopString(keyo);

  /* branch by they key word. */
  if (strcmp(key,"parse")==0) {
    if (size != 2) errorKan1("%s\n","[(parse)  string] extension.");
    obj1 = getoa(obj,1);
    if (obj1.tag != Sdollar) errorKan1("%s\n","[(parse)  string] extension");

    pushEnv(EnvOfStackMachine);
    m = KSexecuteString(obj1.lc.str);
    /* This is critical area. If you catch ctrl-c here, program crashes. */
    oldsig = signal(SIGINT,SIG_IGN);
    popEnv(EnvOfStackMachine);
    /* OK! We passed the critical area. */
    signal(SIGINT,oldsig);
    rob = KpoInteger(m);
  }else if (strcmp(key,"getpid") == 0) {
    rob = KpoInteger( (int) getpid() );
  }else if (strcmp(key,"flush") == 0) {
    /* fflush(NULL); */
    fflush(stdout);
    rob.tag = Snull;
  }else if (strcmp(key,"chattrs")==0) {
    if (size != 2) errorKan1("%s\n","[(chattrs)  num] extension.");
    obj1 = getoa(obj,1);
    if (obj1.tag != Sinteger) errorKan1("%s\n","[(chattrs)  num] extension.");
    m = KopInteger(obj1);
    if (!( m == 0 || m == PROTECT || m == ABSOLUTE_PROTECT))
      errorKan1("%s\n","The number must be 0, 1 or 2.");
    putUserDictionary2((char *)NULL,0,0,m | SET_ATTR_FOR_ALL_WORDS,
		       CurrentContextp->userDictionary);
  }else if (strcmp(key,"keywords")==0) {
    if (size != 1) errorKan1("%s\n","[(keywords)] extension.");
    rob = showSystemDictionary(1);
    /*  }else if (strcmp(key,"fork0")==0) {
	if (size != 2) errorKan1("%s\n","[(fork0) sss] extension.");
	m = fork();
	if (m>0) { rob = KpoInteger(m); }
	else {
	  system(KopString(getoa(obj,1))); exit(0);
	} */
    }else if (strcmp(key,"defaultPolyRing")==0) {
      if (size != 2) errorKan1("%s\n","[(defaultPolyRing) n] extension.");
      rob = KdefaultPolyRing(getoa(obj,1));
    }else if (strcmp(key,"hilbert")==0) {
      if (size != 3) errorKan1("%s\n","[(hilbert) obgb obvlist] extension.");
      rob = hilberto(getoa(obj,1),getoa(obj,2));
    }else if (strcmp(key,"chattr")==0) {
      if (size != 3) errorKan1("%s\n","[(chattr)  num symbol] extension.");
      obj1 = getoa(obj,1);
      obj2 = getoa(obj,2);
      if (obj1.tag != Sinteger) errorKan1("%s\n","[(chattr)  num symbol] extension.");
      if (obj2.tag != Sstring)  errorKan1("%s\n","[(chattr)  num symbol] extension.");
      m = KopInteger(obj1);
      if (!( m == 0 || m == PROTECT || m == ABSOLUTE_PROTECT))
	errorKan1("%s\n","The number must be 0, 1 or 2.");
      putUserDictionary2(obj2.lc.str,(obj2.rc.op->lc).ival,(obj2.rc.op->rc).ival,
			 m,CurrentContextp->userDictionary);
    }
#include "plugin.hh"
  else{
    errorKan1("%s\n","Unknown tag for extension.");
  }


  return(rob);
}

