

/* kclass.h  1997, 3/1
   This module handles class data base.
   Extended class names.
*/

/* Format of extended class
   Sclass
   ob.lc.ival :  extended tag
   ob.rc.voidp : body
*/
/* The next macro  Extended Class tag returns -1 if the object
   is not in Sclass and returns extended class tags if the object
   is in Sclass.
   */
#define ectag(ob) ((ob).tag != Sclass? -1:(ob).lc.ival)
#define ecbody(ob) ((ob).rc.voidp)
/* Extended Class tags */
#define CLASSNAME_OPERANDSTACK 256
#define CLASSNAME_ERROR_PACKET 257
#define CLASSNAME_CONTEXT 258
#define CLASSNAME_GradedPolySet 259
#define CLASSNAME_mathcap  260


/*    */
#define  CLASS_NOT_USED  0
#define  CLASS_INTERNAL  1
#define  CLASS_OBJ     2

/* conversion function */
struct object KpoOperandStack(struct operandStack * op);
struct object KpoErrorPacket(struct object *op);
struct object KpoContext(struct context *ct);
struct object KpoGradedPolySet(struct gradedPolySet *grG);
struct object KpoMathCap(struct object *op);

#define KopOperandStack(ob) ((struct operandStack *)(ob).rc.voidp)
#define KopErrorPacket(ob) ((struct object *)(ob).rc.voidp)
#define KopContext(ob) ((struct context *)(ob).rc.voidp)
#define KopGradedPolySet(ob) ((struct gradedPolySet *)(ob).rc.voidp)
#define KopMathCap(ob) ((struct object *)(ob).rc.voidp)


void fprintErrorPacket(FILE *fp, struct object *op);
void fprintMathCap(FILE *fp, struct object *op);
