/* Do not edit this file. */
struct mathCap {
  int version;
  char name[256];
  int n;
  int cmo[1024];
};
/* file2.h */

#define MAGIC2 "Buffered IO by FILE2"
/*  ob.tag == Sfile, ob.lc.str == MAGIC2, ob.lc.voidp = (FILE2 *)fp2; */
#define FILE2BSIZE 1024

typedef struct FILE2 {
  int fd;
  int initialized;
  unsigned char readBuf[FILE2BSIZE];
  unsigned char writeBuf[FILE2BSIZE];
  int readpos;
  int readsize;
  int writepos;
  int limit;
  int watch;
  FILE *watchFile;
  void *mathcapList; /* pointer to struct object */
} FILE2 ;

FILE2 *fp2open(int fd);
int fp2fflush(FILE2 *fp);
int fp2fclose(FILE2 *fp);
int fp2fputc(int c,FILE2 *fp);
int fp2fgetc(FILE2 *fp);
int fp2select(FILE2 *fp2, int t);
int fp2dumpBuffer(FILE2 *fp);
int fp2clearReadBuf(FILE2 *fp);
int fp2write(FILE2 *fp,char *data,int size);
int fp2watch(FILE2 *fp,FILE *log);
int fp2stopWatch(FILE2 *fp);



 
/*  cmotag.h */
/* #define     CMO   1024  It is defined in stackm.h. */
/* Never Use 0 as a CMO tag. */
#define LARGEID   0x7f000000
#define CMO_PRIVATE 0x7fff0000
#define CMO_ERROR  (LARGEID+1)
#define CMO_ERROR2 (LARGEID+2)
#define CMO_NULL   1
#define CMO_INT32  2
#define CMO_DATUM  3
#define CMO_STRING 4
#define CMO_MATHCAP 5


#define CMO_START_SIGNATURE    0x7fabcd03     
#define CMO_LOCAL_OBJECT       0x7fcdef03
#define CMO_LOCAL_OBJECT_ASIR  (CMO_LOCAL_OBJECT+0)
#define CMO_LOCAL_OBJECT_SM1  (CMO_LOCAL_OBJECT+1)

#define     CMO_TAG  16
#define     CMO_LIST 17
#define     CMO_ATOM 18
#define     CMO_MONOMIAL32  19
#define     CMO_ZZ          20   /* CMO_GMPCOEF */
#define     CMO_QQ          21
#define     CMO_ZERO        22
#define     CMO_DMS          23   /* Distributed monomial system */
#define     CMO_DMS_GENERIC     24
#define     CMO_DMS_OF_N_VARIABLES 25
#define     CMO_RING_BY_NAME  26
#define     CMO_RECURSIVE_POLYNOMIAL 27
#define     CMO_LIST_R   28
#define     CMO_INT32COEFF  30
#define     CMO_DISTRIBUTED_POLYNOMIAL 31

#define     CMO_64BIT_MACHINE_DOUBLE   40
#define     CMO_ARRAY_OF_64BIT_MACHINE_DOUBLE  41


/* end of cmotag.h */

/* ox_message_tag.h */
#define OX_COMMAND                   513	
#define OX_DATA                      514
#define OX_SYNC_BALL                 515      /* ball to interrupt */

/* level 2 stack machine with programming facility. */
#define OX_START_OF_FUNCTION_BLOCK    518
#define OX_END_OF_FUNCTION_BLOCK      519
#define OX_ADDRESS                    520

#define OX_SECURED_DATA               521

/* ox_function_id.h */
#define SM_popSerializedLocalObject 258
#define SM_popCMO 262
#define SM_popString 263    /* result ==> string and send the string by CMO */

#define SM_mathcap 264
#define SM_pops 265
#define SM_setName 266
#define SM_evalName 267 
#define SM_executeStringByLocalParser 268 
#define SM_executeFunction 269
#define SM_beginBlock  270
#define SM_endBlock    271
#define SM_shutdown    272
#define SM_setMathCap  273
#define SM_executeStringByLocalParserInBatchMode 274

#define SM_DUMMY_sendcmo  280
#define SM_sync_ball 281

#define SM_control_kill 1024
#define SM_control_reset_connection  1030
#define SM_control_to_debug_mode 1025
#define SM_control_exit_debug_mode 1026
#define SM_control_ping  1027
#define SM_control_start_watch_thread 1028
#define SM_control_stop_watch_thread 1029

/* ox_kan0.h */

#define mymalloc(n) malloc(n)
#define myfree(p) free(p)
typedef FILE2 *  ox_stream;

int socketOpen(char *serverName,int portNumber);
/* OpenedSocket is used to return the port number. */
int socketAccept(int snum);
int socketAcceptLocal(int snum);
int oxSocketSelect0(int fd,int t);
int oxSocketMultiSelect(int sid[],int size,int t,int result[]);
int socketConnect(char *serverName,int portNumber);
int socketConnectWithPass(char *serverName,int portNumber,char *pass);


/* ------------------------------------- */
extern FILE *MyErrorOut;

typedef struct CMO_Object {
  int tag;
  char data[1];
} CMO_Object ;

typedef struct CMO_string_object {
  int tag;
  int size;
  char data[1];
} CMO_string_object;

typedef struct CMO_int32_object {
  int tag;
  int n;
} CMO_int32_object ;

void printCMO_object(FILE *fp,CMO_Object *op);


/* --------------------------------------- */
#define DSTATE_ERROR -1
#define DSTATE_ANY  0
#define DSTATE_FIRST_SYNC 1
#define DSTATE_SECOND_SYNC 2
#define DSTATE_WAIT_OX_DATA 256

typedef  struct oxclient {
  ox_stream datafp2;
  int dataport;
  int controlfd;
  int controlport;
  int dstate;    /* state of data channel */
     /*  0 : any 
         1 : waiting the first OX_SYNC_BALL
	 2 : waiting the second OX_SYNC_BALL
        256: waiting the OX_DATA to stack.
     */
  int cstate;    /* state of control channel */
     /*  0 : any
	 1 : waiting resultOfControlInt32
     */
  int humanio;   /* 1: stdin,  0: not */
  int type;      /* 0: CLIENT_SOCKET socket, 1: CLIENT_FILE file */
  int id;  /* client identifier. */
  void *mathcapObjp;  /* NULL for the initial state.
			 NULL means no restriction.*/
} oxclient;
#define N_OF_CLIENT_FIELDS  11    /* If you add new field to struct oxclient
				     do not forget to increase the number.*/
/* Change also, oxInitClient, oxCreateClient, oxCreateClientFile    oxmisc.c
   oxClientToObject, oxObjectToClient oxmisc2.c
   */
typedef oxclient * oxclientp;

#define CLIENT_SOCKET 0
#define CLIENT_FILE   1

int oxGetResultOfControlInt32(int fd);
int oxclientMultiSelect(oxclientp clients[],int dataready[],int controlready[],
			int size, int t);
int oxInitClient(oxclientp c);
int oxGetControl(oxclientp client);
int oxIsThereErrorClient(oxclientp client);  /* 1 : error, 0 : OK. */
oxclientp oxCreateClient(char *ipname,int portStream,int portControl);
oxclientp oxCreateClientFile(char *fileName,char *mode,char *controlFileName,char *cmode);
oxclientp oxCreateClient2(int fdstream,int portStream,
			  int fdcontrol,int portControl,int ipmask,char *pass);

char *oxGenPass(void);

/* -------------------------------------- */
int readOneByte(int fd);   /* blocking */
int oxfdGetInt32(int fd);
int oxGetInt32(ox_stream ostream);
int oxfdGetOXheader(int fd,int *serial);
int oxGetOXheader(ox_stream ostream, int *serial);
int oxGetCMOInt32(ox_stream ostream);
char *oxGetCMOString(ox_stream ostream);

void oxfdSendInt32(int fd,int k);
void oxfdSendOXheader(int fd,int k,int serial);
void oxfdSendCmoNull(int fd);
void oxfdSendCmoInt32(int fd,int k);
void oxfdSendCmoString(int fd,char *s);
void oxfdSendSyncBall(int fd);

void oxSendInt32(ox_stream ostream,int k);
void oxSendOXheader(ox_stream ostream,int k,int serial);
void oxSendCmoNull(ox_stream ostream);
void oxSendCmoError(ox_stream ostream);
void oxSendCmoError2(ox_stream ostream,char *s);
void oxSendCmoInt32(ox_stream ostream,int k);
void oxSendCmoString(ox_stream ostream,char *s);
void oxSendMathCap(ox_stream ostream,struct mathCap *mathcap);
void oxPushMathCap(struct mathCap *mathcap);

void oxSendSyncBall(ox_stream ostream);
int  oxWaitSyncBall(ox_stream ostream);

void oxSendResultOfControl(int fd);
void oxSendResultOfControlInt32(int fd, int k);


void oxReqMathCap(ox_stream os);
void oxReqSetMathCap(ox_stream os,struct mathCap *mathcap);
void oxReqPops(ox_stream os,int n);
void oxReqSetName(ox_stream os,char *name);
void oxReqEvalName(ox_stream os,char *name);
void oxReqExecuteStringByLocalParser(ox_stream os,char *s);
void oxReqExecuteFunction(ox_stream os,char *s);
void oxReqPopString(ox_stream os);
void oxReqPushString(ox_stream os,char *s);
void oxReqPopCMO(ox_stream os);

void oxReqControlResetConnection(int fd);
void oxReqControlKill(int fd);

int oxReadPortFile(int func,char *fname);  /* 0 : .control, 1 : .data */
int oxWritePortFile(int func,int port,char *fname);
char *oxGenPortFile(void);
int oxRemovePortFile(void);

