/* nullserver01 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <setjmp.h>
/* -lnsl -lsocket /usr/ucblib/libucb.a */
#include "ox_kan.h"
#include "serversm.h"

int OxCritical = 0;
int OxInterruptFlag = 0;
int PacketMonitor = 0;

extern int SerialOX;  /* Serial number of the packets sent. */
extern int SerialCurrent;  /* Current Serial number of the recieved packet. */
extern int OXprintMessage; /* print oxmessages? */

jmp_buf EnvOfChildServer;

int JmpMessage = 0;

main(int argc, char *argv[]) {
  if (argc > 1) {
    if (strcmp(argv[1],"-monitor")==0) {
      fprintf(stderr,"Taking the packet monitor.\n");
      PacketMonitor = 1;
    }else{
      fprintf(stderr,"Unknown option. Possible options are -monitor\n");
    }
  }
  Sm1_start();
  nullserver(3);
}

nullserver(int fdStream) {
  int mtag;
  int message = 1;
  ox_stream ostream;
  char sreason[1024];
  extern void controlResetHandler();
  extern jmp_buf EnvOfStackMachine;

  if (fdStream != -1) {
    ostream = fp2open(fdStream);
    if (ostream == NULL) {
      fprintf(stderr,"fp2open(fdStream) failed.\n");
      fdStream = -1;
    }
    if (PacketMonitor) fp2watch(ostream,stdout);
  }
  aaa : ;
  if (setjmp(EnvOfChildServer)) {
    fprintf(stderr,"childServerMain: jump here.\n");
    if (OxInterruptFlag == 0) {
      fprintf(stderr," ?! \n"); fflush(NULL);
    }
    signal(SIGUSR1,controlResetHandler); goto aaa;
  } else {  
    if (JmpMessage) fprintf(stderr,"Set EnvOfChildServer.\n");
    signal(SIGUSR1,controlResetHandler);
  }
  
  if (setjmp(EnvOfStackMachine)) {
    fprintf(stderr,"childServerMain: jump here by EnvOfStackMachine.\n");
    if (OxInterruptFlag == 0) {
      fprintf(stderr," ?! \n"); fflush(NULL);
    }
    /* In case of error in the stack machine, pop the error info
       and send the error packet. */
    /* oxSendOXheader(ostream,OX_DATA,SerialOX++);
    oxSendCmoError(ostream); 
    oxSendOXheader(ostream,OX_DATA,SerialOX++);
    sprintf(sreason,"Jump here by sm1 error.");
    oxSendCmoError2(ostream,sreason);
    */
    Sm1_pushError2(SerialCurrent,-1,"Global jump by sm1 error");

    signal(SIGUSR1,controlResetHandler); goto aaa ;
  } else {
    if (JmpMessage) fprintf(stderr,"Set EnvOfStackMachine.\n"); 
    if (signal(SIGUSR1,SIG_IGN) != SIG_IGN) {
      signal(SIGUSR1,controlResetHandler);
    }
  }
  
  while (1) {
    message = OXprintMessage;
    if (OxInterruptFlag) {
      OxCritical = 1;
      if (message) {fprintf(stderr,"Clearing the read buffer.\n");fflush(NULL); }
      fp2clearReadBuf(ostream); /* clear the read buffer */
      if (message) {fprintf(stderr,"Throwing OX_SYNC_BALL\n"); fflush(NULL);}
      oxSendSyncBall(ostream);
      if (message) {fprintf(stderr,"Waiting for OX_SYNC_BALL\n");fflush(NULL);}
      oxWaitSyncBall(ostream);
      if (message) {fprintf(stderr,"Done changing OX_SYNC_BALL\n"); fflush(NULL);}
      OxInterruptFlag = 0;
      OxCritical = 0;
      goto aaa ;
    }
    OxCritical = 0;
    if (fp2select(ostream,-1)) {
      /* If there is an data in the ostream, then read data in the buffer and
         read data in the communication stream. */
      OxCritical = 1;
    }else{
      /* interrupted system call */
      /* This part is never reached. */
    }
    OxCritical = 1;
    mtag = oxGetOXheader(ostream,&SerialCurrent); /* get the message_tag */
    if (message) {
      fprintf(stderr,"\nmtag is %d (serial=%d) : ",mtag,SerialCurrent);
      switch(mtag) {
      case OX_COMMAND: fprintf(stderr," OX_COMMAND \n"); break;
      case OX_DATA:    fprintf(stderr," OX_DATA \n"); break;
      case OX_SYNC_BALL: fprintf(stderr," OX_SYNC_BALL \n"); break;
      case -1: fprintf(stderr," End of file. Exiting the server child.\n");
	exit(); break;
      default: fprintf(stderr," ?! \n"); break;
      }
    }
    /*sleep(2);  /* for dubug OX_SYNC_BALL */
    switch(mtag) {
    case OX_COMMAND:
      nullserverCommand(ostream);
      goto aaa ;  /* We always reset the jump vector. cf. memo1.txt 1998 2/13*/
      break;
    case OX_DATA:
      Sm1_pushCMO(ostream);
      break;
    case OX_SYNC_BALL:
      /* if (OxInterruptFlag)  think about it later. */
      break;
    default:
      fprintf(stderr,"Fatal error in server.\n");
      break;
    }
  }
}

nullserverCommand(ox_stream ostream) {
  int id;
  int mtag;
  int n;
  char *name;
  char *sresult;
  struct mathCap *mathresult;
  int iresult;
  int message = 1;
  extern void controlResetHandler();

  message = OXprintMessage;
  /* message_body */
  id = oxGetInt32(ostream);   /* get the function_id */
  if (message) {fprintf(stderr,"\nfunction_id is %d\n",id);}
  switch( id ) {
  case SM_mathcap:
    if (message) fprintf(stderr," mathcap\n");
    mathresult = (struct mathCap *)Sm1_mathcap();
    oxPushMathCap(mathresult);
    break;
  case SM_setMathCap:
    if (message) fprintf(stderr," setMathCap\n");
    Sm1_setMathCap(ostream);
    break;
  case SM_pops:
    if (message) fprintf(stderr," pops \n");
    Sm1_pops();
    break;
  case SM_setName:
    if (message) fprintf(stderr," setName \n");
    iresult = Sm1_setName();
    if (iresult < 0) {
      Sm1_pushError2(SerialCurrent,-1,"setName");
    }
    break;
  case SM_evalName:
    if (message) fprintf(stderr," evalName \n");
    iresult = Sm1_evalName();
    if (iresult < 0) {
      Sm1_pushError2(SerialCurrent,-1,"evalName");
    }
    break;
  case SM_executeStringByLocalParser:
    if (message) fprintf(stderr," executeStringByLocalParser\n");
    OxCritical = 0;
    iresult = Sm1_executeStringByLocalParser();
    OxCritical = 1; signal(SIGUSR1,controlResetHandler);
    if (iresult < 0) {
      Sm1_pushError2(SerialCurrent,-1,"executeString");
      return(-1);
    }
    break;
  case SM_executeFunction:
    if (message) fprintf(stderr," executeFunction\n");
    OxCritical = 0;
    iresult = Sm1_executeStringByLocalParser();
    OxCritical = 1; signal(SIGUSR1,controlResetHandler);
    if (iresult < 0) {
      Sm1_pushError2(SerialCurrent,-1,"executeFunction");
      return(-1);
    }
    break;
  case SM_popCMO:
    if (message) fprintf(stderr,"popCMO.  Start to sending data.\n",n);
    oxSendOXheader(ostream,OX_DATA,SerialOX++);
    n=Sm1_popCMO(ostream,SerialCurrent);
    if (message) fprintf(stderr,"Done.\n"); 
    break;
  case SM_popString:
    if (message) fprintf(stderr,"popString. send data from the stack.\n",n);
    oxSendOXheader(ostream,OX_DATA,SerialOX++);
    oxSendCmoString(ostream,Sm1_popString());
    if (message) fprintf(stderr,"Done.\n");
    break;
  case SM_shutdown:
  case SM_beginBlock:
  case SM_endBlock:
    fprintf(stderr,"This command has not yet been implemented.\n");
    return(-1);
    break;
  default:
    fprintf(stderr,"Fatal error. Unknown function_id %d\n",id);
    return(-1);
    break;
  }
  return(0);
}

      
nullserver_simplest(int fd) {
  int c;
  while(1) {
    c = readOneByte(fd);
    if (c == '@') { return; }
  }
}


void controlResetHandler(sig)
int sig;
{
  signal(sig,SIG_IGN);
  fprintf(stderr,"From controlResetHandler. OxCritical = %d\n",OxCritical);
  OxInterruptFlag = 1;
  if (OxCritical) {
    return;
  }else{
    longjmp(EnvOfChildServer,2); /* returns 2 for ctrl-C */
  }
}

